<?php

if (!function_exists('highrise_mikado_woocommerce_options_map')) {

    /**
     * Add Woocommerce options page
     */
    function highrise_mikado_woocommerce_options_map() {

        highrise_mikado_add_admin_page(
            array(
                'slug' => '_woocommerce_page',
                'title' =>esc_html__( 'Woocommerce','highrise'),
                'icon' => 'fa fa-shopping-cart'
            )
        );

        /**
         * Product List Settings
         */
        $panel_product_list = highrise_mikado_add_admin_panel(
            array(
                'page' => '_woocommerce_page',
                'name' => 'panel_product_list',
                'title' => esc_html__('Product List', 'highrise'),
            )
        );

        highrise_mikado_add_admin_field(array(
            'name' => 'mkd_woo_product_list_columns',
            'type' => 'select',
            'label' => esc_html__('Product List Columns', 'highrise'),
            'default_value' => 'mkd-woocommerce-columns-4',
            'description' => esc_html__('Choose number of columns for product listing and related products on single product', 'highrise'),
            'options' => array(
                'mkd-woocommerce-columns-3' => esc_html__('3 Columns (2 with sidebar)', 'highrise'),
                'mkd-woocommerce-columns-4' => esc_html__('4 Columns (3 with sidebar)', 'highrise')
            ),
            'parent' => $panel_product_list,
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'mkd_woo_products_per_page',
            'type' => 'text',
            'label' => esc_html__('Number of products per page', 'highrise'),
            'default_value' => '',
            'description' => esc_html__('Set number of products on shop page', 'highrise'),
            'parent' => $panel_product_list,
            'args' => array(
                'col_width' => 3
            )
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'mkd_products_list_title_tag',
            'type' => 'select',
            'label' => esc_html__('Products Title Tag', 'highrise'),
            'default_value' => 'h5',
            'description' => '',
            'options' => array(
                'h2' => 'h2',
                'h3' => 'h3',
                'h4' => 'h4',
                'h5' => 'h5',
                'h6' => 'h6',
            ),
            'parent' => $panel_product_list,
        ));

        /**
         * Single Product Settings
         */
        $panel_single_product = highrise_mikado_add_admin_panel(
            array(
                'page' => '_woocommerce_page',
                'name' => 'panel_single_product',
                'title' => esc_html__('Single Product', 'highrise')
            )
        );

        highrise_mikado_add_admin_field(array(
            'name' => 'mkd_single_product_title_tag',
            'type' => 'select',
            'label' => esc_html__('Single Product Title Tag', 'highrise'),
            'default_value' => 'h2',
            'description' => '',
            'options' => array(
                'h2' => 'h2',
                'h3' => 'h3',
                'h4' => 'h4',
                'h5' => 'h5',
                'h6' => 'h6',
            ),
            'parent' => $panel_single_product,
        ));

        /**
         * DropDown Cart Widget Settings
         */
        $panel_dropdown_cart = highrise_mikado_add_admin_panel(
            array(
                'page' => '_woocommerce_page',
                'name' => 'panel_dropdown_cart',
                'title' => esc_html__('Dropdown Cart Widget', 'highrise')
            )
        );

        highrise_mikado_add_admin_field(array(
            'name' => 'mkd_woo_dropdown_cart_description',
            'type' => 'text',
            'label' => esc_html__('Cart Description', 'highrise'),
            'default_value' => '',
            'description' => esc_html__('Enter dropdown cart description', 'highrise'),
            'parent' => $panel_dropdown_cart
        ));
    }

    add_action('highrise_mikado_options_map', 'highrise_mikado_woocommerce_options_map', 25);
}