<?php

/**
 * Widget that adds separator boxes type
 *
 * Class Separator_Widget
 */
class HighriseMikadoSeparatorWidget extends HighriseMikadoWidget
{
    /**
     * Set basic widget options and call parent class construct
     */
    public function __construct() {
        parent::__construct(
            'mkd_separator_widget', // Base ID
            esc_html__('Mikado Separator Widget', 'highrise') // Name
        );

        $this->setParams();
    }

    /**
     * Sets widget options
     */
    protected function setParams() {
        $this->params = array(
            array(
                'type' => 'dropdown',
                'title' => esc_html__('Type', 'highrise'),
                'name' => 'type',
                'options' => array(
                    'normal' => esc_html__('Normal', 'highrise'),
                    'full-width' => esc_html__('Full Width', 'highrise')
                )
            ),
            array(
                'type' => 'dropdown',
                'title' => esc_html__('Position', 'highrise'),
                'name' => 'position',
                'options' => array(
                    'center' => esc_html__('Center', 'highrise'),
                    'left' => esc_html__('Left', 'highrise'),
                    'right' => esc_html__('Right', 'highrise')
                )
            ),
            array(
                'type' => 'dropdown',
                'title' => esc_html__('Style', 'highrise'),
                'name' => 'border_style',
                'options' => array(
                    'solid' => esc_html__('Solid', 'highrise'),
                    'dashed' => esc_html__('Dashed', 'highrise'),
                    'dotted' => esc_html__('Dotted', 'highrise')
                )
            ),
            array(
                'type' => 'textfield',
                'title' => esc_html__('Color', 'highrise'),
                'name' => 'color'
            ),
            array(
                'type' => 'textfield',
                'title' => esc_html__('Width', 'highrise'),
                'name' => 'width',
                'description' => ''
            ),
            array(
                'type' => 'textfield',
                'title' => esc_html__('Thickness (px)', 'highrise'),
                'name' => 'thickness',
                'description' => ''
            ),
            array(
                'type' => 'textfield',
                'title' => esc_html__('Top Margin', 'highrise'),
                'name' => 'top_margin',
                'description' => ''
            ),
            array(
                'type' => 'textfield',
                'title' => esc_html__('Bottom Margin', 'highrise'),
                'name' => 'bottom_margin',
                'description' => ''
            )
        );
    }

    /**
     * Generates widget's HTML
     *
     * @param array $args args from widget area
     * @param array $instance widget's options
     */
    public function widget($args, $instance) {

        extract($args);

        //prepare variables
        $params = '';

        //is instance empty?
        if (is_array($instance) && count($instance)) {
            //generate shortcode params
            foreach ($instance as $key => $value) {
                $params .= " $key='$value' ";
            }
        }

        echo '<div class="widget mkd-separator-widget">';

        //finally call the shortcode
        echo do_shortcode("[mkd_separator $params]"); // XSS OK

        echo '</div>'; //close div.mkd-separator-widget
    }

    /*
     * override widget title interface rendering
    */
    protected function widget_title($title) {
        return '';
    }
}