<?php

if ( ! function_exists('highrise_mikado_title_options_map') ) {

	function highrise_mikado_title_options_map() {

		highrise_mikado_add_admin_page(
			array(
				'slug' => '_title_page',
				'title' =>esc_html__( 'Title','highrise'),
				'icon' => 'fa fa-list-alt'
			)
		);

		$panel_title = highrise_mikado_add_admin_panel(
			array(
				'page' => '_title_page',
				'name' => 'panel_title',
				'title' =>esc_html__( 'Title Settings','highrise')
			)
		);

		highrise_mikado_add_admin_field(
			array(
				'name' => 'show_title_area',
				'type' => 'yesno',
				'default_value' => 'yes',
				'label' =>esc_html__( 'Show Title Area','highrise'),
				'description' => esc_html__('This option will enable/disable Title Area','highrise'),
				'parent' => $panel_title,
				'args' => array(
					"dependence" => true,
					"dependence_hide_on_yes" => "",
					"dependence_show_on_yes" => "#mkd_show_title_area_container"
				)
			)
		);

		$show_title_area_container = highrise_mikado_add_admin_container(
			array(
				'parent' => $panel_title,
				'name' => 'show_title_area_container',
				'hidden_property' => 'show_title_area',
				'hidden_value' => 'no'
			)
		);

		highrise_mikado_add_admin_field(
			array(
				'name' => 'title_area_type',
				'type' => 'select',
				'default_value' => 'standard',
				'label' =>esc_html__( 'Title Area Type','highrise'),
				'description' =>esc_html__( 'Choose title type','highrise'),
				'parent' => $show_title_area_container,
				'options' => array(
					'standard' =>esc_html__( 'Standard','highrise'),
					'breadcrumb' =>esc_html__( 'Breadcrumb','highrise')
				),
				'args' => array(
					"dependence" => true,
					"hide" => array(
						"standard" => "",
						"breadcrumb" => "#mkd_title_area_type_container"
					),
					"show" => array(
						"standard" => "#mkd_title_area_type_container",
						"breadcrumb" => ""
					)
				)
			)
		);

		$title_area_type_container = highrise_mikado_add_admin_container(
			array(
				'parent' => $show_title_area_container,
				'name' => 'title_area_type_container',
				'hidden_property' => 'title_area_type',
				'hidden_value' => '',
				'hidden_values' => array('breadcrumb'),
			)
		);

		highrise_mikado_add_admin_field(
			array(
				'name' => 'title_area_enable_breadcrumbs',
				'type' => 'yesno',
				'default_value' => 'no',
				'label' => esc_html__('Enable Breadcrumbs','highrise'),
				'description' =>esc_html__( 'This option will display Breadcrumbs in Title Area','highrise'),
				'parent' => $title_area_type_container,
			)
		);

        highrise_mikado_add_admin_field(
            array(
                'name' => 'title_area_separator',
                'type' => 'yesno',
                'default_value' => 'no',
                'label' => esc_html__('Enable Separator','highrise'),
                'description' => esc_html__('This option will display Separator in Title Area','highrise'),
                'parent' => $title_area_type_container,
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'name' => 'title_area_width',
                'type' => 'text',
                'default_value' => '',
                'label'			=> esc_html__('Width','highrise'),
                'description'   => esc_html__('This option will set maximum content width in Title Area ("px" or "%")','highrise'),
                'parent' => $title_area_type_container,
                'args' => array(
                    'col_width' => 3
                )
            )
        );

		highrise_mikado_add_admin_field(
			array(
				'name' => 'title_area_animation',
				'type' => 'select',
				'default_value' => 'no',
				'label' => esc_html__( 'Animations','highrise'),
				'description' => esc_html__('Choose an animation for Title Area','highrise'),
				'parent' => $show_title_area_container,
				'options' => array(
					'no' => esc_html__('No Animation','highrise'),
					'right-left' => esc_html__('Text right to left','highrise'),
					'left-right' =>esc_html__( 'Text left to right','highrise')
				)
			)
		);

		highrise_mikado_add_admin_field(
			array(
				'name' => 'title_area_vertial_alignment',
				'type' => 'select',
				'default_value' => 'header_bottom',
				'label' => esc_html__('Vertical Alignment','highrise'),
				'description' => esc_html__('Specify title vertical alignment','highrise'),
				'parent' => $show_title_area_container,
				'options' => array(
					'header_bottom' => esc_html__('From Bottom of Header','highrise'),
					'window_top' => esc_html__('From Window Top','highrise')
				)
			)
		);

		highrise_mikado_add_admin_field(
			array(
				'name' => 'title_area_content_alignment',
				'type' => 'select',
				'default_value' => 'left',
				'label' =>esc_html__( 'Horizontal Alignment','highrise'),
				'description' =>esc_html__( 'Specify title horizontal alignment','highrise'),
				'parent' => $show_title_area_container,
				'options' => array(
					'left' => esc_html__('Left','highrise'),
					'center' => esc_html__('Center','highrise'),
					'right' => esc_html__('Right','highrise')
				)
			)
		);

		highrise_mikado_add_admin_field(
			array(
				'name' => 'title_area_background_color',
				'type' => 'color',
				'label' =>esc_html__( 'Background Color','highrise'),
				'description' =>esc_html__( 'Choose a background color for Title Area','highrise'),
				'parent' => $show_title_area_container
			)
		);

		highrise_mikado_add_admin_field(
			array(
				'name' => 'title_area_background_image',
				'type' => 'image',
				'label' =>esc_html__( 'Background Image','highrise'),
				'description' =>esc_html__( 'Choose an Image for Title Area','highrise'),
				'parent' => $show_title_area_container
			)
		);

		highrise_mikado_add_admin_field(
			array(
				'name' => 'title_area_background_image_responsive',
				'type' => 'yesno',
				'default_value' => 'no',
				'label' => esc_html__('Background Responsive Image','highrise'),
				'description' => esc_html__('Enabling this option will make Title background image responsive','highrise'),
				'parent' => $show_title_area_container,
				'args' => array(
					"dependence" => true,
					"dependence_hide_on_yes" => "#mkd_title_area_background_image_responsive_container",
					"dependence_show_on_yes" => ""
				)
			)
		);

		$title_area_background_image_responsive_container = highrise_mikado_add_admin_container(
			array(
				'parent' => $show_title_area_container,
				'name' => 'title_area_background_image_responsive_container',
				'hidden_property' => 'title_area_background_image_responsive',
				'hidden_value' => 'yes'
			)
		);

		highrise_mikado_add_admin_field(
			array(
				'name' => 'title_area_background_image_parallax',
				'type' => 'select',
				'default_value' => 'no',
				'label' => esc_html__('Background Image in Parallax','highrise'),
				'description' =>esc_html__( 'Enabling this option will make Title background image parallax','highrise'),
				'parent' => $title_area_background_image_responsive_container,
				'options' => array(
					'no' => esc_html__('No','highrise'),
					'yes' =>esc_html__( 'Yes','highrise'),
					'yes_zoom' => esc_html__('Yes, with zoom out','highrise')
				)
			)
		);

		highrise_mikado_add_admin_field(array(
			'name' => 'title_area_height',
			'type' => 'text',
			'label' => esc_html__('Height','highrise'),
			'description' => esc_html__('Set a height for Title Area','highrise'),
			'parent' => $title_area_background_image_responsive_container,
			'args' => array(
				'col_width' => 3,
				'suffix' => 'px'
			)
		));


		$panel_typography = highrise_mikado_add_admin_panel(
			array(
				'page' => '_title_page',
				'name' => 'panel_title_typography',
				'title' => esc_html__('Typography','highrise')
			)
		);

		$group_page_title_styles = highrise_mikado_add_admin_group(array(
			'name'			=> 'group_page_title_styles',
			'title'			=> esc_html__('Title','highrise'),
			'description'	=> esc_html__('Define styles for page title','highrise'),
			'parent'		=> $panel_typography
		));

		$row_page_title_styles_1 = highrise_mikado_add_admin_row(array(
			'name'		=> 'row_page_title_styles_1',
			'parent'	=> $group_page_title_styles
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'colorsimple',
			'name'			=> 'page_title_color',
			'default_value'	=> '',
			'label'			=>esc_html__( 'Text Color','highrise'),
			'parent'		=> $row_page_title_styles_1
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'textsimple',
			'name'			=> 'page_title_fontsize',
			'default_value'	=> '',
			'label'			=>esc_html__( 'Font Size','highrise'),
			'args'			=> array(
				'suffix'	=> 'px'
			),
			'parent'		=> $row_page_title_styles_1
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'textsimple',
			'name'			=> 'page_title_lineheight',
			'default_value'	=> '',
			'label'			=>esc_html__( 'Line Height','highrise'),
			'args'			=> array(
				'suffix'	=> 'px'
			),
			'parent'		=> $row_page_title_styles_1
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'selectblanksimple',
			'name'			=> 'page_title_texttransform',
			'default_value'	=> '',
			'label'			=> esc_html__('Text Transform','highrise'),
			'options'		=> highrise_mikado_get_text_transform_array(),
			'parent'		=> $row_page_title_styles_1
		));

		$row_page_title_styles_2 = highrise_mikado_add_admin_row(array(
			'name'		=> 'row_page_title_styles_2',
			'parent'	=> $group_page_title_styles,
			'next'		=> true
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'fontsimple',
			'name'			=> 'page_title_google_fonts',
			'default_value'	=> '-1',
			'label'			=>esc_html__( 'Font Family','highrise'),
			'parent'		=> $row_page_title_styles_2
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'selectblanksimple',
			'name'			=> 'page_title_fontstyle',
			'default_value'	=> '',
			'label'			=> esc_html__('Font Style','highrise'),
			'options'		=> highrise_mikado_get_font_style_array(),
			'parent'		=> $row_page_title_styles_2
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'selectblanksimple',
			'name'			=> 'page_title_fontweight',
			'default_value'	=> '',
			'label'			=>esc_html__( 'Font Weight','highrise'),
			'options'		=> highrise_mikado_get_font_weight_array(),
			'parent'		=> $row_page_title_styles_2
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'textsimple',
			'name'			=> 'page_title_letter_spacing',
			'default_value'	=> '',
			'label'			=> esc_html__('Letter Spacing','highrise'),
			'args'			=> array(
				'suffix'	=> 'px'
			),
			'parent'		=> $row_page_title_styles_2
		));

		$group_page_subtitle_styles = highrise_mikado_add_admin_group(array(
			'name'			=> 'group_page_subtitle_styles',
			'title'			=> esc_html__('Subtitle','highrise'),
			'description'	=> esc_html__('Define styles for page subtitle','highrise'),
			'parent'		=> $panel_typography
		));

		$row_page_subtitle_styles_1 = highrise_mikado_add_admin_row(array(
			'name'		=> 'row_page_subtitle_styles_1',
			'parent'	=> $group_page_subtitle_styles
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'colorsimple',
			'name'			=> 'page_subtitle_color',
			'default_value'	=> '',
			'label'			=>esc_html__( 'Text Color','highrise'),
			'parent'		=> $row_page_subtitle_styles_1
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'textsimple',
			'name'			=> 'page_subtitle_fontsize',
			'default_value'	=> '',
			'label'			=> esc_html__('Font Size','highrise'),
			'args'			=> array(
				'suffix'	=> 'px'
			),
			'parent'		=> $row_page_subtitle_styles_1
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'textsimple',
			'name'			=> 'page_subtitle_lineheight',
			'default_value'	=> '',
			'label'			=> esc_html__('Line Height','highrise'),
			'args'			=> array(
				'suffix'	=> 'px'
			),
			'parent'		=> $row_page_subtitle_styles_1
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'selectblanksimple',
			'name'			=> 'page_subtitle_texttransform',
			'default_value'	=> '',
			'label'			=> esc_html__('Text Transform','highrise'),
			'options'		=> highrise_mikado_get_text_transform_array(),
			'parent'		=> $row_page_subtitle_styles_1
		));

		$row_page_subtitle_styles_2 = highrise_mikado_add_admin_row(array(
			'name'		=> 'row_page_subtitle_styles_2',
			'parent'	=> $group_page_subtitle_styles,
			'next'		=> true
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'fontsimple',
			'name'			=> 'page_subtitle_google_fonts',
			'default_value'	=> '-1',
			'label'			=> esc_html__('Font Family','highrise'),
			'parent'		=> $row_page_subtitle_styles_2
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'selectblanksimple',
			'name'			=> 'page_subtitle_fontstyle',
			'default_value'	=> '',
			'label'			=>esc_html__( 'Font Style','highrise'),
			'options'		=> highrise_mikado_get_font_style_array(),
			'parent'		=> $row_page_subtitle_styles_2
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'selectblanksimple',
			'name'			=> 'page_subtitle_fontweight',
			'default_value'	=> '',
			'label'			=>esc_html__( 'Font Weight','highrise'),
			'options'		=> highrise_mikado_get_font_weight_array(),
			'parent'		=> $row_page_subtitle_styles_2
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'textsimple',
			'name'			=> 'page_subtitle_letter_spacing',
			'default_value'	=> '',
			'label'			=> esc_html__('Letter Spacing','highrise'),
			'args'			=> array(
				'suffix'	=> 'px'
			),
			'parent'		=> $row_page_subtitle_styles_2
		));


        $group_page_title_separator_styles = highrise_mikado_add_admin_group(array(
            'name'			=> 'group_page_title_separator',
            'title'			=> esc_html__('Separator','highrise'),
            'description'	=> esc_html__('Define styles for page title separator','highrise'),
            'parent'		=> $panel_typography
        ));

        $row_page_title_separator_styles_1 = highrise_mikado_add_admin_row(array(
            'name'		=> 'row_page_title_separator_styles_1',
            'parent'	=> $group_page_title_separator_styles
        ));

        highrise_mikado_add_admin_field(array(
            'type'			=> 'colorsimple',
            'name'			=> 'page_title_separator_color',
            'default_value'	=> '',
            'label'			=> esc_html__( 'Color','highrise'),
            'parent'		=> $row_page_title_separator_styles_1
        ));

        highrise_mikado_add_admin_field(array(
            'type'			=> 'textsimple',
            'name'			=> 'page_title_separator_width',
            'default_value'	=> '',
            'label'			=> esc_html__('Width','highrise'),
            'args'			=> array(
                'suffix'	=> 'px'
            ),
            'parent'		=> $row_page_title_separator_styles_1
        ));

        highrise_mikado_add_admin_field(array(
            'type'			=> 'textsimple',
            'name'			=> 'page_title_separator_thickness',
            'default_value'	=> '',
            'label'			=> esc_html__('Thickness','highrise'),
            'args'			=> array(
                'suffix'	=> 'px'
            ),
            'parent'		=> $row_page_title_separator_styles_1
        ));

        $row_page_separator_styles_2 = highrise_mikado_add_admin_row(array(
            'name'		=> 'row_page_title_separator_styles_2',
            'parent'	=> $group_page_title_separator_styles,
            'next'		=> true
        ));

        highrise_mikado_add_admin_field(array(
            'type'			=> 'textsimple',
            'name'			=> 'page_title_separator_margin_top',
            'default_value'	=> '',
            'label'			=> esc_html__('Margin Top','highrise'),
            'args'			=> array(
                'suffix'	=> 'px'
            ),
            'parent'		=> $row_page_separator_styles_2
        ));

        highrise_mikado_add_admin_field(array(
            'type'			=> 'textsimple',
            'name'			=> 'page_title_separator_margin_bottom',
            'default_value'	=> '',
            'label'			=> esc_html__('Margin Bottom','highrise'),
            'args'			=> array(
                'suffix'	=> 'px'
            ),
            'parent'		=> $row_page_separator_styles_2
        ));

		$group_page_breadcrumbs_styles = highrise_mikado_add_admin_group(array(
			'name'			=> 'group_page_breadcrumbs_styles',
			'title'			=> esc_html__('Breadcrumbs','highrise'),
			'description'	=>esc_html__( 'Define styles for page breadcrumbs','highrise'),
			'parent'		=> $panel_typography
		));

		$row_page_breadcrumbs_styles_1 = highrise_mikado_add_admin_row(array(
			'name'		=> 'row_page_breadcrumbs_styles_1',
			'parent'	=> $group_page_breadcrumbs_styles
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'colorsimple',
			'name'			=> 'page_breadcrumb_color',
			'default_value'	=> '',
			'label'			=> esc_html__('Text Color','highrise'),
			'parent'		=> $row_page_breadcrumbs_styles_1
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'textsimple',
			'name'			=> 'page_breadcrumb_fontsize',
			'default_value'	=> '',
			'label'			=>esc_html__( 'Font Size','highrise'),
			'args'			=> array(
				'suffix'	=> 'px'
			),
			'parent'		=> $row_page_breadcrumbs_styles_1
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'textsimple',
			'name'			=> 'page_breadcrumb_lineheight',
			'default_value'	=> '',
			'label'			=> esc_html__('Line Height','highrise'),
			'args'			=> array(
				'suffix'	=> 'px'
			),
			'parent'		=> $row_page_breadcrumbs_styles_1
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'selectblanksimple',
			'name'			=> 'page_breadcrumb_texttransform',
			'default_value'	=> '',
			'label'			=> esc_html__('Text Transform','highrise'),
			'options'		=> highrise_mikado_get_text_transform_array(),
			'parent'		=> $row_page_breadcrumbs_styles_1
		));

		$row_page_breadcrumbs_styles_2 = highrise_mikado_add_admin_row(array(
			'name'		=> 'row_page_breadcrumbs_styles_2',
			'parent'	=> $group_page_breadcrumbs_styles,
			'next'		=> true
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'fontsimple',
			'name'			=> 'page_breadcrumb_google_fonts',
			'default_value'	=> '-1',
			'label'			=> esc_html__('Font Family','highrise'),
			'parent'		=> $row_page_breadcrumbs_styles_2
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'selectblanksimple',
			'name'			=> 'page_breadcrumb_fontstyle',
			'default_value'	=> '',
			'label'			=> esc_html__('Font Style','highrise'),
			'options'		=> highrise_mikado_get_font_style_array(),
			'parent'		=> $row_page_breadcrumbs_styles_2
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'selectblanksimple',
			'name'			=> 'page_breadcrumb_fontweight',
			'default_value'	=> '',
			'label'			=>esc_html__( 'Font Weight','highrise'),
			'options'		=> highrise_mikado_get_font_weight_array(),
			'parent'		=> $row_page_breadcrumbs_styles_2
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'textsimple',
			'name'			=> 'page_breadcrumb_letter_spacing',
			'default_value'	=> '',
			'label'			=> esc_html__('Letter Spacing','highrise'),
			'args'			=> array(
				'suffix'	=> 'px'
			),
			'parent'		=> $row_page_breadcrumbs_styles_2
		));

		$row_page_breadcrumbs_styles_3 = highrise_mikado_add_admin_row(array(
			'name'		=> 'row_page_breadcrumbs_styles_3',
			'parent'	=> $group_page_breadcrumbs_styles,
			'next'		=> true
		));

		highrise_mikado_add_admin_field(array(
			'type'			=> 'colorsimple',
			'name'			=> 'page_breadcrumb_hovercolor',
			'default_value'	=> '',
			'label'			=> esc_html__('Hover/Active Color','highrise'),
			'parent'		=> $row_page_breadcrumbs_styles_3
		));

	}

	add_action( 'highrise_mikado_options_map', 'highrise_mikado_title_options_map', 6);

}