<?php

if (!function_exists('highrise_mikado_title_area_typography_style')) {

    function highrise_mikado_title_area_typography_style(){

        $title_styles = array();

        if(highrise_mikado_options()->getOptionValue('page_title_color') !== '') {
            $title_styles['color'] = highrise_mikado_options()->getOptionValue('page_title_color');
        }
        if(highrise_mikado_options()->getOptionValue('page_title_google_fonts') !== '-1') {
            $title_styles['font-family'] = highrise_mikado_get_formatted_font_family(highrise_mikado_options()->getOptionValue('page_title_google_fonts'));
        }
        if(highrise_mikado_options()->getOptionValue('page_title_fontsize') !== '') {
            $title_styles['font-size'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('page_title_fontsize')).'px';
        }
        if(highrise_mikado_options()->getOptionValue('page_title_lineheight') !== '') {
            $title_styles['line-height'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('page_title_lineheight')).'px';
        }
        if(highrise_mikado_options()->getOptionValue('page_title_texttransform') !== '') {
            $title_styles['text-transform'] = highrise_mikado_options()->getOptionValue('page_title_texttransform');
        }
        if(highrise_mikado_options()->getOptionValue('page_title_fontstyle') !== '') {
            $title_styles['font-style'] = highrise_mikado_options()->getOptionValue('page_title_fontstyle');
        }
        if(highrise_mikado_options()->getOptionValue('page_title_fontweight') !== '') {
            $title_styles['font-weight'] = highrise_mikado_options()->getOptionValue('page_title_fontweight');
        }
        if(highrise_mikado_options()->getOptionValue('page_title_letter_spacing') !== '') {
            $title_styles['letter-spacing'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('page_title_letter_spacing')).'px';
        }

        $title_selector = array(
            '.mkd-title .mkd-title-holder h1'
        );

        echo highrise_mikado_dynamic_css($title_selector, $title_styles);


        $subtitle_styles = array();

        if(highrise_mikado_options()->getOptionValue('page_subtitle_color') !== '') {
            $subtitle_styles['color'] = highrise_mikado_options()->getOptionValue('page_subtitle_color');
        }
        if(highrise_mikado_options()->getOptionValue('page_subtitle_google_fonts') !== '-1') {
            $subtitle_styles['font-family'] = highrise_mikado_get_formatted_font_family(highrise_mikado_options()->getOptionValue('page_subtitle_google_fonts'));
        }
        if(highrise_mikado_options()->getOptionValue('page_subtitle_fontsize') !== '') {
            $subtitle_styles['font-size'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('page_subtitle_fontsize')).'px';
        }
        if(highrise_mikado_options()->getOptionValue('page_subtitle_lineheight') !== '') {
            $subtitle_styles['line-height'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('page_subtitle_lineheight')).'px';
        }
        if(highrise_mikado_options()->getOptionValue('page_subtitle_texttransform') !== '') {
            $subtitle_styles['text-transform'] = highrise_mikado_options()->getOptionValue('page_subtitle_texttransform');
        }
        if(highrise_mikado_options()->getOptionValue('page_subtitle_fontstyle') !== '') {
            $subtitle_styles['font-style'] = highrise_mikado_options()->getOptionValue('page_subtitle_fontstyle');
        }
        if(highrise_mikado_options()->getOptionValue('page_subtitle_fontweight') !== '') {
            $subtitle_styles['font-weight'] = highrise_mikado_options()->getOptionValue('page_subtitle_fontweight');
        }
        if(highrise_mikado_options()->getOptionValue('page_subtitle_letter_spacing') !== '') {
            $subtitle_styles['letter-spacing'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('page_subtitle_letter_spacing')).'px';
        }

        $subtitle_selector = array(
            '.mkd-title .mkd-title-holder .mkd-subtitle'
        );

        echo highrise_mikado_dynamic_css($subtitle_selector, $subtitle_styles);


        $breadcrumb_styles = array();

        if(highrise_mikado_options()->getOptionValue('page_breadcrumb_color') !== '') {
            $breadcrumb_styles['color'] = highrise_mikado_options()->getOptionValue('page_breadcrumb_color');
        }
        if(highrise_mikado_options()->getOptionValue('page_breadcrumb_google_fonts') !== '-1') {
            $breadcrumb_styles['font-family'] = highrise_mikado_get_formatted_font_family(highrise_mikado_options()->getOptionValue('page_breadcrumb_google_fonts'));
        }
        if(highrise_mikado_options()->getOptionValue('page_breadcrumb_fontsize') !== '') {
            $breadcrumb_styles['font-size'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('page_breadcrumb_fontsize')).'px';
        }
        if(highrise_mikado_options()->getOptionValue('page_breadcrumb_lineheight') !== '') {
            $breadcrumb_styles['line-height'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('page_breadcrumb_lineheight')).'px';
        }
        if(highrise_mikado_options()->getOptionValue('page_breadcrumb_texttransform') !== '') {
            $breadcrumb_styles['text-transform'] = highrise_mikado_options()->getOptionValue('page_breadcrumb_texttransform');
        }
        if(highrise_mikado_options()->getOptionValue('page_breadcrumb_fontstyle') !== '') {
            $breadcrumb_styles['font-style'] = highrise_mikado_options()->getOptionValue('page_breadcrumb_fontstyle');
        }
        if(highrise_mikado_options()->getOptionValue('page_breadcrumb_fontweight') !== '') {
            $breadcrumb_styles['font-weight'] = highrise_mikado_options()->getOptionValue('page_breadcrumb_fontweight');
        }
        if(highrise_mikado_options()->getOptionValue('page_breadcrumb_letter_spacing') !== '') {
            $breadcrumb_styles['letter-spacing'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('page_breadcrumb_letter_spacing')).'px';
        }

        $breadcrumb_selector = array(
            '.mkd-title .mkd-title-holder .mkd-breadcrumbs a, .mkd-title .mkd-title-holder .mkd-breadcrumbs span'
        );

        echo highrise_mikado_dynamic_css($breadcrumb_selector, $breadcrumb_styles);

        $breadcrumb_selector_styles = array();
        if(highrise_mikado_options()->getOptionValue('page_breadcrumb_hovercolor') !== '') {
            $breadcrumb_selector_styles['color'] = highrise_mikado_options()->getOptionValue('page_breadcrumb_hovercolor');
        }

        $breadcrumb_hover_selector = array(
            '.mkd-title .mkd-title-holder .mkd-breadcrumbs a:hover'
        );

        echo highrise_mikado_dynamic_css($breadcrumb_hover_selector, $breadcrumb_selector_styles);


        $title_width_styles = array();
        if(highrise_mikado_options()->getOptionValue('title_area_width') !== '') {
            $title_width_styles['max-width'] = highrise_mikado_options()->getOptionValue('title_area_width');
        }

        $title_width_selector = array(
            '.mkd-title .mkd-title-holder .mkd-title-subtitle-holder'
        );

        echo highrise_mikado_dynamic_css($title_width_selector, $title_width_styles);

        $title_separator_styles = array();
        if(highrise_mikado_options()->getOptionValue('page_title_separator_color') !== '') {
            $title_separator_styles['border-color'] = highrise_mikado_options()->getOptionValue('page_title_separator_color');
        }
        if(highrise_mikado_options()->getOptionValue('page_title_separator_width') !== '') {
            $title_separator_styles['width'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('page_title_separator_width')).'px';
        }
        if(highrise_mikado_options()->getOptionValue('page_title_separator_thickness') !== '') {
            $title_separator_styles['border-bottom-width'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('page_title_separator_thickness')).'px';
        }
        if(highrise_mikado_options()->getOptionValue('page_title_separator_margin_top') !== '') {
            $title_separator_styles['margin-top'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('page_title_separator_margin_top')).'px';
        }
        if(highrise_mikado_options()->getOptionValue('page_title_separator_margin_bottom') !== '') {
            $title_separator_styles['margin-bottom'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('page_title_separator_margin_bottom')).'px';
        }

        $title_separator_selector = array(
            '.mkd-title .mkd-separator-holder .mkd-separator'
        );

        echo highrise_mikado_dynamic_css($title_separator_selector, $title_separator_styles);

    }

    add_action('highrise_mikado_style_dynamic', 'highrise_mikado_title_area_typography_style');

}


