<?php
if (!function_exists('highrise_mikado_register_side_area_sidebar')) {
    /**
     * Register side area sidebar
     */
    function highrise_mikado_register_side_area_sidebar() {

        register_sidebar(array(
            'name' => esc_html__('Side Area', 'highrise'),
            'id' => 'sidearea', //TODO Change name of sidebar
            'description' => esc_html__('Side Area', 'highrise'),
            'before_widget' => '<div id="%1$s" class="widget mkd-sidearea %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h5 class="mkd-sidearea-widget-title">',
            'after_title' => '</h5>'
        ));

    }

    add_action('widgets_init', 'highrise_mikado_register_side_area_sidebar');

}

if (!function_exists('highrise_mikado_side_menu_body_class')) {
    /**
     * Function that adds body classes for different side menu styles
     *
     * @param $classes array original array of body classes
     *
     * @return array modified array of classes
     */
    function highrise_mikado_side_menu_body_class($classes) {

        if (is_active_widget(false, false, 'mkd_side_area_opener')) {

            if (highrise_mikado_options()->getOptionValue('side_area_type')) {

                $classes[] = 'mkd-' . highrise_mikado_options()->getOptionValue('side_area_type');

                if (highrise_mikado_options()->getOptionValue('side_area_type') === 'side-menu-slide-with-content') {

                    $classes[] = 'mkd-' . highrise_mikado_options()->getOptionValue('side_area_slide_with_content_width');

                }

            }

        }

        return $classes;

    }

    add_filter('body_class', 'highrise_mikado_side_menu_body_class');
}


if (!function_exists('highrise_mikado_get_side_area')) {
    /**
     * Loads side area HTML
     */
    function highrise_mikado_get_side_area() {

        if (is_active_widget(false, false, 'mkd_side_area_opener')) {

            highrise_mikado_get_module_template_part('templates/sidearea', 'sidearea');

        }

    }

}

if (!function_exists('highrise_mikado_get_side_menu_icon_html')) {
    /**
     * Function that outputs html for side area icon opener.
     * Uses $highrise_IconCollections global variable
     * @return string generated html
     */
    function highrise_mikado_get_side_menu_icon_html() {

        $icon_html = '';

        if (highrise_mikado_options()->getOptionValue('side_area_button_icon_pack') !== '') {
            $icon_pack = highrise_mikado_options()->getOptionValue('side_area_button_icon_pack');

            $icons = highrise_mikado_icon_collections()->getIconCollection($icon_pack);
            $icon_options_field = 'side_area_icon_' . $icons->param;

            if (highrise_mikado_options()->getOptionValue($icon_options_field) !== '') {

                $icon = highrise_mikado_options()->getOptionValue($icon_options_field);
                $icon_html = highrise_mikado_icon_collections()->renderIcon($icon, $icon_pack);

            }

        }

        return $icon_html;
    }
}