<?php

if (!function_exists('highrise_mikado_sidearea_options_map')) {

    function highrise_mikado_sidearea_options_map() {

        highrise_mikado_add_admin_page(
            array(
                'slug' => '_side_area_page',
                'title' => esc_html__('Side Area','highrise'),
                'icon' => 'fa fa-bars'
            )
        );

        $side_area_panel = highrise_mikado_add_admin_panel(
            array(
                'title' => esc_html__('Side Area','highrise'),
                'name' => 'side_area',
                'page' => '_side_area_page'
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_panel,
                'type' => 'select',
                'name' => 'side_area_type',
                'default_value' => 'side-menu-slide-from-right',
                'label' =>esc_html__( 'Side Area Type','highrise'),
                'description' => esc_html__('Choose a type of Side Area','highrise'),
                'options' => array(
                    'side-menu-slide-from-right' => 'Slide from Right Over Content',
                    'side-menu-slide-with-content' => 'Slide from Right With Content',
                    'side-area-uncovered-from-content' => 'Side Area Uncovered from Content'
                ),
                'args' => array(
                    'dependence' => true,
                    'hide' => array(
                        'side-menu-slide-from-right' => '#mkd_side_area_slide_with_content_container',
                        'side-menu-slide-with-content' => '#mkd_side_area_width_container',
                        'side-area-uncovered-from-content' => '#mkd_side_area_width_container, #mkd_side_area_slide_with_content_container'
                    ),
                    'show' => array(
                        'side-menu-slide-from-right' => '#mkd_side_area_width_container',
                        'side-menu-slide-with-content' => '#mkd_side_area_slide_with_content_container',
                        'side-area-uncovered-from-content' => ''
                    )
                )
            )
        );

        $side_area_width_container = highrise_mikado_add_admin_container(
            array(
                'parent' => $side_area_panel,
                'name' => 'side_area_width_container',
                'hidden_property' => 'side_area_type',
                'hidden_value' => '',
                'hidden_values' => array(
                    'side-menu-slide-with-content',
                    'side-area-uncovered-from-content'
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_width_container,
                'type' => 'text',
                'name' => 'side_area_width',
                'default_value' => '',
                'label' => esc_html__('Side Area Width','highrise'),
                'description' =>esc_html__( 'Enter a width for Side Area (in percentages, enter more than 25)','highrise'),
                'args' => array(
                    'col_width' => 3,
                    'suffix' => '%'
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_width_container,
                'type' => 'color',
                'name' => 'side_area_content_overlay_color',
                'default_value' => '',
                'label' =>esc_html__( 'Content Overlay Background Color','highrise'),
                'description' =>esc_html__( 'Choose a background color for a content overlay','highrise'),
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_width_container,
                'type' => 'text',
                'name' => 'side_area_content_overlay_opacity',
                'default_value' => '',
                'label' =>esc_html__( 'Content Overlay Background Transparency','highrise'),
                'description' =>esc_html__( 'Choose a transparency for the content overlay background color (0 = fully transparent, 1 = opaque)','highrise'),
                'args' => array(
                    'col_width' => 3
                )
            )
        );

        $side_area_slide_with_content_container = highrise_mikado_add_admin_container(
            array(
                'parent' => $side_area_panel,
                'name' => 'side_area_slide_with_content_container',
                'hidden_property' => 'side_area_type',
                'hidden_value' => '',
                'hidden_values' => array(
                    'side-menu-slide-from-right',
                    'side-area-uncovered-from-content'
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_slide_with_content_container,
                'type' => 'select',
                'name' => 'side_area_slide_with_content_width',
                'default_value' => 'width-470',
                'label' => esc_html__('Side Area Width','highrise'),
                'description' => esc_html__('Choose width for Side Area','highrise'),
                'options' => array(
                    'width-270' => '270px',
                    'width-370' => '370px',
                    'width-470' => '470px'
                )
            )
        );

//init icon pack hide and show array. It will be populated dinamically from collections array
        $side_area_icon_pack_hide_array = array();
        $side_area_icon_pack_show_array = array();

//do we have some collection added in collections array?
        if (is_array(highrise_mikado_icon_collections()->iconCollections) && count(highrise_mikado_icon_collections()->iconCollections)) {
            //get collections params array. It will contain values of 'param' property for each collection
            $side_area_icon_collections_params = highrise_mikado_icon_collections()->getIconCollectionsParams();

            //foreach collection generate hide and show array
            foreach (highrise_mikado_icon_collections()->iconCollections as $dep_collection_key => $dep_collection_object) {
                $side_area_icon_pack_hide_array[$dep_collection_key] = '';

                //we need to include only current collection in show string as it is the only one that needs to show
                $side_area_icon_pack_show_array[$dep_collection_key] = '#mkd_side_area_icon_' . $dep_collection_object->param . '_container';

                //for all collections param generate hide string
                foreach ($side_area_icon_collections_params as $side_area_icon_collections_param) {
                    //we don't need to include current one, because it needs to be shown, not hidden
                    if ($side_area_icon_collections_param !== $dep_collection_object->param) {
                        $side_area_icon_pack_hide_array[$dep_collection_key] .= '#mkd_side_area_icon_' . $side_area_icon_collections_param . '_container,';
                    }
                }

                //remove remaining ',' character
                $side_area_icon_pack_hide_array[$dep_collection_key] = rtrim($side_area_icon_pack_hide_array[$dep_collection_key], ',');
            }

        }

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_panel,
                'type' => 'select',
                'name' => 'side_area_button_icon_pack',
                'default_value' => 'ion_icons',
                'label' =>esc_html__( 'Side Area Button Icon Pack','highrise'),
                'description' =>esc_html__( 'Choose icon pack for side area button','highrise'),
                'options' => highrise_mikado_icon_collections()->getIconCollections(),
                'args' => array(
                    'dependence' => true,
                    'hide' => $side_area_icon_pack_hide_array,
                    'show' => $side_area_icon_pack_show_array,
                )
            )
        );

        if (is_array(highrise_mikado_icon_collections()->iconCollections) && count(highrise_mikado_icon_collections()->iconCollections)) {
            //foreach icon collection we need to generate separate container that will have dependency set
            //it will have one field inside with icons dropdown
            foreach (highrise_mikado_icon_collections()->iconCollections as $collection_key => $collection_object) {
                $icons_array = $collection_object->getIconsArray();

                //get icon collection keys (keys from collections array, e.g 'font_awesome', 'font_elegant' etc.)
                $icon_collections_keys = highrise_mikado_icon_collections()->getIconCollectionsKeys();

                //unset current one, because it doesn't have to be included in dependency that hides icon container
                unset($icon_collections_keys[array_search($collection_key, $icon_collections_keys)]);

                $side_area_icon_hide_values = $icon_collections_keys;

                $side_area_icon_container = highrise_mikado_add_admin_container(
                    array(
                        'parent' => $side_area_panel,
                        'name' => 'side_area_icon_' . $collection_object->param . '_container',
                        'hidden_property' => 'side_area_button_icon_pack',
                        'hidden_value' => '',
                        'hidden_values' => $side_area_icon_hide_values
                    )
                );

                highrise_mikado_add_admin_field(
                    array(
                        'parent' => $side_area_icon_container,
                        'type' => 'select',
                        'name' => 'side_area_icon_' . $collection_object->param,
                        'default_value' => 'ion-android-menu',
                        'label' => esc_html__('Side Area Icon','highrise'),
                        'description' => esc_html__('Choose Side Area Icon','highrise'),
                        'options' => $icons_array,
                        'args' => array(
                            'select2' => true
                        )
                    )
                );

            }

        }

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_panel,
                'type' => 'select',
                'name' => 'side_area_predefined_icon_size',
                'default_value' => 'normal',
                'label' => esc_html__('Predefined Side Area Icon Size','highrise'),
                'description' =>esc_html__( 'Choose predefined size for Side Area icons','highrise'),
                'options' => array(
                    'normal' => esc_html__('Normal','highrise'),
                    'medium' =>esc_html__( 'Medium','highrise'),
                    'large' => esc_html__('Large','highrise')
                ),
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_panel,
                'type' => 'text',
                'name' => 'side_area_icon_font_size',
                'default_value' => '',
                'label' => esc_html__('Side Area Icon Size','highrise'),
                'description' => esc_html__('Choose a size for Side Area (px)','highrise'),
                'args' => array(
                    'col_width' => 3,
                    'suffix' => 'px'
                ),
            )
        );

        $side_area_icon_style_group = highrise_mikado_add_admin_group(
            array(
                'parent' => $side_area_panel,
                'name' => 'side_area_icon_style_group',
                'title' => esc_html__('Side Area Icon Style','highrise'),
                'description' =>esc_html__( 'Define styles for Side Area icon','highrise')
            )
        );

        $side_area_icon_style_row1 = highrise_mikado_add_admin_row(
            array(
                'parent' => $side_area_icon_style_group,
                'name' => 'side_area_icon_style_row1'
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row1,
                'type' => 'colorsimple',
                'name' => 'side_area_icon_color',
                'default_value' => '',
                'label' =>esc_html__( 'Color','highrise'),
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row1,
                'type' => 'colorsimple',
                'name' => 'side_area_icon_hover_color',
                'default_value' => '',
                'label' =>esc_html__( 'Hover Color','highrise'),
            )
        );

        $side_area_icon_style_row2 = highrise_mikado_add_admin_row(
            array(
                'parent' => $side_area_icon_style_group,
                'name' => 'side_area_icon_style_row2',
                'next' => true
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row2,
                'type' => 'colorsimple',
                'name' => 'side_area_light_icon_color',
                'default_value' => '',
                'label' => esc_html__('Light Menu Icon Color','highrise'),
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row2,
                'type' => 'colorsimple',
                'name' => 'side_area_light_icon_hover_color',
                'default_value' => '',
                'label' => esc_html__('Light Menu Icon Hover Color','highrise'),
            )
        );

        $side_area_icon_style_row3 = highrise_mikado_add_admin_row(
            array(
                'parent' => $side_area_icon_style_group,
                'name' => 'side_area_icon_style_row3',
                'next' => true
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row3,
                'type' => 'colorsimple',
                'name' => 'side_area_dark_icon_color',
                'default_value' => '',
                'label' =>esc_html__( 'Dark Menu Icon Color','highrise'),
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row3,
                'type' => 'colorsimple',
                'name' => 'side_area_dark_icon_hover_color',
                'default_value' => '',
                'label' => esc_html__('Dark Menu Icon Hover Color','highrise'),
            )
        );

        $icon_spacing_group = highrise_mikado_add_admin_group(
            array(
                'parent' => $side_area_panel,
                'name' => 'icon_spacing_group',
                'title' => esc_html__('Side Area Icon Spacing','highrise'),
                'description' => esc_html__('Define padding and margin for side area icon','highrise')
            )
        );

        $icon_spacing_row = highrise_mikado_add_admin_row(
            array(
                'parent' => $icon_spacing_group,
                'name' => 'icon_spancing_row',
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $icon_spacing_row,
                'type' => 'textsimple',
                'name' => 'side_area_icon_padding_left',
                'default_value' => '',
                'label' => esc_html__('Padding Left','highrise'),
                'args' => array(
                    'suffix' => 'px'
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $icon_spacing_row,
                'type' => 'textsimple',
                'name' => 'side_area_icon_padding_right',
                'default_value' => '',
                'label' =>esc_html__( 'Padding Right','highrise'),
                'args' => array(
                    'suffix' => 'px'
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $icon_spacing_row,
                'type' => 'textsimple',
                'name' => 'side_area_icon_margin_left',
                'default_value' => '',
                'label' =>esc_html__( 'Margin Left','highrise'),
                'args' => array(
                    'suffix' => 'px'
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $icon_spacing_row,
                'type' => 'textsimple',
                'name' => 'side_area_icon_margin_right',
                'default_value' => '',
                'label' =>esc_html__( 'Margin Right','highrise'),
                'args' => array(
                    'suffix' => 'px'
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_panel,
                'type' => 'yesno',
                'name' => 'side_area_icon_border_yesno',
                'default_value' => 'no',
                'label' => esc_html__('Icon Border','highrise'),
                'descritption' => esc_html__('Enable border around icon','highrise'),
                'args' => array(
                    'dependence' => true,
                    'dependence_hide_on_yes' => '',
                    'dependence_show_on_yes' => '#mkd_side_area_icon_border_container'
                )
            )
        );

        $side_area_icon_border_container = highrise_mikado_add_admin_container(
            array(
                'parent' => $side_area_panel,
                'name' => 'side_area_icon_border_container',
                'hidden_property' => 'side_area_icon_border_yesno',
                'hidden_value' => 'no'
            )
        );

        $border_style_group = highrise_mikado_add_admin_group(
            array(
                'parent' => $side_area_icon_border_container,
                'name' => 'border_style_group',
                'title' => esc_html__('Border Style','highrise'),
                'description' =>esc_html__( 'Define styling for border around icon','highrise')
            )
        );

        $border_style_row_1 = highrise_mikado_add_admin_row(
            array(
                'parent' => $border_style_group,
                'name' => 'border_style_row_1',
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $border_style_row_1,
                'type' => 'colorsimple',
                'name' => 'side_area_icon_border_color',
                'default_value' => '',
                'label' => 'Color',
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $border_style_row_1,
                'type' => 'colorsimple',
                'name' => 'side_area_icon_border_hover_color',
                'default_value' => '',
                'label' =>esc_html__( 'Hover Color','highrise'),
            )
        );

        $border_style_row_2 = highrise_mikado_add_admin_row(
            array(
                'parent' => $border_style_group,
                'name' => 'border_style_row_2',
                'next' => true
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $border_style_row_2,
                'type' => 'textsimple',
                'name' => 'side_area_icon_border_width',
                'default_value' => '',
                'label' =>esc_html__( 'Width','highrise'),
                'args' => array(
                    'suffix' => 'px'
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $border_style_row_2,
                'type' => 'textsimple',
                'name' => 'side_area_icon_border_radius',
                'default_value' => '',
                'label' =>esc_html__( 'Radius','highrise'),
                'args' => array(
                    'suffix' => 'px'
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $border_style_row_2,
                'type' => 'selectsimple',
                'name' => 'side_area_icon_border_style',
                'default_value' => '',
                'label' =>esc_html__( 'Style','highrise'),
                'options' => array(
                    'solid' => esc_html__('Solid','highrise'),
                    'dashed' =>esc_html__( 'Dashed','highrise'),
                    'dotted' => esc_html__('Dotted','highrise')
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_panel,
                'type' => 'selectblank',
                'name' => 'side_area_aligment',
                'default_value' => '',
                'label' => esc_html__('Text Aligment','highrise'),
                'description' => esc_html__('Choose text aligment for side area','highrise'),
                'options' => array(
                    'center' => esc_html__('Center','highrise'),
                    'left' => esc_html__('Left','highrise'),
                    'right' => esc_html__('Right','highrise')
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_panel,
                'type' => 'text',
                'name' => 'side_area_title',
                'default_value' => '',
                'label' =>esc_html__( 'Side Area Title','highrise'),
                'description' => esc_html__('Enter a title to appear in Side Area','highrise'),
                'args' => array(
                    'col_width' => 3,
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_panel,
                'type' => 'color',
                'name' => 'side_area_background_color',
                'default_value' => '',
                'label' =>esc_html__( 'Background Color','highrise'),
                'description' =>esc_html__( 'Choose a background color for Side Area','highrise'),
            )
        );

        $padding_group = highrise_mikado_add_admin_group(
            array(
                'parent' => $side_area_panel,
                'name' => 'padding_group',
                'title' => esc_html__('Padding','highrise'),
                'description' =>esc_html__( 'Define padding for Side Area','highrise')
            )
        );

        $padding_row = highrise_mikado_add_admin_row(
            array(
                'parent' => $padding_group,
                'name' => 'padding_row',
                'next' => true
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $padding_row,
                'type' => 'textsimple',
                'name' => 'side_area_padding_top',
                'default_value' => '',
                'label' => esc_html__('Top Padding','highrise'),
                'args' => array(
                    'suffix' => 'px'
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $padding_row,
                'type' => 'textsimple',
                'name' => 'side_area_padding_right',
                'default_value' => '',
                'label' =>esc_html__( 'Right Padding','highrise'),
                'args' => array(
                    'suffix' => 'px'
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $padding_row,
                'type' => 'textsimple',
                'name' => 'side_area_padding_bottom',
                'default_value' => '',
                'label' => esc_html__('Bottom Padding','highrise'),
                'args' => array(
                    'suffix' => 'px'
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $padding_row,
                'type' => 'textsimple',
                'name' => 'side_area_padding_left',
                'default_value' => '',
                'label' =>esc_html__( 'Left Padding','highrise'),
                'args' => array(
                    'suffix' => 'px'
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_panel,
                'type' => 'select',
                'name' => 'side_area_close_icon',
                'default_value' => 'dark',
                'label' =>esc_html__( 'Close Icon Style','highrise'),
                'description' =>esc_html__( 'Choose a type of close icon','highrise'),
                'options' => array(
                    'light' =>esc_html__( 'Light','highrise'),
                    'dark' =>esc_html__( 'Dark','highrise')
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_panel,
                'type' => 'text',
                'name' => 'side_area_close_icon_size',
                'default_value' => '',
                'label' => esc_html__('Close Icon Size','highrise'),
                'description' => esc_html__('Define close icon size','highrise'),
                'args' => array(
                    'col_width' => 3,
                    'suffix' => 'px'
                )
            )
        );

        $title_group = highrise_mikado_add_admin_group(
            array(
                'parent' => $side_area_panel,
                'name' => 'title_group',
                'title' =>esc_html__( 'Title','highrise'),
                'description' =>esc_html__( 'Define Style for Side Area title (for widgets)','highrise')
            )
        );

        $title_row_1 = highrise_mikado_add_admin_row(
            array(
                'parent' => $title_group,
                'name' => 'title_row_1',
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $title_row_1,
                'type' => 'colorsimple',
                'name' => 'side_area_title_color',
                'default_value' => '',
                'label' =>esc_html__( 'Text Color','highrise'),
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $title_row_1,
                'type' => 'textsimple',
                'name' => 'side_area_title_fontsize',
                'default_value' => '',
                'label' =>esc_html__( 'Font Size','highrise'),
                'args' => array(
                    'suffix' => 'px'
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $title_row_1,
                'type' => 'textsimple',
                'name' => 'side_area_title_lineheight',
                'default_value' => '',
                'label' =>esc_html__( 'Line Height','highrise'),
                'args' => array(
                    'suffix' => 'px'
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $title_row_1,
                'type' => 'selectblanksimple',
                'name' => 'side_area_title_texttransform',
                'default_value' => '',
                'label' => esc_html__('Text Transform','highrise'),
                'options' => highrise_mikado_get_text_transform_array()
            )
        );

        $title_row_2 = highrise_mikado_add_admin_row(
            array(
                'parent' => $title_group,
                'name' => 'title_row_2',
                'next' => true
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $title_row_2,
                'type' => 'fontsimple',
                'name' => 'side_area_title_google_fonts',
                'default_value' => '-1',
                'label' => esc_html__('Font Family','highrise'),
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $title_row_2,
                'type' => 'selectblanksimple',
                'name' => 'side_area_title_fontstyle',
                'default_value' => '',
                'label' => esc_html__('Font Style','highrise'),
                'options' => highrise_mikado_get_font_style_array()
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $title_row_2,
                'type' => 'selectblanksimple',
                'name' => 'side_area_title_fontweight',
                'default_value' => '',
                'label' => esc_html__('Font Weight','highrise'),
                'options' => highrise_mikado_get_font_weight_array()
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $title_row_2,
                'type' => 'textsimple',
                'name' => 'side_area_title_letterspacing',
                'default_value' => '',
                'label' => esc_html__('Letter Spacing','highrise'),
                'args' => array(
                    'suffix' => 'px'
                )
            )
        );


        $text_group = highrise_mikado_add_admin_group(
            array(
                'parent' => $side_area_panel,
                'name' => 'text_group',
                'title' =>esc_html__( 'Text','highrise'),
                'description' =>esc_html__( 'Define Style for Side Area text','highrise')
            )
        );

        $text_row_1 = highrise_mikado_add_admin_row(
            array(
                'parent' => $text_group,
                'name' => 'text_row_1',
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $text_row_1,
                'type' => 'colorsimple',
                'name' => 'side_area_text_color',
                'default_value' => '',
                'label' => esc_html__('Text Color','highrise'),
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $text_row_1,
                'type' => 'textsimple',
                'name' => 'side_area_text_fontsize',
                'default_value' => '',
                'label' => esc_html__('Font Size','highrise'),
                'args' => array(
                    'suffix' => 'px'
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $text_row_1,
                'type' => 'textsimple',
                'name' => 'side_area_text_lineheight',
                'default_value' => '',
                'label' =>esc_html__( 'Line Height','highrise'),
                'args' => array(
                    'suffix' => 'px'
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $text_row_1,
                'type' => 'selectblanksimple',
                'name' => 'side_area_text_texttransform',
                'default_value' => '',
                'label' =>esc_html__( 'Text Transform','highrise'),
                'options' => highrise_mikado_get_text_transform_array()
            )
        );

        $text_row_2 = highrise_mikado_add_admin_row(
            array(
                'parent' => $text_group,
                'name' => 'text_row_2',
                'next' => true
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $text_row_2,
                'type' => 'fontsimple',
                'name' => 'side_area_text_google_fonts',
                'default_value' => '-1',
                'label' =>esc_html__( 'Font Family','highrise'),
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $text_row_2,
                'type' => 'fontsimple',
                'name' => 'side_area_text_google_fonts',
                'default_value' => '-1',
                'label' =>esc_html__( 'Font Family','highrise'),
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $text_row_2,
                'type' => 'selectblanksimple',
                'name' => 'side_area_text_fontstyle',
                'default_value' => '',
                'label' => esc_html__('Font Style','highrise'),
                'options' => highrise_mikado_get_font_style_array()
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $text_row_2,
                'type' => 'selectblanksimple',
                'name' => 'side_area_text_fontweight',
                'default_value' => '',
                'label' => esc_html__('Font Weight','highrise'),
                'options' => highrise_mikado_get_font_weight_array()
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $text_row_2,
                'type' => 'textsimple',
                'name' => 'side_area_text_letterspacing',
                'default_value' => '',
                'label' => esc_html__('Letter Spacing','highrise'),
                'args' => array(
                    'suffix' => 'px'
                )
            )
        );

        $widget_links_group = highrise_mikado_add_admin_group(
            array(
                'parent' => $side_area_panel,
                'name' => 'widget_links_group',
                'title' => esc_html__('Link Style','highrise'),
                'description' => esc_html__('Define styles for Side Area widget links','highrise')
            )
        );

        $widget_links_row_1 = highrise_mikado_add_admin_row(
            array(
                'parent' => $widget_links_group,
                'name' => 'widget_links_row_1',
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $widget_links_row_1,
                'type' => 'colorsimple',
                'name' => 'sidearea_link_color',
                'default_value' => '',
                'label' => esc_html__('Text Color','highrise'),
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $widget_links_row_1,
                'type' => 'textsimple',
                'name' => 'sidearea_link_font_size',
                'default_value' => '',
                'label' => esc_html__('Font Size','highrise'),
                'args' => array(
                    'suffix' => 'px'
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $widget_links_row_1,
                'type' => 'textsimple',
                'name' => 'sidearea_link_line_height',
                'default_value' => '',
                'label' => esc_html__('Line Height','highrise'),
                'args' => array(
                    'suffix' => 'px'
                )
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $widget_links_row_1,
                'type' => 'selectblanksimple',
                'name' => 'sidearea_link_text_transform',
                'default_value' => '',
                'label' => esc_html__('Text Transform','highrise'),
                'options' => highrise_mikado_get_text_transform_array()
            )
        );

        $widget_links_row_2 = highrise_mikado_add_admin_row(
            array(
                'parent' => $widget_links_group,
                'name' => 'widget_links_row_2',
                'next' => true
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $widget_links_row_2,
                'type' => 'fontsimple',
                'name' => 'sidearea_link_font_family',
                'default_value' => '-1',
                'label' => esc_html__('Font Family','highrise'),
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $widget_links_row_2,
                'type' => 'selectblanksimple',
                'name' => 'sidearea_link_font_style',
                'default_value' => '',
                'label' => esc_html__('Font Style','highrise'),
                'options' => highrise_mikado_get_font_style_array()
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $widget_links_row_2,
                'type' => 'selectblanksimple',
                'name' => 'sidearea_link_font_weight',
                'default_value' => '',
                'label' =>esc_html__( 'Font Weight','highrise'),
                'options' => highrise_mikado_get_font_weight_array()
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $widget_links_row_2,
                'type' => 'textsimple',
                'name' => 'sidearea_link_letter_spacing',
                'default_value' => '',
                'label' =>esc_html__( 'Letter Spacing','highrise'),
                'args' => array(
                    'suffix' => 'px'
                )
            )
        );

        $widget_links_row_3 = highrise_mikado_add_admin_row(
            array(
                'parent' => $widget_links_group,
                'name' => 'widget_links_row_3',
                'next' => true
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $widget_links_row_3,
                'type' => 'colorsimple',
                'name' => 'sidearea_link_hover_color',
                'default_value' => '',
                'label' => esc_html__('Hover Color','highrise'),
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_panel,
                'type' => 'yesno',
                'name' => 'side_area_enable_bottom_border',
                'default_value' => 'no',
                'label' =>esc_html__( 'Border Bottom on Elements','highrise'),
                'description' => esc_html__('Enable border bottom on elements in side area','highrise'),
                'args' => array(
                    'dependence' => true,
                    'dependence_hide_on_yes' => '',
                    'dependence_show_on_yes' => '#mkd_side_area_bottom_border_container'
                )
            )
        );

        $side_area_bottom_border_container = highrise_mikado_add_admin_container(
            array(
                'parent' => $side_area_panel,
                'name' => 'side_area_bottom_border_container',
                'hidden_property' => 'side_area_enable_bottom_border',
                'hidden_value' => 'no'
            )
        );

        highrise_mikado_add_admin_field(
            array(
                'parent' => $side_area_bottom_border_container,
                'type' => 'color',
                'name' => 'side_area_bottom_border_color',
                'default_value' => '',
                'label' => esc_html__('Border Bottom Color','highrise'),
                'description' =>esc_html__( 'Choose color for border bottom on elements in sidearea','highrise')
            )
        );

    }

    add_action('highrise_mikado_options_map', 'highrise_mikado_sidearea_options_map', 4);

}