<?php

namespace Highrise\Modules\Shortcodes\VideoBanner;

use Highrise\Modules\Shortcodes\Lib\ShortcodeInterface;


class VideoBanner implements ShortcodeInterface
{
    private $base;

    public function __construct() {
        $this->base = 'mkd_video_banner';

        add_action('vc_before_init', array($this, 'vcMap'));
    }

    public function getBase() {
        return $this->base;
    }

    public function vcMap() {
        vc_map(array(
            'name' => esc_html__('Video Banner', 'highrise'),
            'base' => $this->base,
            'category' => esc_html__('by MIKADO', 'highrise'),
            'icon' => 'icon-wpb-video-banner extended-custom-icon',
            'allowed_container_element' => 'vc_row',
            'params' => array(
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__('Title', 'highrise'),
                    'param_name' => 'title',
                    'value' => '',
                    'save_always' => true,
                    'admin_label' => true
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__('Title Tag', 'highrise'),
                    'param_name' => 'title_tag',
                    'value' => array(
                        esc_html('Default', 'highrise') => '',
                        'h2' => 'h2',
                        'h3' => 'h3',
                        'h4' => 'h4',
                        'h5' => 'h5',
                        'h6' => 'h6'
                    ),
                    'dependency' => Array('element' => 'title', 'not_empty' => true),
                ),
                array(
                    'type' => 'colorpicker',
                    'heading' => esc_html('Title Color', 'highrise'),
                    'param_name' => 'title_color',
                    'description' => '',
                    'dependency' => Array('element' => 'title', 'not_empty' => true),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__('Subtitle', 'highrise'),
                    'param_name' => 'subtitle',
                    'value' => '',
                    'save_always' => true,
                    'admin_label' => true
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__('Subtitle Tag', 'highrise'),
                    'param_name' => 'subtitle_tag',
                    'value' => array(
                        esc_html('Default', 'highrise') => '',
                        'h2' => 'h2',
                        'h3' => 'h3',
                        'h4' => 'h4',
                        'h5' => 'h5',
                        'h6' => 'h6'
                    ),
                    'dependency' => Array('element' => 'subtitle', 'not_empty' => true),
                ),
                array(
                    'type' => 'colorpicker',
                    'heading' => esc_html('Subtitle Color', 'highrise'),
                    'param_name' => 'subtitle_color',
                    'description' => '',
                    'dependency' => Array('element' => 'subtitle', 'not_empty' => true),
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__('Video Link', 'highrise'),
                    'param_name' => 'video_link',
                    'value' => '',
                    'save_always' => true,
                    'admin_label' => true
                ),
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__('Video Banner', 'highrise'),
                    'param_name' => 'video_banner',
                    'value' => '',
                    'save_always' => true,
                    'admin_label' => true
                ),
                array(
                    'type' => 'dropdown',
                    'admin_label' => true,
                    'heading' => esc_html__('Skin', 'highrise'),
                    'param_name' => 'skin',
                    'value' => array(
                        esc_html__('Default', 'highrise') => '',
                        esc_html__('Light', 'highrise') => 'light',
                        esc_html__('Dark', 'highrise') => 'dark',
                    ),
                    'save_always' => true,
                    'description' => '',
                ),
            )
        ));
    }

    public function render($atts, $content = null) {
        $default_atts = array(
            'title' => '',
            'title_tag' => 'h2',
            'title_color' => '',
            'subtitle' => '',
            'subtitle_tag' => 'h4',
            'subtitle_color' => '',
            'video_link' => '',
            'video_banner' => '',
            'skin' => '',
        );

        $params = shortcode_atts($default_atts, $atts);
        $params['banner_id'] = rand();
        $params['video_banner_classes'] = $this->getVideoBannerClasses($params);
        $params['title_style'] = $this->getTitleStyle($params);
        $params['subtitle_style'] = $this->getSubtitleStyle($params);

        return highrise_mikado_get_shortcode_module_template_part('templates/video-banner', 'video-banner', '', $params);
    }

    private function getVideoBannerClasses($params) {
        $video_banner_classes = array();

        if ($params['skin'] !== '') {
            switch ($params['skin']) {
                case 'light':
                    $video_banner_classes[] = 'mkd-light';
                    break;
                case 'dark':
                    $video_banner_classes[] = 'mkd-dark';
                    break;
            }
        }

        return implode(' ', $video_banner_classes);
    }

    private function getTitleStyle($params) {

        $title_style = array();

        if ($params['title_color'] !== '') {
            $title_style[] = 'color: ' . $params['title_color'];
        }

        return implode(';', $title_style);
    }

    private function getSubtitleStyle($params) {

        $subtitle_style = array();

        if ($params['subtitle_color'] !== '') {
            $subtitle_style[] = 'color: ' . $params['subtitle_color'];
        }

        return implode(';', $subtitle_style);
    }
}