<?php

namespace Highrise\Modules\Shortcodes\TwitterSlider;

use Highrise\Modules\Shortcodes\Lib\ShortcodeInterface;

class TwitterSlider implements ShortcodeInterface
{
    private $base;

    public function __construct() {
        $this->base = 'mkd_twitter_slider';

        add_action('vc_before_init', array($this, 'vcMap'));
    }

    /**
     * @return string
     */
    public function getBase() {
        return $this->base;
    }

    /**
     *
     */
    public function vcMap() {
        vc_map(array(
            'name' => esc_html__('Twitter Slider', 'highrise'),
            'base' => $this->base,
            'icon' => 'icon-wpb-twitter-slider extended-custom-icon',
            'category' => esc_html__('by MIKADO', 'highrise'),
            'allowed_container_element' => 'vc_row',
            'params' => array(
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__('Title', 'highrise'),
                    'param_name' => 'title',
                    'value' => '',
                    'save_always' => true,
                    'admin_label' => true
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__('Title Tag', 'highrise'),
                    'param_name' => 'title_tag',
                    'value' => array(
                        'h2' => 'h2',
                        'h3' => 'h3',
                        'h4' => 'h4',
                        'h5' => 'h5',
                        'h6' => 'h6'
                    ),
                    'dependency' => Array('element' => 'title', 'not_empty' => true),
                    'save_always' => true,
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__('User ID', 'highrise'),
                    'param_name' => 'user_id',
                    'value' => '',
                    'admin_label' => true
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__('Number of tweets', 'highrise'),
                    'param_name' => 'count',
                    'value' => '',
                    'description' => esc_html__('Default Number is 4', 'highrise'),
                    'admin_label' => true
                ),
                array(
                    'type' => 'colorpicker',
                    'heading' => esc_html__('Tweets Color', 'highrise'),
                    'param_name' => 'tweets_color',
                    'value' => '',
                    'description' => '',
                    'admin_label' => true
                ),
                array(
                    'type' => 'textfield',
                    'class' => '',
                    'heading' => esc_html__('Tweet Cache Time', 'highrise'),
                    'param_name' => 'transient_time',
                    'value' => '',
                    'admin_label' => true
                ),
                array(
                    'type' => 'dropdown',
                    'admin_label' => true,
                    'heading' => esc_html__('Skin', 'highrise'),
                    'param_name' => 'skin',
                    'description' => '',
                    'value' => array(
                        esc_html__('Default', 'highrise') => '',
                        esc_html__('Dark', 'highrise') => 'dark',
                        esc_html__('Light', 'highrise') => 'light'
                    ),
                ),

                ////////////////////////////////////////////////

                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__('Slide duration', 'highrise'),
                    'admin_label' => true,
                    'param_name' => 'autoplay',
                    'value' => array(
                        esc_html__('3', 'highrise') => '3',
                        esc_html__('5', 'highrise') => '5',
                        esc_html__('10', 'highrise') => '10',
                        esc_html__('Disable', 'highrise') => 'disable'
                    ),
                    'save_always' => true,
                    'description' => esc_html__('Auto rotate slides each X seconds', 'highrise'),
                    'group' => esc_html__('Slider', 'highrise'),
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__('Pause on hover', 'highrise'),
                    'param_name' => 'pause',
                    'value' => array(
                        esc_html__('Yes', 'highrise') => 'yes',
                        esc_html__('No', 'highrise') => 'no'
                    ),
                    'save_always' => true,
                    'dependency' => array(
                        'element' => 'autoplay',
                        'value' => array(
                            '3', '5', '10'
                        )
                    ),
                    'group' => esc_html__('Slider', 'highrise'),
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__('Loop', 'highrise'),
                    'param_name' => 'loop',
                    'value' => array(
                        esc_html__('Yes', 'highrise') => 'yes',
                        esc_html__('No', 'highrise') => 'no'
                    ),
                    'save_always' => true,
                    'group' => esc_html__('Slider', 'highrise'),
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__('Show Navigation Arrows', 'highrise'),
                    'param_name' => 'navigation',
                    'value' => array(
                        esc_html__('Yes', 'highrise') => 'yes',
                        esc_html__('No', 'highrise') => 'no'
                    ),
                    'save_always' => true,
                    'group' => esc_html__('Slider', 'highrise'),
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__('Navigation Position', 'highrise'),
                    'param_name' => 'navigation_position',
                    'value' => array(
                        esc_html__('Inside', 'highrise') => 'inside',
                        esc_html__('Outside', 'highrise') => 'outside'
                    ),
                    'std' => 'inside',
                    'save_always' => true,
                    'dependency' => array(
                        'element' => 'navigation',
                        'value' => array(
                            'yes'
                        )
                    ),
                    'group' => esc_html__('Slider', 'highrise'),
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__('Show Pagination', 'highrise'),
                    'param_name' => 'pagination',
                    'value' => array(
                        esc_html__('Yes', 'highrise') => 'yes',
                        esc_html__('No', 'highrise') => 'no'
                    ),
                    'save_always' => true,
                    'group' => esc_html__('Slider', 'highrise'),
                )
            )
        ));
    }


    /**
     * @param array $atts
     * @param null $content
     *
     * @return string
     */
    public function render($atts, $content = null) {
        $params = array(
            'user_id' => '',
            'count' => '4',
            'tweets_color' => '',
            'transient_time' => '0',
            'skin' => '',
            'title' => '',
            'title_tag' => '',
            'autoplay' => '',
            'pause' => '',
            'loop' => '',
            'navigation' => '',
            'navigation_position' => '',
            'pagination' => '',
        );

        $params = shortcode_atts($params, $atts);

        $html = '';

        $twitter_api = \MikadoTwitterApi::getInstance();

        if ($twitter_api->hasUserConnected()) {
            $response = $twitter_api->fetchTweets($params['user_id'], $params['count'], array(
                'transient_time' => $params['transient_time'],
                'transient_id' => 'mkd_twitter_slider_cache'
            ));

            $params['response'] = $response;
            $params['twitter_api'] = $twitter_api;
            $params['tweet_styles'] = $this->getTweetStyles($params);
            $params['twitter_classes'] = $this->getTwitterSliderClasses($params);
            $params['twitter_slider_data'] = $this->getTwitterSliderData($params);

            $html .= highrise_mikado_get_shortcode_module_template_part('templates/twitter-slider', 'twitter-slider', '', $params);
        } else {
            $html .= esc_html__('It seams that you haven\'t connected with your Twitter account', 'highrise');
        }

        return $html;
    }

    /**
     * Return all configuration data for slider
     *
     * @param $params
     * @return array
     */
    private function getTwitterSliderData($params) {
        $twitter_slider_data = array();

        $twitter_slider_data['data-autoplay'] = ($params['autoplay'] !== '') ? $params['autoplay'] : '';
        $twitter_slider_data['data-pause'] = ($params['pause'] != '') ? $params['pause'] : '';
        $twitter_slider_data['data-loop'] = ($params['loop'] !== '') ? $params['loop'] : '';
        $twitter_slider_data['data-navigation'] = ($params['navigation'] !== '') ? $params['navigation'] : '';
        $twitter_slider_data['data-pagination'] = ($params['pagination'] !== '') ? $params['pagination'] : '';

        return $twitter_slider_data;
    }

    /**
     * @param $params
     *
     * @return array
     */
    private function getTweetStyles($params) {
        $styles = array();

        if (!empty($params['tweets_color'])) {
            $styles[] = 'color: ' . $params['tweets_color'];
        }

        return $styles;
    }

    private function getTwitterSliderClasses($params) {
        $twitter_classes = array();

        if ($params['skin'] !== '') {
            switch ($params['skin']) {
                case 'light':
                    $twitter_classes[] = 'mkd-light';
                    break;
                case 'dark':
                    $twitter_classes[] = 'mkd-dark';
                    break;
            }
        }

        $twitter_classes[] = ($params['navigation_position'] == 'inside') ? 'mkd-nav-inside' : '';

        return implode(' ', $twitter_classes);
    }
}