<?php
namespace Highrise\Modules\Shortcodes\Team;

use Highrise\Modules\Shortcodes\Lib\ShortcodeInterface;

/**
 * Class Team
 */
class Team implements ShortcodeInterface
{
    /**
     * @var string
     */
    private $base;

    public function __construct() {
        $this->base = 'mkd_team';

        add_action('vc_before_init', array($this, 'vcMap'));
    }

    /**
     * Returns base for shortcode
     * @return string
     */
    public function getBase() {
        return $this->base;
    }

    /**
     * Maps shortcode to Visual Composer. Hooked on vc_before_init
     *
     * @see mkd_core_get_carousel_slider_array_vc()
     */
    public function vcMap() {

        $team_social_icons_array = array();
        for ($x = 1; $x < 6; $x++) {
            $teamIconCollections = highrise_mikado_icon_collections()->getCollectionsWithSocialIcons();
            foreach ($teamIconCollections as $collection_key => $collection) {

                $team_social_icons_array[] = array(
                    'type' => 'dropdown',
                    'heading' => esc_html__('Social Icon ', 'highrise') . $x,
                    'param_name' => 'team_social_' . $collection->param . '_' . $x,
                    'value' => $collection->getSocialIconsArrayVC(),
                    'dependency' => Array('element' => 'team_social_icon_pack', 'value' => array($collection_key))
                );

            }

            $team_social_icons_array[] = array(
                'type' => 'textfield',
                'heading' => esc_html__('Social Icon ', 'highrise') . $x . esc_html__(' Link', 'highrise'),
                'param_name' => 'team_social_icon_' . $x . '_link',
                'dependency' => array('element' => 'team_social_icon_pack', 'value' => highrise_mikado_icon_collections()->getIconCollectionsKeys())
            );

            $team_social_icons_array[] = array(
                'type' => 'dropdown',
                'heading' => esc_html__('Social Icon ', 'highrise') . $x . esc_html__(' Target', 'highrise'),
                'param_name' => 'team_social_icon_' . $x . '_target',
                'value' => array(
                    '' => '',
                    esc_html__('Self', 'highrise') => '_self',
                    esc_html__('Blank', 'highrise') => '_blank'
                ),
                'dependency' => Array('element' => 'team_social_icon_' . $x . '_link', 'not_empty' => true)
            );

        }

        vc_map(array(
            'name' => esc_html__('Team', 'highrise'),
            'base' => $this->base,
            'category' => esc_html__('by MIKADO', 'highrise'),
            'icon' => 'icon-wpb-team extended-custom-icon',
            'allowed_container_element' => 'vc_row',
            'params' => array_merge(
                array(
                    array(
                        'type' => 'dropdown',
                        'admin_label' => true,
                        'heading' => esc_html__('Type', 'highrise'),
                        'param_name' => 'team_type',
                        'value' => array(
                            esc_html__('Main Info on Hover', 'highrise') => 'main-info-on-hover',
                            esc_html__('Main Info Below Image', 'highrise') => 'main-info-below-image'
                        ),
                        'save_always' => true
                    ),
                    array(
                        'type' => 'attach_image',
                        'heading' => esc_html__('Image', 'highrise'),
                        'param_name' => 'team_image'
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__('Name', 'highrise'),
                        'admin_label' => true,
                        'param_name' => 'team_name'
                    ),
                    array(
                        'type' => 'dropdown',
                        'heading' => esc_html__('Name Tag', 'highrise'),
                        'param_name' => 'team_name_tag',
                        'value' => array(
                            '' => '',
                            'h2' => 'h2',
                            'h3' => 'h3',
                            'h4' => 'h4',
                            'h5' => 'h5',
                            'h6' => 'h6',
                        ),
                        'dependency' => array('element' => 'team_name', 'not_empty' => true)
                    ),
                    array(
                        'type' => 'colorpicker',
                        'heading' => esc_html('Name Color', 'highrise'),
                        'param_name' => 'team_name_color',
                        'description' => '',
                        'dependency' => array('element' => 'team_name', 'not_empty' => true),
                        'group' => esc_html('Design Options', 'highrise'),
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__('Position', 'highrise'),
                        'admin_label' => true,
                        'param_name' => 'team_position'
                    ),
                    array(
                        'type' => 'colorpicker',
                        'heading' => esc_html('Position Color', 'highrise'),
                        'param_name' => 'team_position_color',
                        'description' => '',
                        'dependency' => array('element' => 'team_position', 'not_empty' => true),
                        'group' => esc_html('Design Options', 'highrise'),
                    ),
                    array(
                        'type' => 'textarea',
                        'heading' => esc_html__('Description', 'highrise'),
                        'admin_label' => true,
                        'param_name' => 'team_description'
                    ),
                    array(
                        'type' => 'colorpicker',
                        'heading' => esc_html('Description Color', 'highrise'),
                        'param_name' => 'team_description_color',
                        'description' => '',
                        'dependency' => array('element' => 'team_description', 'not_empty' => true),
                        'group' => esc_html('Design Options', 'highrise'),
                    ),
                    array(
                        'type' => 'dropdown',
                        'heading' => esc_html__('Social Icon Pack', 'highrise'),
                        'param_name' => 'team_social_icon_pack',
                        'admin_label' => true,
                        'value' => array_merge(array('' => ''), highrise_mikado_icon_collections()->getIconCollectionsVCExclude('linea_icons')),
                        'save_always' => true
                    ),
                    array(
                        'type' => 'dropdown',
                        'heading' => esc_html__('Social Icons Type', 'highrise'),
                        'param_name' => 'team_social_icon_type',
                        'value' => array(
                            esc_html__('Normal', 'highrise') => 'normal',
                            esc_html__('Circle', 'highrise') => 'circle',
                            esc_html__('Square', 'highrise') => 'square'
                        ),
                        'save_always' => true,
                        'dependency' => array('element' => 'team_social_icon_pack', 'value' => highrise_mikado_icon_collections()->getIconCollectionsKeys())
                    ),
                    array(
                        'type' => 'colorpicker',
                        'heading' => esc_html('Icon Color', 'highrise'),
                        'param_name' => 'icon_color',
                        'description' => '',
                        'dependency' => array('element' => 'team_social_icon_pack', 'value' => highrise_mikado_icon_collections()->getIconCollectionsKeys()),
                        'group' => esc_html('Design Options', 'highrise'),
                    ),
                    array(
                        'type' => 'colorpicker',
                        'heading' => esc_html('Icon Background Color', 'highrise'),
                        'param_name' => 'icon_background_color',
                        'description' => '',
                        'dependency' => Array('element' => 'team_social_icon_type', 'value' => array('circle', 'square')),
                        'group' => esc_html('Design Options', 'highrise'),
                    ),
                    array(
                        'type' => 'colorpicker',
                        'heading' => esc_html('Icon Hover Color', 'highrise'),
                        'param_name' => 'icon_hover_color',
                        'description' => '',
                        'dependency' => array('element' => 'team_social_icon_pack', 'value' => highrise_mikado_icon_collections()->getIconCollectionsKeys()),
                        'group' => esc_html('Design Options', 'highrise'),
                    ),
                    array(
                        'type' => 'colorpicker',
                        'heading' => esc_html('Icon Hover Backgorund Color', 'highrise'),
                        'param_name' => 'icon_hover_background_color',
                        'description' => '',
                        'dependency' => Array('element' => 'team_social_icon_type', 'value' => array('circle', 'square')),
                        'group' => esc_html('Design Options', 'highrise'),
                    ),
                ),
                $team_social_icons_array
            )
        ));
    }

    /**
     * Renders shortcodes HTML
     *
     * @param $atts array of shortcode params
     * @param $content string shortcode content
     * @return string
     */
    public function render($atts, $content = null) {

        $args = array(
            'team_image' => '',
            'team_type' => 'main-info-on-hover',
            'team_name' => '',
            'team_name_tag' => 'h5',
            'team_name_color' => '',
            'team_position' => '',
            'team_position_color' => '',
            'team_description' => '',
            'team_description_color' => '',
            'team_social_icon_pack' => '',
            'team_social_icon_type' => 'normal_social',
            'icon_color' => '',
            'icon_background_color' => '',
            'icon_hover_color' => '',
            'icon_hover_background_color' => '',
        );

        $team_social_icons_form_fields = array();
        $number_of_social_icons = 5;

        for ($x = 1; $x <= $number_of_social_icons; $x++) {

            foreach (highrise_mikado_icon_collections()->iconCollections as $collection_key => $collection) {
                $team_social_icons_form_fields['team_social_' . $collection->param . '_' . $x] = '';
            }

            $team_social_icons_form_fields['team_social_icon_' . $x . '_link'] = '';
            $team_social_icons_form_fields['team_social_icon_' . $x . '_target'] = '';

        }

        $args = array_merge($args, $team_social_icons_form_fields);

        $params = shortcode_atts($args, $atts);

        $params['number_of_social_icons'] = 5;
        $params['team_name_tag'] = $this->getTeamNameTag($params, $args);
        $params['team_name_style'] = $this->getTeamNameStyle($params);
        $params['team_position_style'] = $this->getTeamPositionStyle($params);
        $params['team_description_style'] = $this->getTeamDescriptionStyle($params);
        $params['team_social_icons'] = $this->getTeamSocialIcons($params);

        //Get HTML from template based on type of team
        $html = highrise_mikado_get_shortcode_module_template_part('templates/' . $params['team_type'], 'team', '', $params);

        return $html;

    }

    private function getTeamNameStyle($params) {
        $team_name_style = array();

        if (!empty($params['team_name_color'])) {
            $team_name_style[] = 'color: ' . $params['team_name_color'];
        }

        return implode(';', $team_name_style);
    }

    private function getTeamPositionStyle($params) {
        $team_position_style = array();

        if (!empty($params['team_position_color'])) {
            $team_position_style[] = 'color: ' . $params['team_position_color'];
        }

        return implode(';', $team_position_style);
    }

    private function getTeamDescriptionStyle($params) {
        $team_description_style = array();

        if (!empty($params['team_description_color'])) {
            $team_description_style[] = 'color: ' . $params['team_description_color'];
        }

        return implode(';', $team_description_style);
    }

    /**
     * Return correct heading value. If provided heading isn't valid get the default one
     *
     * @param $params
     * @return mixed
     */
    private function getTeamNameTag($params, $args) {

        $headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');
        return (in_array($params['team_name_tag'], $headings_array)) ? $params['team_name_tag'] : $args['team_name_tag'];

    }

    private function getTeamSocialIcons($params) {

        extract($params);
        $social_icons = array();

        if ($team_social_icon_pack !== '') {

            $icon_pack = highrise_mikado_icon_collections()->getIconCollection($team_social_icon_pack);
            $team_social_icon_type_label = 'team_social_' . $icon_pack->param;
            $team_social_icon_param_label = $icon_pack->param;

            for ($i = 1; $i <= $number_of_social_icons; $i++) {

                $team_social_icon = ${$team_social_icon_type_label . '_' . $i};
                $team_social_link = ${'team_social_icon_' . $i . '_link'};
                $team_social_target = ${'team_social_icon_' . $i . '_target'};

                if ($team_social_icon !== '') {

                    $team_icon_params = array();
                    $team_icon_params['icon_pack'] = $team_social_icon_pack;
                    $team_icon_params[$team_social_icon_param_label] = $team_social_icon;
                    $team_icon_params['link'] = ($team_social_link !== '') ? $team_social_link : '';
                    $team_icon_params['target'] = ($team_social_target !== '') ? $team_social_target : '';
                    $team_icon_params['type'] = ($team_social_icon_type !== '') ? $team_social_icon_type : '';

                    $team_icon_params['icon_color'] = ($icon_color !== '') ? $icon_color : '';
                    $team_icon_params['background_color'] = ($icon_background_color !== '') ? $icon_background_color : '';
                    $team_icon_params['hover_icon_color'] = ($icon_hover_color !== '') ? $icon_hover_color : '';
                    $team_icon_params['hover_background_color'] = ($icon_hover_background_color !== '') ? $icon_hover_background_color : '';

                    $social_icons[] = highrise_mikado_execute_shortcode('mkd_icon', $team_icon_params);
                }

            }

        }

        return $social_icons;

    }

}