<?php
namespace Highrise\Modules\Shortcodes\Tab;

use Highrise\Modules\Shortcodes\Lib\ShortcodeInterface;

/**
 * Class Tab
 */
class Tab implements ShortcodeInterface
{
    /**
     * @var string
     */
    private $base;

    function __construct() {
        $this->base = 'mkd_tab';
        add_action('vc_before_init', array($this, 'vcMap'));
    }

    /**
     * Returns base for shortcode
     * @return string
     */
    public function getBase() {
        return $this->base;
    }

    public function vcMap() {
        if (function_exists('vc_map')) {
            vc_map(array(
                'name' => esc_html__('Tab Item', 'highrise'),
                'base' => $this->getBase(),
                'as_parent' => array(),
                'as_child' => array('only' => 'mkd_tab_holder'),
                'is_container' => true,
                'category' => esc_html__('by MIKADO', 'highrise'),
                'icon' => 'icon-wpb-tab-item extended-custom-icon',
                'show_settings_on_create' => true,
                'js_view' => 'VcColumnView',
                'params' => array_merge(
                    highrise_mikado_icon_collections()->getVCParamsArray(array(), '', true),
                    array(
                        array(
                            'type' => 'textfield',
                            'admin_label' => true,
                            'heading' => esc_html__('Title', 'highrise'),
                            'param_name' => 'tab_title',
                            'description' => ''
                        )
                    )
                )
            ));
        }
    }

    public function render($atts, $content = null) {
        $default_atts = array(
            'tab_title' => 'Tab',
            'tab_id' => '',
            'tab_padding' => '',
        );

        $default_atts = array_merge($default_atts, highrise_mikado_icon_collections()->getShortcodeParams());
        $params = shortcode_atts($default_atts, $atts);
        extract($params);

        $params['tab_style'] = $this->getTabStyle($params);

        if ($params['icon_pack'] !== '') {
            $iconPackName = highrise_mikado_icon_collections()->getIconCollectionParamNameByKey($params['icon_pack']);
            $params['icon'] = $params[$iconPackName];
        }

        $rand_number = rand(0, 1000);
        $params['tab_title'] = $params['tab_title'] . '-' . $rand_number;

        $params['content'] = $content;

        $output = '';
        $output .= highrise_mikado_get_shortcode_module_template_part('templates/tab', 'tabs', '', $params);
        return $output;
    }

    /*
     * generate tab styles
     *
     * @param $params array
     *
     * @return array
     */
    private function getTabStyle($params) {
        $tab_style = array();

        if ($params['tab_padding'] !== '') {
            $tab_style[] = 'padding: ' . $params['tab_padding'];
        }

        return implode(';', $tab_style);
    }
}