<?php

namespace Highrise\Modules\Shortcodes\InteractiveBanner;

use Highrise\Modules\Shortcodes\Lib\ShortcodeInterface;

class InteractiveBanner implements ShortcodeInterface
{

    private $base;

    function __construct() {
        $this->base = 'mkd_interactive_banner';

        add_action('vc_before_init', array($this, 'vcMap'));
    }

    /**
     * Returns base for shortcode
     * @return string
     */
    public function getBase() {
        return $this->base;
    }

    public function vcMap() {
        if (function_exists('vc_map')) {
            vc_map(
                array(
                    'name' => esc_html__('Interactive Banner', 'highrise'),
                    'base' => $this->base,
                    'category' => 'by MIKADO',
                    'icon' => 'icon-wpb-interactive-banner extended-custom-icon',
                    'params' => array_merge(
                    array(
                        array(
                            'type' => 'dropdown',
                            'heading' => esc_html__('Type', 'highrise'),
                            'param_name' => 'type',
                            'value' => array(
                                esc_html__('Standard', 'highrise') => 'standard',
                                esc_html__('Info on hover', 'highrise') => 'info-on-hover'
                            ),
                            'save_always' => true,
                        ),
                        array(
                            'type' => 'dropdown',
                            'heading' => esc_html__('Skin', 'highrise'),
                            'param_name' => 'theme',
                            'value' => array(
                                esc_html__('Light', 'highrise') => 'light',
                                esc_html__('Dark', 'highrise') => 'dark'
                            ),
                            'save_always' => true,
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__('Padding', 'highrise'),
                            'param_name' => 'padding',
                            'value' => '',
                            'description' => esc_html__('Please insert padding in format 0px 10px 0px 10px', 'highrise')
                        ),
                        array(
                            'type' => 'attach_image',
                            'heading' => esc_html__('Background Image', 'highrise'),
                            'param_name' => 'background_image'
                        ),
                        array(
                            'type' => 'colorpicker',
                            'heading' => esc_html__('Background Color', 'highrise'),
                            'param_name' => 'background_color'
                        ),
                        array(
                            'type' => 'colorpicker',
                            'heading' => esc_html__('Background Hover Color', 'highrise'),
                            'param_name' => 'background_hover_color'
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__('Title', 'highrise'),
                            'param_name' => 'title',
                            'value' => '',
                            'admin_label' => true
                        ),
                        array(
                            'type' => 'dropdown',
                            'heading' => esc_html__('Title Tag', 'highrise'),
                            'param_name' => 'title_tag',
                            'value' => array(
                                '' => '',
                                esc_html__('h2', 'highrise') => 'h2',
                                esc_html__('h3', 'highrise') => 'h3',
                                esc_html__('h4', 'highrise') => 'h4',
                                esc_html__('h5', 'highrise') => 'h5',
                                esc_html__('h6', 'highrise') => 'h6',
                            ),
                            'dependency' => array('element' => 'title', 'not_empty' => true)
                        ),
                        array(
                            'type' => 'dropdown',
                            'heading' => esc_html__('Enable Separator', 'highrise'),
                            'param_name' => 'enable_separator',
                            'value' => array(
                                '' => '',
                                esc_html__('Yes', 'highrise') => 'yes',
                                esc_html__('No', 'highrise') => 'no',
                            ),
                        ),
                        array(
                            'type' => 'textarea',
                            'heading' => esc_html__('Text', 'highrise'),
                            'param_name' => 'text',
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__('Link', 'highrise'),
                            'param_name' => 'link',
                            'value' => '',
                            'admin_label' => true
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__('Link Text', 'highrise'),
                            'param_name' => 'link_text',
                        ),
                        array(
                            'type' => 'dropdown',
                            'heading' => esc_html__('Target', 'highrise'),
                            'param_name' => 'highrise',
                            'value' => array(
                                '' => '',
                                esc_html__('Self', 'highrise') => '_self',
                                esc_html__('Blank', 'highrise') => '_blank'
                            )
                        ),
                        array(
                            'type' => 'dropdown',
                            'admin_label' => true,
                            'heading' => esc_html__('Content Alignment', 'highrise'),
                            'param_name' => 'content_align',
                            'value' => array(
                                esc_html__('Left', 'highrise') => 'left',
                                esc_html__('Center', 'highrise') => 'center',
                                esc_html__('Right', 'highrise') => 'right'
                            ),
                            'save_always' => true
                        ),
                        array(
                            'type' => 'dropdown',
                            'heading' => esc_html__('Type', 'highrise'),
                            'param_name' => 'button_type',
                            'group' => esc_html__('Button Options', 'highrise'),
                            'value' => array(
                                esc_html__('Outline', 'highrise') => 'outline',
                                esc_html__('Solid', 'highrise') => 'solid',
                            ),
                            'save_always' => true
                        ),
                        array(
                            'type' => 'dropdown',
                            'heading' => esc_html__('Size', 'highrise'),
                            'param_name' => 'button_size',
                            'value' => array(
                                esc_html__('Default', 'highrise') => '',
                                esc_html__('Small', 'highrise') => 'small',
                                esc_html__('Medium', 'highrise') => 'medium',
                                esc_html__('Large', 'highrise') => 'large',
                                esc_html__('Extra Large', 'highrise') => 'huge',
                                esc_html__('Extra Large Full Width', 'highrise') => 'huge-full-width'
                            ),
                            'save_always' => true,
                            'group' => esc_html__('Button Options', 'highrise'),
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__('Font Size', 'highrise'),
                            'param_name' => 'button_font_size',
                            'group' => esc_html__('Button Options', 'highrise'),
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__('Button Left/Right padding', 'highrise'),
                            'param_name' => 'button_padding',
                            'group' => esc_html__('Button Options', 'highrise'),
                        ),
                        array(
                            'type' => 'colorpicker',
                            'heading' => esc_html__('Color', 'highrise'),
                            'param_name' => 'button_color',
                            'group' => esc_html__('Button Options', 'highrise'),
                        ),
                        array(
                            'type' => 'colorpicker',
                            'heading' => esc_html__('Hover Color', 'highrise'),
                            'param_name' => 'button_hover_color',
                            'group' => esc_html__('Button Options', 'highrise'),
                        ),
                        array(
                            'type' => 'colorpicker',
                            'heading' => esc_html__('Background Color', 'highrise'),
                            'param_name' => 'button_background_color',
                            'group' => esc_html__('Button Options', 'highrise'),
                            'dependency' => array('element' => 'button_type', 'value' => array('solid'))
                        ),
                        array(
                            'type' => 'colorpicker',
                            'heading' => esc_html__('Hover Background Color', 'highrise'),
                            'param_name' => 'button_hover_background_color',
                            'group' => esc_html__('Button Options', 'highrise'),
                            'dependency' => array('element' => 'button_type', 'value' => array('solid'))
                        ),
                        array(
                            'type' => 'colorpicker',
                            'heading' => esc_html__('Border Color', 'highrise'),
                            'param_name' => 'button_border_color',
                            'group' => esc_html__('Button Options', 'highrise'),
                            'dependency' => array('element' => 'button_type', 'value' => array('outline'))
                        ),
                        array(
                            'type' => 'colorpicker',
                            'heading' => esc_html__('Hover Border Color', 'highrise'),
                            'param_name' => 'button_hover_border_color',
                            'group' => esc_html__('Button Options', 'highrise'),
                            'dependency' => array('element' => 'button_type', 'value' => array('outline'))
                        )),
                        highrise_mikado_icon_collections()->getVCParamsArray(array(), '', true)
                    )
                )
            );
        }
    }

    public function render($atts, $content = null) {

        $args = array(
            'theme' => 'light',
            'type' => '',
            'padding' => '',
            'background_image' => '',
            'background_color' => '',
            'background_hover_color' => '',
            'title' => '',
            'title_tag' => 'h3',
            'text' => '',
            'enable_separator' => '',
            'link' => '',
            'link_text' => 'Read More',
            'target' => '_self',
            'content_align' => 'left',
            'button_type' => 'solid',
            'button_size' => '',
            'button_color' => '',
            'button_hover_color' => '',
            'button_background_color' => '',
            'button_hover_background_color' => '',
            'button_border_color' => '',
            'button_hover_border_color' => '',
            'button_font_size' => '',
            'button_padding' => '',
        );

        //$params = shortcode_atts($args, $atts);

        //extract($params);

        $default_atts = array_merge($args, highrise_mikado_icon_collections()->getShortcodeParams());
        $params = shortcode_atts($default_atts, $atts);

        $icon_pack_name = highrise_mikado_icon_collections()->getIconCollectionParamNameByKey($params['icon_pack']);
        $params['icon'] = $icon_pack_name ? $params[$icon_pack_name] : '';
        $params['classes'] = $this->generateInteractiveBannerClasses($params);
        $params['style'] = $this->generateInteractiveBannerStyles($params);
        $params['image'] = $this->generateInteractiveBannerImage($params);
        $params['hover-style'] = $this->generateInteractiveBannerOverlay($params);
        $params['initial-style'] = $this->generateInteractiveBannerInitial($params);
        $params['button_data'] = $this->getButtonParameters($params);
        $params['button_classes'] = $this->getButtonClasses($params);
        $params['separator_params'] = $this->getSeparatorStyles($params);

        $html = '';
        $html .= '<div class="' . $params['classes'] . '" style="' . $params['style'] . '">';
        $html .= '<a itemprop="url" class="mkd-interactive-banner-cover-link" href="' . $params['link'] . '" target="' . $params['target'] . '"></a>';
        $html .= '<div class="mkd-interactive-banner-initial" style="' . $params['initial-style'] . '"></div>';

        $html .= highrise_mikado_get_shortcode_module_template_part('templates/interactive-banner-' . $params['type'], 'interactive-banner', '', $params);

        $html .= '</div>';

        return $html;
    }

    /*
     * Return args for separator shortcode
     *
     * @params $params
     * @return array
     */

    private function getSeparatorStyles($params) {
        $separator_styles = array();

        if ($params['content_align'] !== '') {
            $separator_styles['position'] = $params['content_align'];
        }

        $separator_styles['width'] = '22';
        $separator_styles['thickness'] = '2';
        $separator_styles['top_margin'] = '0';
        $separator_styles['bottom_margin'] = '30';

        return $separator_styles;
    }

    /**
     * Generates banner classes
     *
     * @param $params
     *
     * @return string
     */

    private function generateInteractiveBannerClasses($params) {
        $interactive_banner_classes = array();
        $interactive_banner_classes[] = 'mkd-interactive-banner-holder';

        if (!empty($params['content_align'])) {
            switch ($params['content_align']) {
                case 'left':
                    $interactive_banner_classes[] = 'mkd-interactive-banner-align-left';
                    break;
                case 'center':
                    $interactive_banner_classes[] = 'mkd-interactive-banner-align-center';
                    break;
                case 'right':
                    $interactive_banner_classes[] = 'mkd-interactive-banner-align-right';
                    break;
                default:
                    break;
            }
        }

        if (!empty($params['theme'])) {
            switch ($params['theme']) {
                case 'light':
                    $interactive_banner_classes[] = 'mkd-interactive-banner-light-theme';
                    break;
                case 'dark':
                    $interactive_banner_classes[] = 'mkd-interactive-banner-dark-theme';
                    break;
                default:
                    break;
            }
        }

        if (!empty($params['type'])) {
            switch ($params['type']) {
                case 'standard':
                    $interactive_banner_classes[] = 'mkd-interactive-banner-standard';
                    break;
                case 'simple':
                    $interactive_banner_classes[] = 'mkd-interactive-banner-simple';
                    break;
                case 'info-on-hover':
                    $interactive_banner_classes[] = 'mkd-interactive-banner-info-on-hover';
                    break;
                default:
                    break;
            }
        }

        return implode(' ', $interactive_banner_classes);
    }

    private function generateInteractiveBannerStyles($params) {
        $interactive_banner_styles = array();

        if (!empty($params['background_image'])) {
            $interactive_banner_styles[] = 'background-image: url(' . wp_get_attachment_url($params['background_image']) . ')';
        }

        if (!empty($params['padding'])) {
            $interactive_banner_styles[] = 'padding: ' . $params['padding'];
        }

        return implode(';', $interactive_banner_styles);
    }

    private function generateInteractiveBannerImage($params) {
        if (!empty($params['background_image'])) {
            $interactive_banner_image[] = 'background-image: url(' . wp_get_attachment_url($params['background_image']) . ')';
        }

        return implode(';', $interactive_banner_image);
    }

    private function generateInteractiveBannerInitial($params) {
        $interactive_banner_initial_styles = array();

        if (!empty($params['background_color'])) {
            $interactive_banner_initial_styles[] = 'background-color: ' . $params['background_color'];
        }

        return implode(';', $interactive_banner_initial_styles);
    }

    private function generateInteractiveBannerOverlay($params) {
        $interactive_banner_overlay_styles = array();

        if (!empty($params['background_hover_color'])) {
            $interactive_banner_overlay_styles[] = 'background-color: ' . $params['background_hover_color'];
        }

        return implode(';', $interactive_banner_overlay_styles);
    }

    private function getButtonParameters($params) {
        $button_params_array = array();

        if (!empty($params['button_type'])) {
            $button_params_array['type'] = $params['button_type'];
        }

        if (!empty($params['link'])) {
            $button_params_array['link'] = $params['link'];
        }

        if (!empty($params['button_target'])) {
            $button_params_array['target'] = $params['button_target'];
        }

        if (!empty($params['button_size'])) {
            $button_params_array['size'] = $params['button_size'];
        }

        if (!empty($params['link_text'])) {
            $button_params_array['text'] = $params['link_text'];
        }

        if (!empty($params['button_background_color'])) {
            $button_params_array['background_color'] = $params['button_background_color'];
        }

        if (!empty($params['button_border_color'])) {
            $button_params_array['border_color'] = $params['button_border_color'];
        }

        if (!empty($params['button_color'])) {
            $button_params_array['color'] = $params['button_color'];
        }

        if (!empty($params['button_hover_color'])) {
            $button_params_array['hover_color'] = $params['button_hover_color'];
        }

        if (!empty($params['button_hover_background_color'])) {
            $button_params_array['hover_background_color'] = $params['button_hover_background_color'];
        }

        if (!empty($params['button_hover_border_color'])) {
            $button_params_array['hover_border_color'] = $params['button_hover_border_color'];
        }

        if (!empty($params['button_font_size'])) {
            $button_params_array['font_size'] = $params['button_font_size'];
        }

        if (!empty($params['button_padding'])) {
            $button_params_array['padding'] = $params['button_padding'];
        }

        $button_params_array['icon_pack'] = 'font_elegant';
        $button_params_array['fe_icon'] = 'arrow_carrot-right';

        return $button_params_array;
    }

    /**
     * Returns array of HTML classes for button
     *
     * @param $params
     *
     * @return array
     */
    private function getButtonClasses($params) {
        $buttonClasses = array(
            'mkd-btn',
            'mkd-btn-' . $params['button_size'],
        );

        if (!empty($params['icon'])) {
            $buttonClasses[] = 'mkd-btn-icon';
        }

        return implode(' ', $buttonClasses);

    }

}