<?php
namespace Highrise\Modules\Shortcodes\ElementsHolder;

use Highrise\Modules\Shortcodes\Lib\ShortcodeInterface;

class ElementsHolder implements ShortcodeInterface
{
    private $base;

    function __construct() {
        $this->base = 'mkd_elements_holder';
        add_action('vc_before_init', array($this, 'vcMap'));
    }

    public function getBase() {
        return $this->base;
    }

    public function vcMap() {
        vc_map(array(
            'name' => esc_html__('Elements Holder', 'highrise'),
            'base' => $this->base,
            'icon' => 'icon-wpb-elements-holder extended-custom-icon',
            'category' => esc_html__('by MIKADO', 'highrise'),
            'as_parent' => array('only' => 'mkd_elements_holder_item, mkd_info_box'),
            'js_view' => 'VcColumnView',
            'params' => array(
                array(
                    'type' => 'colorpicker',
                    'class' => '',
                    'heading' => esc_html__('Background Color', 'highrise'),
                    'param_name' => 'background_color',
                    'value' => ''
                ),
                array(
                    'type' => 'checkbox',
                    'class' => '',
                    'heading' => esc_html__('Items Float Left', 'highrise'),
                    'param_name' => 'items_float_left',
                    'value' => array(esc_html__('Make Items Float Left?', 'highrise') => 'yes')
                ),
                array(
                    'type' => 'dropdown',
                    'class' => '',
                    'group' => esc_html__('Width & Responsiveness', 'highrise'),
                    'heading' => esc_html__('Switch to One Column', 'highrise'),
                    'param_name' => 'switch_to_one_column',
                    'value' => array(
                        esc_html__('Default', 'highrise') => '',
                        esc_html__('Below 1440px', 'highrise') => '1440',
                        esc_html__('Below 1280px', 'highrise') => '1280',
                        esc_html__('Below 1024px', 'highrise') => '1024',
                        esc_html__('Below 768px', 'highrise') => '768',
                        esc_html__('Below 600px', 'highrise') => '600',
                        esc_html__('Below 480px', 'highrise') => '480',
                        esc_html__('Never', 'highrise') => 'never'
                    ),
                    'description' => esc_html__('Choose on which stage item will be in one column', 'highrise')
                ),
                array(
                    'type' => 'dropdown',
                    'class' => '',
                    'group' => esc_html__('Width & Responsiveness', 'highrise'),
                    'heading' => esc_html__('Choose Alignment In Responsive Mode', 'highrise'),
                    'param_name' => 'alignment_one_column',
                    'value' => array(
                        esc_html__('Default', 'highrise') => '',
                        esc_html__('Left', 'highrise') => 'left',
                        esc_html__('Center', 'highrise') => 'center',
                        esc_html__('Right', 'highrise') => 'right'
                    ),
                    'description' => esc_html__('Alignment When Items are in One Column', 'highrise')
                )
            )
        ));
    }

    public function render($atts, $content = null) {

        $args = array(
            'switch_to_one_column' => '',
            'alignment_one_column' => '',
            'items_float_left' => '',
            'background_color' => ''
        );

        $params = shortcode_atts($args, $atts);
        extract($params);

        $html = '';

        $elements_holder_classes = array();
        $elements_holder_classes[] = 'mkd-elements-holder';
        $elements_holder_style = '';

        if ($switch_to_one_column != '') {
            $elements_holder_classes[] = 'mkd-responsive-mode-' . $switch_to_one_column;
        } else {
            $elements_holder_classes[] = 'mkd-responsive-mode-768';
        }

        if ($alignment_one_column != '') {
            $elements_holder_classes[] = 'mkd-one-column-alignment-' . $alignment_one_column;
        }

        if ($items_float_left !== '') {
            $elements_holder_classes[] = 'mkd-elements-items-float';
        }

        if ($background_color != '') {
            $elements_holder_style .= 'background-color:' . $background_color . ';';
        }

        $elements_holder_class = implode(' ', $elements_holder_classes);

        $html .= '<div ' . highrise_mikado_get_class_attribute($elements_holder_class) . ' ' . highrise_mikado_get_inline_attr($elements_holder_style, 'style') . '>';
        $html .= do_shortcode($content);
        $html .= '</div>';

        return $html;

    }

}
