<?php

namespace Highrise\Modules\Shortcodes\ContentSlider;

use Highrise\Modules\Shortcodes\Lib\ShortcodeInterface;

/**
 * class Content Slider
 */
class ContentSlider implements ShortcodeInterface
{
    /**
     * @var string
     */
    private $base;

    function __construct() {
        $this->base = 'mkd_content_slider';
        add_action('vc_before_init', array($this, 'vcMap'));
    }

    public function getBase() {
        return $this->base;
    }

    public function vcMap() {
        if (function_exists('vc_map')) {
            vc_map(array(
                'name' => esc_html__('Content Slider Item', 'highrise'),
                'base' => $this->base,
                'icon' => 'icon-wpb-content-slider-item extended-custom-icon',
                'category' => esc_html__('by MIKADO', 'highrise'),
                'allowed_container_element' => 'vc_row',
                'as_child' => array('only' => 'mkd_content_slider_holder'),
                'params' => array(
                    array(
                        'type' => 'attach_image',
                        'admin_label' => true,
                        'heading' => esc_html__('Slide Image', 'highrise'),
                        'param_name' => 'image',
                        'value' => '',
                        'description' => esc_html__('Select image from media library.', 'highrise'),
                    ),
                    array(
                        'type' => 'dropdown',
                        'class' => '',
                        'heading' => esc_html__('Image Position', 'highrise'),
                        'param_name' => 'image_position',
                        'value' => array(
                            esc_html__('Left', 'highrise') => 'left',
                            esc_html__('Right', 'highrise') => 'right',
                        ),
                        'save_always' => true,
                        'description' => ''
                    ),
                    array(
                        'type' => 'colorpicker',
                        'heading' => esc_html('Content Background', 'highrise'),
                        'param_name' => 'content_background',
                        'description' => '',
                    ),
                    array(
                        'type' => 'textarea_html',
                        'holder' => 'div',
                        'class' => '',
                        'heading' => esc_html__('Content', 'highrise'),
                        'param_name' => 'content',
                        'value' => '',
                        'description' => '',
                    ),
                )
            ));
        }
    }

    public function render($atts, $content = null) {
        $args = array(
            'image' => '',
            'image_position' => '',
            'content_background' => ''
        );

        $params = shortcode_atts($args, $atts);

        // extract params for use in method
        extract($params);
        $params['content'] = $content;

        $params['content_background_style'] = $this->getContentBackgroundStyle($params);

        $output = '';

        $output .= highrise_mikado_get_shortcode_module_template_part('templates/content-slider', 'content-slider', '', $params);

        return $output;
    }

    private function getContentBackgroundStyle($params) {

        $content_background_style = array();

        if (!empty($params['content_background'])) {
            $content_background_style[] = 'background-color: ' . $params['content_background'];
        }

        return implode(';', $content_background_style);
    }
}