<?php

if (!function_exists('highrise_mikado_button_map')) {
    function highrise_mikado_button_map() {
        $panel = highrise_mikado_add_admin_panel(array(
            'title' => esc_html__('Button', 'highrise'),
            'name' => 'panel_button',
            'page' => '_elements_page'
        ));

        //Typography options
        highrise_mikado_add_admin_section_title(array(
            'name' => 'typography_section_title',
            'title' => esc_html__('Typography', 'highrise'),
            'parent' => $panel
        ));

        $typography_group = highrise_mikado_add_admin_group(array(
            'name' => 'typography_group',
            'title' => esc_html__('Typography', 'highrise'),
            'description' => esc_html__('Setup typography for all button types', 'highrise'),
            'parent' => $panel
        ));

        $typography_row = highrise_mikado_add_admin_row(array(
            'name' => 'typography_row',
            'next' => true,
            'parent' => $typography_group
        ));

        highrise_mikado_add_admin_field(array(
            'parent' => $typography_row,
            'type' => 'fontsimple',
            'name' => 'button_font_family',
            'default_value' => '',
            'label' => esc_html__('Font Family', 'highrise'),
        ));

        highrise_mikado_add_admin_field(array(
            'parent' => $typography_row,
            'type' => 'selectsimple',
            'name' => 'button_text_transform',
            'default_value' => '',
            'label' => esc_html__('Text Transform', 'highrise'),
            'options' => highrise_mikado_get_text_transform_array()
        ));

        highrise_mikado_add_admin_field(array(
            'parent' => $typography_row,
            'type' => 'selectsimple',
            'name' => 'button_font_style',
            'default_value' => '',
            'label' => esc_html__('Font Style', 'highrise'),
            'options' => highrise_mikado_get_font_style_array()
        ));

        highrise_mikado_add_admin_field(array(
            'parent' => $typography_row,
            'type' => 'textsimple',
            'name' => 'button_letter_spacing',
            'default_value' => '',
            'label' => esc_html__('Letter Spacing', 'highrise'),
            'args' => array(
                'suffix' => 'px'
            )
        ));

        $typography_row2 = highrise_mikado_add_admin_row(array(
            'name' => 'typography_row2',
            'next' => true,
            'parent' => $typography_group
        ));

        highrise_mikado_add_admin_field(array(
            'parent' => $typography_row2,
            'type' => 'selectsimple',
            'name' => 'button_font_weight',
            'default_value' => '',
            'label' => esc_html__('Font Weight', 'highrise'),
            'options' => highrise_mikado_get_font_weight_array()
        ));

        //Outline type options
        highrise_mikado_add_admin_section_title(array(
            'name' => 'type_section_title',
            'title' => esc_html__('Types', 'highrise'),
            'parent' => $panel
        ));

        $outline_group = highrise_mikado_add_admin_group(array(
            'name' => 'outline_group',
            'title' => esc_html__('Outline Type', 'highrise'),
            'description' => esc_html__('Setup outline button type', 'highrise'),
            'parent' => $panel
        ));

        $outline_row = highrise_mikado_add_admin_row(array(
            'name' => 'outline_row',
            'next' => true,
            'parent' => $outline_group
        ));

        highrise_mikado_add_admin_field(array(
            'parent' => $outline_row,
            'type' => 'colorsimple',
            'name' => 'btn_outline_text_color',
            'default_value' => '',
            'label' => esc_html__('Text Color', 'highrise'),
            'description' => ''
        ));

        highrise_mikado_add_admin_field(array(
            'parent' => $outline_row,
            'type' => 'colorsimple',
            'name' => 'btn_outline_hover_text_color',
            'default_value' => '',
            'label' => esc_html__('Text Hover Color', 'highrise'),
            'description' => ''
        ));

        highrise_mikado_add_admin_field(array(
            'parent' => $outline_row,
            'type' => 'colorsimple',
            'name' => 'btn_outline_hover_bg_color',
            'default_value' => '',
            'label' => esc_html__('Hover Background Color', 'highrise'),
            'description' => ''
        ));

        highrise_mikado_add_admin_field(array(
            'parent' => $outline_row,
            'type' => 'colorsimple',
            'name' => 'btn_outline_border_color',
            'default_value' => '',
            'label' => esc_html__('Border Color', 'highrise'),
            'description' => ''
        ));

        $outline_row2 = highrise_mikado_add_admin_row(array(
            'name' => 'outline_row2',
            'next' => true,
            'parent' => $outline_group
        ));

        highrise_mikado_add_admin_field(array(
            'parent' => $outline_row2,
            'type' => 'colorsimple',
            'name' => 'btn_outline_hover_border_color',
            'default_value' => '',
            'label' => esc_html__('Hover Border Color', 'highrise'),
            'description' => ''
        ));

        //Solid type options
        $solid_group = highrise_mikado_add_admin_group(array(
            'name' => 'solid_group',
            'title' => esc_html__('Solid Type', 'highrise'),
            'description' => esc_html__('Setup solid button type', 'highrise'),
            'parent' => $panel
        ));

        $solid_row = highrise_mikado_add_admin_row(array(
            'name' => 'solid_row',
            'next' => true,
            'parent' => $solid_group
        ));

        highrise_mikado_add_admin_field(array(
            'parent' => $solid_row,
            'type' => 'colorsimple',
            'name' => 'btn_solid_text_color',
            'default_value' => '',
            'label' => esc_html__('Text Color', 'highrise'),
            'description' => ''
        ));

        highrise_mikado_add_admin_field(array(
            'parent' => $solid_row,
            'type' => 'colorsimple',
            'name' => 'btn_solid_hover_text_color',
            'default_value' => '',
            'label' => esc_html__('Text Hover Color', 'highrise'),
            'description' => ''
        ));

        highrise_mikado_add_admin_field(array(
            'parent' => $solid_row,
            'type' => 'colorsimple',
            'name' => 'btn_solid_bg_color',
            'default_value' => '',
            'label' => esc_html__('Background Color', 'highrise'),
            'description' => ''
        ));

        highrise_mikado_add_admin_field(array(
            'parent' => $solid_row,
            'type' => 'colorsimple',
            'name' => 'btn_solid_hover_bg_color',
            'default_value' => '',
            'label' => esc_html__('Hover Background Color', 'highrise'),
            'description' => ''
        ));

        $solid_row2 = highrise_mikado_add_admin_row(array(
            'name' => 'solid_row2',
            'next' => true,
            'parent' => $solid_group
        ));

        highrise_mikado_add_admin_field(array(
            'parent' => $solid_row2,
            'type' => 'colorsimple',
            'name' => 'btn_solid_border_color',
            'default_value' => '',
            'label' => esc_html__('Border Color', 'highrise'),
            'description' => ''
        ));

        highrise_mikado_add_admin_field(array(
            'parent' => $solid_row2,
            'type' => 'colorsimple',
            'name' => 'btn_solid_hover_border_color',
            'default_value' => '',
            'label' => esc_html__('Hover Border Color', 'highrise'),
            'description' => ''
        ));
    }

    add_action('highrise_mikado_options_elements_map', 'highrise_mikado_button_map');
}