<?php

namespace Highrise\Modules\Shortcodes\AnimationHolder;

use Highrise\Modules\Shortcodes\Lib\ShortcodeInterface;

/**
 * class Animation Holder
 */
class AnimationHolder implements ShortcodeInterface
{
    /**
     * @var string
     */
    private $base;

    function __construct() {
        $this->base = 'mkd_animation_holder';
        add_action('vc_before_init', array($this, 'vcMap'));
    }

    public function getBase() {
        return $this->base;
    }

    public function vcMap() {
        vc_map(array(
            'name' => esc_html__('Animation Holder', 'highrise'),
            'base' => $this->base,
            "as_parent" => array('except' => 'vc_row'),
            'content_element' => true,
            'category' => esc_html__('by MIKADO', 'highrise'),
            'icon' => 'icon-wpb-animation-holder extended-custom-icon',
            'show_settings_on_create' => true,
            'js_view' => 'VcColumnView',
            'params' => array(
                array(
                    'type' => 'dropdown',
                    'param_name' => 'animation',
                    'heading' => esc_html__('Animation Type', 'highrise'),
                    'value' => array(
                        esc_html__('Element Grow In', 'highrise') => 'mkd-grow-in',
                        esc_html__('Element Fade In Down', 'highrise') => 'mkd-fade-in-down',
                        esc_html__('Element From Fade', 'highrise') => 'mkd-element-from-fade',
                        esc_html__('Element From Left', 'highrise') => 'mkd-element-from-left',
                        esc_html__('Element From Right', 'highrise') => 'mkd-element-from-right',
                        esc_html__('Element From Top', 'highrise') => 'mkd-element-from-top',
                        esc_html__('Element From Bottom', 'highrise') => 'mkd-element-from-bottom',
                        esc_html__('Element Flip In', 'highrise') => 'mkd-flip-in',
                        esc_html__('Element X Rotate', 'highrise') => 'mkd-x-rotate',
                        esc_html__('Element Z Rotate', 'highrise') => 'mkd-z-rotate',
                        esc_html__('Element Y Translate', 'highrise') => 'mkd-y-translate',
                        esc_html__('Element Fade In X Rotate', 'highrise') => 'mkd-fade-in-left-x-rotate',
                    )
                ),
                array(
                    'type' => 'textfield',
                    'param_name' => 'animation_delay',
                    'heading' => esc_html__('Animation Delay (ms)', 'highrise')
                )
            )
        ));
    }

    public function render($atts, $content = null) {
        $args = array(
            'animation' => '',
            'animation_delay' => ''
        );

        extract(shortcode_atts($args, $atts));

        $html = '<div class="mkd-animation-holder ' . esc_attr($animation) . '" data-animation="' . esc_attr($animation) . '" data-animation-delay="' . esc_attr($animation_delay) . '"><div class="mkd-animation-inner">' . do_shortcode($content) . '</div></div>';

        return $html;
    }
}