<?php

if (!function_exists('highrise_mikado_search_opener_icon_size')) {

    function highrise_mikado_search_opener_icon_size() {

        if(highrise_mikado_options()->getOptionValue('header_search_icon_size')) {
            echo highrise_mikado_dynamic_css('.mkd-search-opener > *:not(.mkd-search-icon-text)', array(
                'font-size' => highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('header_search_icon_size')).'px!important'
            ));
        }

    }

    add_action('highrise_mikado_style_dynamic', 'highrise_mikado_search_opener_icon_size');

}

if (!function_exists('highrise_mikado_search_opener_icon_colors')) {

    function highrise_mikado_search_opener_icon_colors() {

        if (highrise_mikado_options()->getOptionValue('header_search_icon_color') !== '') {
            echo highrise_mikado_dynamic_css('.mkd-page-header .mkd-search-opener', array(
                'color' => highrise_mikado_options()->getOptionValue('header_search_icon_color')
            ));
        }

        if (highrise_mikado_options()->getOptionValue('header_search_icon_hover_color') !== '') {
            echo highrise_mikado_dynamic_css('.mkd-page-header .mkd-search-opener:hover', array(
                'color' => highrise_mikado_options()->getOptionValue('header_search_icon_hover_color')
            ));
        }

        if (highrise_mikado_options()->getOptionValue('header_light_search_icon_color') !== '') {
            echo highrise_mikado_dynamic_css('.mkd-light-header .mkd-page-header > div:not(.mkd-sticky-header) .mkd-search-opener,
			.mkd-light-header.mkd-header-style-on-scroll .mkd-page-header .mkd-search-opener,
			.mkd-light-header .mkd-top-bar .mkd-search-opener', array(
                'color' => highrise_mikado_options()->getOptionValue('header_light_search_icon_color') . ' !important'
            ));
        }

        if (highrise_mikado_options()->getOptionValue('header_light_search_icon_hover_color') !== '') {
            echo highrise_mikado_dynamic_css('.mkd-light-header .mkd-page-header > div:not(.mkd-sticky-header) .mkd-search-opener:hover,
			.mkd-light-header.mkd-header-style-on-scroll .mkd-page-header .mkd-search-opener:hover,
			.mkd-light-header .mkd-top-bar .mkd-search-opener:hover', array(
                'color' => highrise_mikado_options()->getOptionValue('header_light_search_icon_hover_color') . ' !important'
            ));
        }

        if (highrise_mikado_options()->getOptionValue('header_dark_search_icon_color') !== '') {
            echo highrise_mikado_dynamic_css('.mkd-dark-header .mkd-page-header > div:not(.mkd-sticky-header) .mkd-search-opener,
			.mkd-dark-header.mkd-header-style-on-scroll .mkd-page-header .mkd-search-opener,
			.mkd-dark-header .mkd-top-bar .mkd-search-opener', array(
                'color' => highrise_mikado_options()->getOptionValue('header_dark_search_icon_color') . ' !important'
            ));
        }
        if (highrise_mikado_options()->getOptionValue('header_dark_search_icon_hover_color') !== '') {
            echo highrise_mikado_dynamic_css('.mkd-dark-header .mkd-page-header > div:not(.mkd-sticky-header) .mkd-search-opener:hover,
			.mkd-dark-header.mkd-header-style-on-scroll .mkd-page-header .mkd-search-opener:hover,
			.mkd-dark-header .mkd-top-bar .mkd-search-opener:hover', array(
                'color' => highrise_mikado_options()->getOptionValue('header_dark_search_icon_hover_color') . ' !important'
            ));
        }

    }

    add_action('highrise_mikado_style_dynamic', 'highrise_mikado_search_opener_icon_colors');

}

if (!function_exists('highrise_mikado_search_opener_icon_background_colors')) {

    function highrise_mikado_search_opener_icon_background_colors() {

        if (highrise_mikado_options()->getOptionValue('search_icon_background_color') !== '') {
            echo highrise_mikado_dynamic_css('.mkd-search-opener', array(
                'background-color' => highrise_mikado_options()->getOptionValue('search_icon_background_color')
            ));
        }

        if (highrise_mikado_options()->getOptionValue('search_icon_background_hover_color') !== '') {
            echo highrise_mikado_dynamic_css('.mkd-search-opener:hover', array(
                'background-color' => highrise_mikado_options()->getOptionValue('search_icon_background_hover_color')
            ));
        }

    }

    add_action('highrise_mikado_style_dynamic', 'highrise_mikado_search_opener_icon_background_colors');
}

if (!function_exists('highrise_mikado_search_opener_text_styles')) {

    function highrise_mikado_search_opener_text_styles() {
        $text_styles = array();

        if (highrise_mikado_options()->getOptionValue('search_icon_text_color') !== '') {
            $text_styles['color'] = highrise_mikado_options()->getOptionValue('search_icon_text_color');
        }
        if (highrise_mikado_options()->getOptionValue('search_icon_text_fontsize') !== '') {
            $text_styles['font-size'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('search_icon_text_fontsize')) . 'px';
        }
        if (highrise_mikado_options()->getOptionValue('search_icon_text_lineheight') !== '') {
            $text_styles['line-height'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('search_icon_text_lineheight')) . 'px';
        }
        if (highrise_mikado_options()->getOptionValue('search_icon_text_texttransform') !== '') {
            $text_styles['text-transform'] = highrise_mikado_options()->getOptionValue('search_icon_text_texttransform');
        }
        if (highrise_mikado_options()->getOptionValue('search_icon_text_google_fonts') !== '-1') {
            $text_styles['font-family'] = highrise_mikado_get_formatted_font_family(highrise_mikado_options()->getOptionValue('search_icon_text_google_fonts')) . ', sans-serif';
        }
        if (highrise_mikado_options()->getOptionValue('search_icon_text_fontstyle') !== '') {
            $text_styles['font-style'] = highrise_mikado_options()->getOptionValue('search_icon_text_fontstyle');
        }
        if (highrise_mikado_options()->getOptionValue('search_icon_text_fontweight') !== '') {
            $text_styles['font-weight'] = highrise_mikado_options()->getOptionValue('search_icon_text_fontweight');
        }

        if (!empty($text_styles)) {
            echo highrise_mikado_dynamic_css('.mkd-search-icon-text', $text_styles);
        }
        if (highrise_mikado_options()->getOptionValue('search_icon_text_color_hover') !== '') {
            echo highrise_mikado_dynamic_css('.mkd-search-opener:hover .mkd-search-icon-text', array(
                'color' => highrise_mikado_options()->getOptionValue('search_icon_text_color_hover')
            ));
        }

    }

    add_action('highrise_mikado_style_dynamic', 'highrise_mikado_search_opener_text_styles');
}

if (!function_exists('highrise_mikado_search_opener_spacing')) {

    function highrise_mikado_search_opener_spacing() {
        $spacing_styles = array();

        if (highrise_mikado_options()->getOptionValue('search_padding_left') !== '') {
            $spacing_styles['padding-left'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('search_padding_left')) . 'px';
        }
        if (highrise_mikado_options()->getOptionValue('search_padding_right') !== '') {
            $spacing_styles['padding-right'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('search_padding_right')) . 'px';
        }
        if (highrise_mikado_options()->getOptionValue('search_margin_left') !== '') {
            $spacing_styles['margin-left'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('search_margin_left')) . 'px';
        }
        if (highrise_mikado_options()->getOptionValue('search_margin_right') !== '') {
            $spacing_styles['margin-right'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('search_margin_right')) . 'px';
        }

        if (!empty($spacing_styles)) {
            echo highrise_mikado_dynamic_css('.mkd-search-opener', $spacing_styles);
        }

    }

    add_action('highrise_mikado_style_dynamic', 'highrise_mikado_search_opener_spacing');
}

if (!function_exists('highrise_mikado_search_bar_background')) {

    function highrise_mikado_search_bar_background() {

        if (highrise_mikado_options()->getOptionValue('search_background_color') !== '') {
            echo highrise_mikado_dynamic_css('
            .mkd-search-fade .mkd-fullscreen-search-holder .mkd-fullscreen-search-table, 
            .mkd-fullscreen-search-overlay, .mkd-search-slide-window-top, 
            .mkd-search-slide-window-top input[type="text"],
            .mkd-search-dropdown .mkd-search-dropdown-holder input[type="text"]
            ', array(
                'background-color' => highrise_mikado_options()->getOptionValue('search_background_color')
            ));
        }
    }

    add_action('highrise_mikado_style_dynamic', 'highrise_mikado_search_bar_background');
}

if (!function_exists('highrise_mikado_search_text_styles')) {

    function highrise_mikado_search_text_styles() {
        $text_styles = array();

        if (highrise_mikado_options()->getOptionValue('search_text_color') !== '') {
            $text_styles['color'] = highrise_mikado_options()->getOptionValue('search_text_color');
        }
        if (highrise_mikado_options()->getOptionValue('search_text_fontsize') !== '') {
            $text_styles['font-size'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('search_text_fontsize')) . 'px';
        }
        if (highrise_mikado_options()->getOptionValue('search_text_texttransform') !== '') {
            $text_styles['text-transform'] = highrise_mikado_options()->getOptionValue('search_text_texttransform');
        }
        if (highrise_mikado_options()->getOptionValue('search_text_google_fonts') !== '-1') {
            $text_styles['font-family'] = highrise_mikado_get_formatted_font_family(highrise_mikado_options()->getOptionValue('search_text_google_fonts')) . ', sans-serif';
        }
        if (highrise_mikado_options()->getOptionValue('search_text_fontstyle') !== '') {
            $text_styles['font-style'] = highrise_mikado_options()->getOptionValue('search_text_fontstyle');
        }
        if (highrise_mikado_options()->getOptionValue('search_text_fontweight') !== '') {
            $text_styles['font-weight'] = highrise_mikado_options()->getOptionValue('search_text_fontweight');
        }
        if (highrise_mikado_options()->getOptionValue('search_text_letterspacing') !== '') {
            $text_styles['letter-spacing'] = highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('search_text_letterspacing')) . 'px';
        }

        if(!empty($text_styles)) {
            echo highrise_mikado_dynamic_css('
            .mkd-search-cover input[type="text"], 
            .mkd-fullscreen-search-holder .mkd-form-holder .mkd-search-field, 
            .mkd-search-slide-window-top input[type="text"],
            .mkd-search-dropdown .mkd-search-dropdown-holder input[type="text"]', $text_styles);
        }
        if(highrise_mikado_options()->getOptionValue('search_text_disabled_color') !== '') {
            echo highrise_mikado_dynamic_css('
            .mkd-search-cover input[type="text"]::-webkit-input-placeholder, 
            .mkd-search-cover input[type="text"]::-moz-placeholder,
            .mkd-fullscreen-search-holder .mkd-form-holder .mkd-search-field::-webkit-input-placeholder, 
            .mkd-fullscreen-search-holder .mkd-form-holder .mkd-search-field::-moz-placeholder,
            .mkd-search-slide-window-top input[type="text"]::-webkit-input-placeholder, 
            .mkd-search-slide-window-top input[type="text"]::-moz-placeholder,
            .mkd-search-dropdown .mkd-search-dropdown-holder input[type="text"]::-webkit-input-placeholder,
            .mkd-search-dropdown .mkd-search-dropdown-holder input[type="text"]::-moz-placeholder
            '

                , array(
                'color' => highrise_mikado_options()->getOptionValue('search_text_disabled_color')
            ));
        }

    }

    add_action('highrise_mikado_style_dynamic', 'highrise_mikado_search_text_styles');
}

if(!function_exists('highrise_mikado_search_fullscreen_styles')) {

    function highrise_mikado_search_fullscreen_styles() {
        $border_styles = array();

        if(highrise_mikado_options()->getOptionValue('search_border_color') !== '') {
            $border_styles['border-color'] = highrise_mikado_options()->getOptionValue('search_border_color');
        }

        if(!empty($border_styles)) {
            echo highrise_mikado_dynamic_css('.mkd-fullscreen-search-holder .mkd-field-holder', $border_styles);
        }

        $border_styles = array();

        if(highrise_mikado_options()->getOptionValue('search_border_focus_color') !== '') {
            $border_styles['background-color'] = highrise_mikado_options()->getOptionValue('search_border_focus_color');
        }

        if(!empty($border_styles)) {
            echo highrise_mikado_dynamic_css('.mkd-fullscreen-search-holder .mkd-field-holder .mkd-line', $border_styles);
        }

    }

    add_action('highrise_mikado_style_dynamic', 'highrise_mikado_search_fullscreen_styles');
}

if (!function_exists('highrise_mikado_search_icon_styles')) {

    function highrise_mikado_search_icon_styles() {

        if (highrise_mikado_options()->getOptionValue('search_icon_color') !== '') {
            echo highrise_mikado_dynamic_css('.mkd-search-slide-window-top i, .mkd-fullscreen-search-holder .mkd-search-submit', array(
                'color' => highrise_mikado_options()->getOptionValue('search_icon_color')
            ));
        }
        if (highrise_mikado_options()->getOptionValue('search_icon_hover_color') !== '') {
            echo highrise_mikado_dynamic_css('.mkd-search-slide-window-top > i:hover, .mkd-fullscreen-search-holder .mkd-search-submit:hover', array(
                'color' => highrise_mikado_options()->getOptionValue('search_icon_hover_color')
            ));
        }
        if (highrise_mikado_options()->getOptionValue('search_icon_size') !== '') {
            echo highrise_mikado_dynamic_css('.mkd-search-slide-window-top > i, .mkd-fullscreen-search-holder .mkd-search-submit', array(
                'font-size' => highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('search_icon_size')) . 'px'
            ));
        }

    }

    add_action('highrise_mikado_style_dynamic', 'highrise_mikado_search_icon_styles');
}

if (!function_exists('highrise_mikado_search_close_icon_styles')) {

    function highrise_mikado_search_close_icon_styles() {

        if (highrise_mikado_options()->getOptionValue('search_close_color') !== '') {
            echo highrise_mikado_dynamic_css('.mkd-search-slide-window-top .mkd-search-close i, .mkd-search-cover .mkd-search-close i, .mkd-fullscreen-search-close i', array(
                'color' => highrise_mikado_options()->getOptionValue('search_close_color')
            ));
        }
        if (highrise_mikado_options()->getOptionValue('search_close_hover_color') !== '') {
            echo highrise_mikado_dynamic_css('.mkd-search-slide-window-top .mkd-search-close i:hover, .mkd-search-cover .mkd-search-close i:hover, .mkd-fullscreen-search-close i:hover', array(
                'color' => highrise_mikado_options()->getOptionValue('search_close_hover_color')
            ));
        }
        if (highrise_mikado_options()->getOptionValue('search_close_size') !== '') {
            echo highrise_mikado_dynamic_css('.mkd-search-slide-window-top .mkd-search-close i, .mkd-search-cover .mkd-search-close i, .mkd-fullscreen-search-close i', array(
                'font-size' => highrise_mikado_filter_px(highrise_mikado_options()->getOptionValue('search_close_size')) . 'px'
            ));
        }

    }

    add_action('highrise_mikado_style_dynamic', 'highrise_mikado_search_close_icon_styles');
}

if (!function_exists('highrise_mikado_fullscreen_search_styles')) {
    function highrise_mikado_fullscreen_search_styles() {
        $bg_image = highrise_mikado_options()->getOptionValue('fullscreen_search_background_image');
        $selector = '.mkd-search-fade .mkd-fullscreen-search-holder';
        $styles = array();

        if (!$bg_image) {
            return;
        }

        $styles['background-image'] = 'url(' . $bg_image . ')';

        echo highrise_mikado_dynamic_css($selector, $styles);
    }

    add_action('highrise_mikado_style_dynamic', 'highrise_mikado_fullscreen_search_styles');
}

?>