<?php

if (!function_exists('highrise_mikado_portfolio_options_map')) {
    function highrise_mikado_portfolio_options_map() {

        highrise_mikado_add_admin_page(array(
            'slug' => '_portfolio',
            'title' => esc_html__('Portfolio', 'highrise'),
            'icon' => 'fa fa-camera-retro'
        ));

        $panel_archive = highrise_mikado_add_admin_panel(array(
            'title' => esc_html__('Portfolio Archive', 'highrise'),
            'name' => 'panel_portfolio_archive',
            'page' => '_portfolio'
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'portfolio_archive_number_of_items',
            'type' => 'text',
            'label' => esc_html__('Number of Items', 'highrise'),
            'description' => esc_html__('Set number of items for your portfolio list on archive pages. Default value is 12', 'highrise'),
            'parent' => $panel_archive,
            'args' => array(
                'col_width' => 3
            )
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'portfolio_archive_number_of_columns',
            'type' => 'select',
            'label' => esc_html__('Number of Columns', 'highrise'),
            'default_value' => '4',
            'description' => esc_html__('Set number of columns for your portfolio list on archive pages. Default value is 4 columns', 'highrise'),
            'parent' => $panel_archive,
            'options' => array(
                '2' => esc_html__('2 Columns', 'highrise'),
                '3' => esc_html__('3 Columns', 'highrise'),
                '4' => esc_html__('4 Columns', 'highrise'),
                '5' => esc_html__('5 Columns', 'highrise')
            )
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'portfolio_archive_space_between_items',
            'type' => 'select',
            'label' => esc_html__('Space Between Items', 'highrise'),
            'default_value' => 'normal',
            'description' => esc_html__('Set space size between portfolio items for your portfolio list on archive pages. Default value is normal', 'highrise'),
            'parent' => $panel_archive,
            'options' => array(
                'normal' => esc_html__('Normal', 'highrise'),
                'small' => esc_html__('Small', 'highrise'),
                'tiny' => esc_html__('Tiny', 'highrise'),
                'no' => esc_html__('No Space', 'highrise')
            )
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'portfolio_archive_image_size',
            'type' => 'select',
            'label' => esc_html__('Image Proportions', 'highrise'),
            'default_value' => 'landscape',
            'description' => esc_html__('Set image proportions for your portfolio list on archive pages. Default value is landscape', 'highrise'),
            'parent' => $panel_archive,
            'options' => array(
                'full' => esc_html__('Original', 'highrise'),
                'landscape' => esc_html__('Landscape', 'highrise'),
                'portrait' => esc_html__('Portrait', 'highrise'),
                'square' => esc_html__('Square', 'highrise')
            )
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'portfolio_archive_item_layout',
            'type' => 'select',
            'label' => esc_html__('Item Layout', 'highrise'),
            'default_value' => 'standard-shader',
            'description' => esc_html__('Set item layour for your portfolio list on archive pages. Default value is Standard - Shader layout', 'highrise'),
            'parent' => $panel_archive,
            'options' => array(
                'standard-shader' => esc_html__('Standard - Shader', 'highrise'),
                'gallery-overlay' => esc_html__('Gallery - Overlay', 'highrise')
            )
        ));

        $panel = highrise_mikado_add_admin_panel(array(
            'title' => esc_html__('Portfolio Single', 'highrise'),
            'name' => 'panel_portfolio_single',
            'page' => '_portfolio'
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'portfolio_single_template',
            'type' => 'select',
            'label' => esc_html__('Portfolio Type', 'highrise'),
            'default_value' => 'small-images',
            'description' => esc_html__('Choose a default type for Single Project pages', 'highrise'),
            'parent' => $panel,
            'options' => array(
                'huge-images' => esc_html__('Portfolio Full Width Images', 'highrise'),
                'images' => esc_html__('Portfolio Images', 'highrise'),
                'small-images' => esc_html__('Portfolio Small Images', 'highrise'),
                'slider' => esc_html__('Portfolio Slider', 'highrise'),
                'small-slider' => esc_html__('Portfolio Small Slider', 'highrise'),
                'gallery' => esc_html__('Portfolio Gallery', 'highrise'),
                'small-gallery' => esc_html__('Portfolio Small Gallery', 'highrise'),
                'masonry' => esc_html__('Portfolio Masonry', 'highrise'),
                'small-masonry' => esc_html__('Portfolio Small Masonry', 'highrise'),
                'custom' => esc_html__('Portfolio Custom', 'highrise'),
                'full-width-custom' => esc_html__('Portfolio Full Width Custom', 'highrise')
            ),
            'args' => array(
                'dependence' => true,
                'show' => array(
                    'huge-images' => '',
                    'images' => '',
                    'small-images' => '',
                    'slider' => '',
                    'small-slider' => '',
                    'gallery' => '#mkd_portfolio_gallery_container',
                    'small-gallery' => '#mkd_portfolio_gallery_container',
                    'masonry' => '#mkd_portfolio_masonry_container',
                    'small-masonry' => '#mkd_portfolio_masonry_container',
                    'custom' => '',
                    'full-width-custom' => ''
                ),
                'hide' => array(
                    'huge-images' => '#mkd_portfolio_gallery_container, #mkd_portfolio_masonry_container',
                    'images' => '#mkd_portfolio_gallery_container, #mkd_portfolio_masonry_container',
                    'small-images' => '#mkd_portfolio_gallery_container, #mkd_portfolio_masonry_container',
                    'slider' => '#mkd_portfolio_gallery_container, #mkd_portfolio_masonry_container',
                    'small-slider' => '#mkd_portfolio_gallery_container, #mkd_portfolio_masonry_container',
                    'gallery' => '#mkd_portfolio_masonry_container',
                    'small-gallery' => '#mkd_portfolio_masonry_container',
                    'masonry' => '#mkd_portfolio_gallery_container',
                    'small-masonry' => '#mkd_portfolio_gallery_container',
                    'custom' => '#mkd_portfolio_gallery_container, #mkd_portfolio_masonry_container',
                    'full-width-custom' => '#mkd_portfolio_gallery_container, #mkd_portfolio_masonry_container'
                )
            )
        ));

        /***************** Gallery Layout *****************/

        $portfolio_gallery_container = highrise_mikado_add_admin_container(array(
            'parent' => $panel,
            'name' => 'portfolio_gallery_container',
            'hidden_property' => 'portfolio_single_template',
            'hidden_values' => array(
                'huge-images',
                'images',
                'small-images',
                'slider',
                'small-slider',
                'masonry',
                'small-masonry',
                'custom',
                'full-width-custom'
            )
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'portfolio_single_gallery_columns_number',
            'type' => 'select',
            'label' => esc_html__('Number of Columns', 'highrise'),
            'default_value' => 'three',
            'description' => esc_html__('Set number of columns for portfolio gallery type', 'highrise'),
            'parent' => $portfolio_gallery_container,
            'options' => array(
                'two' => esc_html__('2 Columns', 'highrise'),
                'three' => esc_html__('3 Columns', 'highrise'),
                'four' => esc_html__('4 Columns', 'highrise')
            )
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'portfolio_single_gallery_space_between_items',
            'type' => 'select',
            'label' => esc_html__('Space Between Items', 'highrise'),
            'default_value' => 'normal',
            'description' => esc_html__('Set space size between columns for portfolio gallery type', 'highrise'),
            'parent' => $portfolio_gallery_container,
            'options' => array(
                'normal' => esc_html__('Normal', 'highrise'),
                'small' => esc_html__('Small', 'highrise'),
                'tiny' => esc_html__('Tiny', 'highrise'),
                'no' => esc_html__('No Space', 'highrise')
            )
        ));

        /***************** Gallery Layout *****************/

        /***************** Masonry Layout *****************/

        $portfolio_masonry_container = highrise_mikado_add_admin_container(array(
            'parent' => $panel,
            'name' => 'portfolio_masonry_container',
            'hidden_property' => 'portfolio_single_template',
            'hidden_values' => array(
                'huge-images',
                'images',
                'small-images',
                'slider',
                'small-slider',
                'gallery',
                'small-gallery',
                'custom',
                'full-width-custom'
            )
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'portfolio_single_masonry_columns_number',
            'type' => 'select',
            'label' => esc_html__('Number of Columns', 'highrise'),
            'default_value' => 'three',
            'description' => esc_html__('Set number of columns for portfolio masonry type', 'highrise'),
            'parent' => $portfolio_masonry_container,
            'options' => array(
                'two' => esc_html__('2 Columns', 'highrise'),
                'three' => esc_html__('3 Columns', 'highrise'),
                'four' => esc_html__('4 Columns', 'highrise')
            )
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'portfolio_single_masonry_space_between_items',
            'type' => 'select',
            'label' => esc_html__('Space Between Items', 'highrise'),
            'default_value' => 'normal',
            'description' => esc_html__('Set space size between columns for portfolio masonry type', 'highrise'),
            'parent' => $portfolio_masonry_container,
            'options' => array(
                'normal' => esc_html__('Normal', 'highrise'),
                'small' => esc_html__('Small', 'highrise'),
                'tiny' => esc_html__('Tiny', 'highrise'),
                'no' => esc_html__('No Space', 'highrise')
            )
        ));

        /***************** Masonry Layout *****************/

        highrise_mikado_add_admin_field(array(
            'name' => 'portfolio_single_lightbox_images',
            'type' => 'yesno',
            'label' => esc_html__('Enable Lightbox for Images', 'highrise'),
            'description' => esc_html__('Enabling this option will turn on lightbox functionality for projects with images', 'highrise'),
            'parent' => $panel,
            'default_value' => 'yes'
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'portfolio_single_lightbox_videos',
            'type' => 'yesno',
            'label' => esc_html__('Enable Lightbox for Videos', 'highrise'),
            'description' => esc_html__('Enabling this option will turn on lightbox functionality for YouTube/Vimeo projects', 'highrise'),
            'parent' => $panel,
            'default_value' => 'no'
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'portfolio_single_enable_categories',
            'type' => 'yesno',
            'label' => esc_html__('Enable Categories', 'highrise'),
            'description' => esc_html__('Enabling this option will enable category meta description on single projects', 'highrise'),
            'parent' => $panel,
            'default_value' => 'yes'
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'portfolio_single_date',
            'type' => 'yesno',
            'label' => esc_html__('Enable Date', 'highrise'),
            'description' => esc_html__('Enabling this option will enable date meta on single projects', 'highrise'),
            'parent' => $panel,
            'default_value' => 'yes'
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'portfolio_single_sticky_sidebar',
            'type' => 'yesno',
            'label' => esc_html__('Enable Sticky Side Text', 'highrise'),
            'description' => esc_html__('Enabling this option will make side text sticky on Single Project pages. This option works only for Full Width Images, Small Images, Small Gallery and Small Masonry portfolio types', 'highrise'),
            'parent' => $panel,
            'default_value' => 'yes'
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'portfolio_single_comments',
            'type' => 'yesno',
            'label' => esc_html__('Show Comments', 'highrise'),
            'description' => esc_html__('Enabling this option will show comments on your page', 'highrise'),
            'parent' => $panel,
            'default_value' => 'no'
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'portfolio_single_hide_pagination',
            'type' => 'yesno',
            'label' => esc_html__('Hide Pagination', 'highrise'),
            'description' => esc_html__('Enabling this option will turn off portfolio pagination functionality', 'highrise'),
            'parent' => $panel,
            'default_value' => 'no',
            'args' => array(
                'dependence' => true,
                'dependence_hide_on_yes' => '#mkd_navigate_same_category_container'
            )
        ));

        $container_navigate_category = highrise_mikado_add_admin_container(array(
            'name' => 'navigate_same_category_container',
            'parent' => $panel,
            'hidden_property' => 'portfolio_single_hide_pagination',
            'hidden_value' => 'yes'
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'portfolio_single_nav_same_category',
            'type' => 'yesno',
            'label' => esc_html__('Enable Pagination Through Same Category', 'highrise'),
            'description' => esc_html__('Enabling this option will make portfolio pagination sort through current category', 'highrise'),
            'parent' => $container_navigate_category,
            'default_value' => 'no'
        ));

        highrise_mikado_add_admin_field(array(
            'name' => 'portfolio_single_slug',
            'type' => 'text',
            'label' => esc_html__('Portfolio Single Slug', 'highrise'),
            'description' => esc_html__('Enter if you wish to use a different Single Project slug (Note: After entering slug, navigate to Settings -> Permalinks and click "Save" in order for changes to take effect)', 'highrise'),
            'parent' => $panel,
            'args' => array(
                'col_width' => 3
            )
        ));
    }

    add_action('highrise_mikado_options_map', 'highrise_mikado_portfolio_options_map', 12);
}