<?php

if ( ! function_exists('highrise_mikado_like') ) {
	/**
	 * Returns HighriseMikadoLike instance
	 *
	 * @return HighriseMikadoLike
	 */
	function highrise_mikado_like() {
		return HighriseMikadoLike::get_instance();
	}

}

function highrise_mikado_get_like() {

	echo wp_kses(highrise_mikado_like()->add_like(), array(
		'span' => array(
			'class' => true,
			'aria-hidden' => true,
			'style' => true,
			'id' => true
		),
/*		'i' => array(
			'class' => true,
			'style' => true,
			'id' => true
		),*/
		'a' => array(
			'href' => true,
			'class' => true,
			'id' => true,
			'title' => true,
			'style' => true
		)
	));
}

if ( ! function_exists('highrise_mikado_like_latest_posts') ) {
	/**
	 * Add like to latest post
	 *
	 * @return string
	 */
	function highrise_mikado_like_latest_posts() {
		return highrise_mikado_like()->add_like();
	}

}

if ( ! function_exists('highrise_mikado_like_portfolio_list') ) {
	/**
	 * Add like to portfolio project
	 *
	 * @param $portfolio_project_id
	 * @return string
	 */
	function highrise_mikado_like_portfolio_list($portfolio_project_id) {
		return highrise_mikado_like()->add_like_portfolio_list($portfolio_project_id);
	}

}