<?php

use Highrise\Modules\Header\Lib\HeaderFactory;

if (!function_exists('highrise_mikado_get_header')) {
    /**
     * Loads header HTML based on header type option. Sets all necessary parameters for header
     * and defines highrise_mikado_header_type_parameters filter
     */
    function highrise_mikado_get_header() {
        $id = highrise_mikado_get_page_id();

        //will be read from options
        $header_type = highrise_mikado_options()->getOptionValue('header_type');
        //$header_behavior = highrise_mikado_options()->getOptionValue('header_behaviour');
        $header_behavior = highrise_mikado_get_meta_field_intersect('header_behaviour', $id);

        extract(highrise_mikado_get_page_options());

        if (HeaderFactory::getInstance()->validHeaderObject()) {
            $parameters = array(
                'hide_logo' => highrise_mikado_options()->getOptionValue('hide_logo') == 'yes' ? true : false,
                'show_sticky' => in_array($header_behavior, array(
                    'sticky-header-on-scroll-up',
                    'sticky-header-on-scroll-down-up'
                )) ? true : false,
                'show_fixed_wrapper' => in_array($header_behavior, array('fixed-on-scroll')) ? true : false,
                'menu_area_background_color' => $menu_area_background_color,
                'vertical_header_background_color' => $vertical_header_background_color,
                'vertical_header_opacity' => $vertical_header_opacity,
                'vertical_background_image' => $vertical_background_image,
                'vertical_menu_style' => $vertical_menu_style,
                'vertical_menu_style_class' => $vertical_menu_style_class
            );

            $parameters = apply_filters('highrise_mikado_header_type_parameters', $parameters, $header_type);

            HeaderFactory::getInstance()->getHeaderObject()->loadTemplate($parameters);
        }
    }
}

if (!function_exists('highrise_mikado_get_header_top')) {
    /**
     * Loads header top HTML and sets parameters for it
     */
    function highrise_mikado_get_header_top() {

        //generate column width class
        switch (highrise_mikado_options()->getOptionValue('top_bar_layout')) {
            case ('two-columns'):
                $column_widht_class = 'mkd-' . highrise_mikado_options()->getOptionValue('top_bar_two_column_widths');
                break;
            case ('three-columns'):
                $column_widht_class = 'mkd-' . highrise_mikado_options()->getOptionValue('top_bar_column_widths');
                break;
        }

        $params = array(
            'column_widths' => $column_widht_class,
            'show_widget_center' => highrise_mikado_options()->getOptionValue('top_bar_layout') == 'three-columns' ? true : false,
            'show_header_top' => highrise_mikado_is_top_bar_enabled(),
            'show_header_top_background_div' => highrise_mikado_get_meta_field_intersect('header_type') == 'header-box' ? true : false,
            'top_bar_in_grid' => highrise_mikado_get_meta_field_intersect('top_bar_in_grid') == 'yes' ? true : false,
            'header_box_logo_area' => false
        );

        $params = apply_filters('highrise_mikado_header_top_params', $params);

        highrise_mikado_get_module_template_part('templates/parts/header-top', 'header', '', $params);
    }
}

if (!function_exists('highrise_mikado_get_logo')) {
    /**
     * Loads logo HTML
     *
     * @param $slug
     */
    function highrise_mikado_get_logo($slug = '') {
        $id = highrise_mikado_get_page_id();

        if ($slug == 'sticky') {
            $logo_image = highrise_mikado_get_meta_field_intersect('logo_image_sticky', $id);
        } else {
            $logo_image = highrise_mikado_get_meta_field_intersect('logo_image', $id);
        }

        $logo_image_dark = highrise_mikado_get_meta_field_intersect('logo_image_dark', $id);
        $logo_image_light = highrise_mikado_get_meta_field_intersect('logo_image_light', $id);


        //get logo image dimensions and set style attribute for image link.
        $logo_dimensions = highrise_mikado_get_image_dimensions($logo_image);

        $logo_styles = '';
        $logo_dimensions_attr = array();
        if (is_array($logo_dimensions) && array_key_exists('height', $logo_dimensions)) {
            $logo_height = $logo_dimensions['height'];
            $logo_styles = 'height: ' . intval($logo_height / 2) . 'px;'; //divided with 2 because of retina screens

            if (!empty($logo_dimensions['height']) && $logo_dimensions['width']) {
                $logo_dimensions_attr['height'] = $logo_dimensions['height'];
                $logo_dimensions_attr['width'] = $logo_dimensions['width'];
            }
        }

        $params = array(
            'logo_image' => $logo_image,
            'logo_image_dark' => $logo_image_dark,
            'logo_image_light' => $logo_image_light,
            'logo_styles' => $logo_styles,
            'logo_dimensions_attr' => $logo_dimensions_attr
        );

        highrise_mikado_get_module_template_part('templates/parts/logo', 'header', $slug, $params);
    }
}

if (!function_exists('highrise_mikado_get_main_menu')) {
    /**
     * Loads main menu HTML
     *
     * @param string $additional_class addition class to pass to template
     */
    function highrise_mikado_get_main_menu($additional_class = 'mkd-default-nav') {
        highrise_mikado_get_module_template_part('templates/parts/navigation', 'header', '', array('additional_class' => $additional_class));
    }
}

if (!function_exists('highrise_mikado_get_sticky_menu')) {
    /**
     * Loads sticky menu HTML
     *
     * @param string $additional_class addition class to pass to template
     */
    function highrise_mikado_get_sticky_menu($additional_class = 'mkd-default-nav') {
        highrise_mikado_get_module_template_part('templates/parts/sticky-navigation', 'header', '', array('additional_class' => $additional_class));
    }
}

if (!function_exists('highrise_mikado_get_divided_left_main_menu')) {
    /**
     * Loads main menu HTML
     *
     * @param string $additional_class addition class to pass to template
     */
    function highrise_mikado_get_divided_left_main_menu($additional_class = 'mkd-default-nav') {
        highrise_mikado_get_module_template_part('templates/parts/divided-left-navigation', 'header', '', array('additional_class' => $additional_class));
    }
}

if (!function_exists('highrise_mikado_get_sticky_divided_left_main_menu')) {
    /**
     * Loads main menu HTML
     *
     * @param string $additional_class addition class to pass to template
     */
    function highrise_mikado_get_sticky_divided_left_main_menu($additional_class = 'mkd-default-nav') {
        highrise_mikado_get_module_template_part('templates/parts/sticky-divided-left-navigation', 'header', '', array('additional_class' => $additional_class));
    }
}

if (!function_exists('highrise_mikado_get_divided_right_main_menu')) {
    /**
     * Loads main menu HTML
     *
     * @param string $additional_class addition class to pass to template
     */
    function highrise_mikado_get_divided_right_main_menu($additional_class = 'mkd-default-nav') {
        highrise_mikado_get_module_template_part('templates/parts/divided-right-navigation', 'header', '', array('additional_class' => $additional_class));
    }
}

if (!function_exists('highrise_mikado_get_sticky_divided_right_main_menu')) {
    /**
     * Loads main menu HTML
     *
     * @param string $additional_class addition class to pass to template
     */
    function highrise_mikado_get_sticky_divided_right_main_menu($additional_class = 'mkd-default-nav') {
        highrise_mikado_get_module_template_part('templates/parts/sticky-divided-right-navigation', 'header', '', array('additional_class' => $additional_class));
    }
}

if (!function_exists('highrise_mikado_get_vertical_main_menu')) {
    /**
     * Loads vertical menu HTML
     */
    function highrise_mikado_get_vertical_main_menu($slug = '') {
        highrise_mikado_get_module_template_part('templates/parts/vertical-navigation', 'header', $slug);
    }
}


if (!function_exists('highrise_mikado_get_sticky_header')) {
    /**
     * Loads sticky header behavior HTML
     */
    function highrise_mikado_get_sticky_header($slug = '') {

        $parameters = array(
            'hide_logo' => highrise_mikado_options()->getOptionValue('hide_logo') == 'yes' ? true : false,
            'sticky_header_in_grid' => highrise_mikado_options()->getOptionValue('sticky_header_in_grid') == 'yes' ? true : false
        );

        highrise_mikado_get_module_template_part('templates/behaviors/sticky-header', 'header', $slug, $parameters);
    }
}

if (!function_exists('highrise_mikado_get_mobile_header')) {
    /**
     * Loads mobile header HTML only if responsiveness is enabled
     */
    function highrise_mikado_get_mobile_header() {
        if (highrise_mikado_is_responsive_on()) {
            $header_type = highrise_mikado_options()->getOptionValue('header_type');

            //this could be read from theme options
            $mobile_header_type = 'mobile-header';

            $parameters = array(
                'show_logo' => highrise_mikado_options()->getOptionValue('hide_logo') == 'yes' ? false : true,
                'menu_opener_icon' => highrise_mikado_icon_collections()->getMobileMenuIcon(highrise_mikado_options()->getOptionValue('mobile_icon_pack'), true),
                'show_navigation_opener' => has_nav_menu('main-navigation')
            );

            highrise_mikado_get_module_template_part('templates/types/' . $mobile_header_type, 'header', $header_type, $parameters);
        }
    }
}

if (!function_exists('highrise_mikado_get_mobile_logo')) {
    /**
     * Loads mobile logo HTML. It checks if mobile logo image is set and uses that, else takes normal logo image
     *
     * @param string $slug
     */
    function highrise_mikado_get_mobile_logo($slug = '') {
        $id = highrise_mikado_get_page_id();

        //check if mobile logo has been set and use that, else use normal logo
        if (highrise_mikado_get_meta_field_intersect('logo_image_mobile', $id)) {
            $logo_image = highrise_mikado_get_meta_field_intersect('logo_image_mobile', $id);
        } else {
            $logo_image = highrise_mikado_get_meta_field_intersect('logo_image', $id);
        }

        //get logo image dimensions and set style attribute for image link.
        $logo_dimensions = highrise_mikado_get_image_dimensions($logo_image);

        $logo_height = '';
        $logo_styles = '';
        $logo_dimensions_attr = array();
        if (is_array($logo_dimensions) && array_key_exists('height', $logo_dimensions)) {
            $logo_height = $logo_dimensions['height'];
            $logo_styles = 'height: ' . intval($logo_height / 2) . 'px'; //divided with 2 because of retina screens

            if (!empty($logo_dimensions['height']) && $logo_dimensions['width']) {
                $logo_dimensions_attr['height'] = $logo_dimensions['height'];
                $logo_dimensions_attr['width'] = $logo_dimensions['width'];
            }
        }

        //set parameters for logo
        $parameters = array(
            'logo_image' => $logo_image,
            'logo_dimensions' => $logo_dimensions,
            'logo_height' => $logo_height,
            'logo_styles' => $logo_styles,
            'logo_dimensions_attr' => $logo_dimensions_attr
        );

        highrise_mikado_get_module_template_part('templates/parts/mobile-logo', 'header', $slug, $parameters);
    }
}

if (!function_exists('highrise_mikado_get_mobile_nav')) {
    /**
     * Loads mobile navigation HTML
     */
    function highrise_mikado_get_mobile_nav() {

        $slug = highrise_mikado_options()->getOptionValue('header_type');

        highrise_mikado_get_module_template_part('templates/parts/mobile-navigation', 'header', $slug);
    }
}

if (!function_exists('highrise_mikado_get_page_options')) {
    /**
     * Gets options from page
     */
    function highrise_mikado_get_page_options() {
        $id = highrise_mikado_get_page_id();
        $page_options = array();
        $menu_area_background_color_rgba = '';
        $menu_area_background_color = '';
        $menu_area_background_transparency = '';
        $vertical_header_background_color = '';
        $vertical_header_opacity = '';
        $vertical_background_image = '';
        $vertical_menu_style = '';
        $vertical_menu_style_class = '';

        $header_type = highrise_mikado_get_meta_field_intersect('header_type', $id);
        switch ($header_type) {
            case 'header-standard':

                if (($meta_temp = get_post_meta($id, 'mkd_menu_area_background_color_header_standard_meta', true)) != '') {
                    $menu_area_background_color = $meta_temp;
                }

                if (($meta_temp = get_post_meta($id, 'mkd_menu_area_background_transparency_header_standard_meta', true)) != '') {
                    $menu_area_background_transparency = $meta_temp;
                }

                if (highrise_mikado_rgba_color($menu_area_background_color, $menu_area_background_transparency) !== null) {
                    $menu_area_background_color_rgba = 'background-color:' . highrise_mikado_rgba_color($menu_area_background_color, $menu_area_background_transparency);
                }

                break;

            case 'header-vertical':
                if (($meta_temp = get_post_meta($id, 'mkd_vertical_header_background_color_meta', true)) !== '') {
                    $vertical_header_background_color = 'background-color:' . $meta_temp;
                }

                if (($meta_temp = get_post_meta($id, 'mkd_vertical_header_transparency_meta', true)) !== '') {
                    $vertical_header_opacity = 'opacity:' . $meta_temp;
                }

                if (get_post_meta($id, 'mkd_disable_vertical_header_background_image_meta', true) == 'yes') {
                    $vertical_background_image = 'background-image:none';
                } elseif (($meta_temp = get_post_meta($id, 'mkd_vertical_header_background_image_meta', true)) !== '') {
                    $vertical_background_image = 'background-image:url(' . $meta_temp . ')';
                }

                if (highrise_mikado_get_meta_field_intersect('vertical_header_main_menu') !== '') {
                    $vertical_menu_style_class = 'mkd-vertical-dropdown-' . highrise_mikado_get_meta_field_intersect('vertical_header_main_menu');
                    $vertical_menu_style = highrise_mikado_get_meta_field_intersect('vertical_header_main_menu');
                }

                break;
        }

        $page_options['menu_area_background_color'] = $menu_area_background_color_rgba;
        $page_options['vertical_header_background_color'] = $vertical_header_background_color;
        $page_options['vertical_header_opacity'] = $vertical_header_opacity;
        $page_options['vertical_background_image'] = $vertical_background_image;
        $page_options['vertical_menu_style_class'] = $vertical_menu_style_class;
        $page_options['vertical_menu_style'] = $vertical_menu_style;

        return $page_options;
    }
}