<?php

if (!function_exists('highrise_mikado_content_options_map')) {

    function highrise_mikado_content_options_map() {

        highrise_mikado_add_admin_page(
            array(
                'slug' => '_content_page',
                'title' => esc_html__('Content','highrise'),
                'icon' => 'fa fa-institution'
            )
        );

        $panel_content = highrise_mikado_add_admin_panel(
            array(
                'page' => '_content_page',
                'name' => 'panel_content',
                'title' => esc_html__('General','highrise')
            )
        );

        highrise_mikado_add_admin_field(array(
            'type' => 'text',
            'name' => 'content_top_padding',
            'description' => esc_html__('Enter top padding for content area for templates in full width. If you set this value then it\'s important to set also Content top padding for mobile header value','highrise'),
            'default_value' => '66',
            'label' => esc_html__('Content Top Padding for Template in Full Width','highrise'),
            'args' => array(
                'suffix' => 'px',
                'col_width' => 3
            ),
            'parent' => $panel_content
        ));

        highrise_mikado_add_admin_field(array(
            'type' => 'text',
            'name' => 'content_top_padding_in_grid',
            'description' => esc_html__('Enter top padding for content area for Templates in grid. If you set this value then it\'s important to set also Content top padding for mobile header value','highrise'),
            'default_value' => '66',
            'label' => esc_html__('Content Top Padding for Templates in Grid','highrise'),
            'args' => array(
                'suffix' => 'px',
                'col_width' => 3
            ),
            'parent' => $panel_content
        ));

        highrise_mikado_add_admin_field(array(
            'type' => 'text',
            'name' => 'content_top_padding_mobile',
            'description' => esc_html__('Enter top padding for content area for Mobile Header','highrise'),
            'default_value' => '',
            'label' => esc_html__('Content Top Padding for Mobile Header','highrise'),
            'args' => array(
                'suffix' => 'px',
                'col_width' => 3
            ),
            'parent' => $panel_content
        ));

    }

    add_action('highrise_mikado_options_map', 'highrise_mikado_content_options_map', 8);

}