<?php

if (!function_exists('highrise_mikado_content_styles')) {
    /**
     * Generates content custom styles
     */
    function highrise_mikado_content_styles() {

        $content_style = array();
        if (highrise_mikado_options()->getOptionValue('content_top_padding') !== '') {
            $padding_top = (highrise_mikado_options()->getOptionValue('content_top_padding'));
            $content_style['padding-top'] = highrise_mikado_filter_px($padding_top) . 'px';
        }

        $content_selector = array(
            '.mkd-content .mkd-content-inner > .mkd-full-width > .mkd-full-width-inner',
        );

        echo highrise_mikado_dynamic_css($content_selector, $content_style);

        $content_style_in_grid = array();
        if (highrise_mikado_options()->getOptionValue('content_top_padding_in_grid') !== '') {
            $padding_top_in_grid = (highrise_mikado_options()->getOptionValue('content_top_padding_in_grid'));
            $content_style_in_grid['padding-top'] = highrise_mikado_filter_px($padding_top_in_grid) . 'px';

        }

        $content_selector_in_grid = array(
            '.mkd-content .mkd-content-inner > .mkd-container > .mkd-container-inner',
        );

        echo highrise_mikado_dynamic_css($content_selector_in_grid, $content_style_in_grid);

    }

    add_action('highrise_mikado_style_dynamic', 'highrise_mikado_content_styles');
}