<?php

if (!function_exists('highrise_mikado_sidebar_options_map')) {

    function highrise_mikado_sidebar_options_map() {

        highrise_mikado_add_admin_page(
            array(
                'slug' => '_sidebar_page',
                'title' => esc_html__('Sidebar','highrise'),
                'icon' => 'fa fa-bars'
            )
        );

        $panel_widgets = highrise_mikado_add_admin_panel(
            array(
                'page' => '_sidebar_page',
                'name' => 'panel_widgets',
                'title' => esc_html__('Widgets','highrise')
            )
        );

        /**
         * Navigation style
         */

        highrise_mikado_add_admin_field(array(
            'name' => 'sidebar_widget_separator',
            'type' => 'yesno',
            'label' => esc_html__('Show Separator', 'highrise'),
            'description' => esc_html__('Enabling this option will show separator below title on widgets in sidebar.', 'highrise'),
            'parent' => $panel_widgets,
            'default_value' => 'yes'
        ));

        highrise_mikado_add_admin_field(array(
            'type' => 'color',
            'name' => 'sidebar_background_color',
            'default_value' => '',
            'label' => esc_html__('Sidebar Background Color','highrise'),
            'description' => esc_html__('Choose background color for sidebar','highrise'),
            'parent' => $panel_widgets
        ));

        $group_sidebar_padding = highrise_mikado_add_admin_group(array(
            'name' => 'group_sidebar_padding',
            'title' => esc_html__('Padding','highrise'),
            'parent' => $panel_widgets
        ));

        $row_sidebar_padding = highrise_mikado_add_admin_row(array(
            'name' => 'row_sidebar_padding',
            'parent' => $group_sidebar_padding
        ));

        highrise_mikado_add_admin_field(array(
            'type' => 'textsimple',
            'name' => 'sidebar_padding_top',
            'default_value' => '',
            'label' => esc_html__('Top Padding','highrise'),
            'args' => array(
                'suffix' => 'px'
            ),
            'parent' => $row_sidebar_padding
        ));

        highrise_mikado_add_admin_field(array(
            'type' => 'textsimple',
            'name' => 'sidebar_padding_right',
            'default_value' => '',
            'label' => esc_html__('Right Padding','highrise'),
            'args' => array(
                'suffix' => 'px'
            ),
            'parent' => $row_sidebar_padding
        ));

        highrise_mikado_add_admin_field(array(
            'type' => 'textsimple',
            'name' => 'sidebar_padding_bottom',
            'default_value' => '',
            'label' =>esc_html__( 'Bottom Padding','highrise'),
            'args' => array(
                'suffix' => 'px'
            ),
            'parent' => $row_sidebar_padding
        ));

        highrise_mikado_add_admin_field(array(
            'type' => 'textsimple',
            'name' => 'sidebar_padding_left',
            'default_value' => '',
            'label' =>esc_html__( 'Left Padding','highrise'),
            'args' => array(
                'suffix' => 'px'
            ),
            'parent' => $row_sidebar_padding
        ));

        highrise_mikado_add_admin_field(array(
            'type' => 'select',
            'name' => 'sidebar_alignment',
            'default_value' => '',
            'label' => esc_html__('Text Alignment','highrise'),
            'description' => esc_html__('Choose text aligment','highrise'),
            'options' => array(
                'left' => esc_html__('Left','highrise'),
                'center' => esc_html__('Center','highrise'),
                'right' => esc_html__('Right','highrise')
            ),
            'parent' => $panel_widgets
        ));

    }

    add_action('highrise_mikado_options_map', 'highrise_mikado_sidebar_options_map');

}