<?php

if ( ! function_exists('highrise_mikado_reset_options_map') ) {
	/**
	 * Reset options panel
	 */
	function highrise_mikado_reset_options_map() {

		highrise_mikado_add_admin_page(
			array(

				'slug'  => '_reset_page',
				'title' => esc_html__('Reset','highrise'),
				'icon'  => 'fa fa-retweet'
			)
		);

		$panel_reset = highrise_mikado_add_admin_panel(
			array(
				'page'  => '_reset_page',
				'name'  => 'panel_reset',
				'title' =>esc_html__( 'Reset','highrise')
			)
		);

		highrise_mikado_add_admin_field(array(
			'type'	=> 'yesno',
			'name'	=> 'reset_to_defaults',
			'default_value'	=> 'no',
			'label'			=>esc_html__( 'Reset to Defaults','highrise'),
			'description'	=> esc_html__('This option will reset all Select Options values to defaults','highrise'),
			'parent'		=> $panel_reset
		));

	}

	add_action( 'highrise_mikado_options_map', 'highrise_mikado_reset_options_map', 100 );

}