<?php

if (!function_exists('highrise_mikado_page_options_map')) {

    function highrise_mikado_page_options_map() {

        highrise_mikado_add_admin_page(
            array(
                'slug' => '_page_page',
                'title' => esc_html__('Page', 'highrise'),
                'icon' => 'fa fa-institution'
            )
        );

        $custom_sidebars = highrise_mikado_get_custom_sidebars();

        $panel_sidebar = highrise_mikado_add_admin_panel(
            array(
                'page' => '_page_page',
                'name' => 'panel_sidebar',
                'title' => esc_html__('Design Style', 'highrise')
            )
        );

        highrise_mikado_add_admin_field(array(
            'name' => 'page_sidebar_layout',
            'type' => 'select',
            'label' => esc_html__('Sidebar Layout', 'highrise'),
            'description' => esc_html__('Choose a sidebar layout for pages', 'highrise'),
            'default_value' => 'default',
            'parent' => $panel_sidebar,
            'options' => array(
                'default' => esc_html__('No Sidebar', 'highrise'),
                'sidebar-33-right' => esc_html__('Sidebar 1/3 Right', 'highrise'),
                'sidebar-25-right' => esc_html__('Sidebar 1/4 Right', 'highrise'),
                'sidebar-33-left' => esc_html__('Sidebar 1/3 Left', 'highrise'),
                'sidebar-25-left' => esc_html__('Sidebar 1/4 Left', 'highrise')
            )
        ));


        if (count($custom_sidebars) > 0) {
            highrise_mikado_add_admin_field(array(
                'name' => 'page_custom_sidebar',
                'type' => 'selectblank',
                'label' => esc_html__('Sidebar to Display', 'highrise'),
                'description' => esc_html__('Choose a sidebar to display on pages. Default sidebar is "Sidebar"', 'highrise'),
                'parent' => $panel_sidebar,
                'options' => $custom_sidebars,
                'args' => array(
                    'select2' => true
                )
            ));
        }

        highrise_mikado_add_admin_field(array(
            'name' => 'page_show_comments',
            'type' => 'yesno',
            'label' => esc_html__('Show Comments', 'highrise'),
            'description' => esc_html__('Enabling this option will show comments on your page', 'highrise'),
            'default_value' => 'yes',
            'parent' => $panel_sidebar
        ));

    }

    add_action('highrise_mikado_options_map', 'highrise_mikado_page_options_map', 7);

}