<?php

if (!function_exists('highrise_mikado_error_404_options_map')) {

    function highrise_mikado_error_404_options_map() {

        highrise_mikado_add_admin_page(array(
            'slug' => '__404_error_page',
            'title' => esc_html__('404 Error Page', 'highrise'),
            'icon' => 'fa fa-exclamation-triangle'
        ));

        $panel_404_options = highrise_mikado_add_admin_panel(array(
            'page' => '__404_error_page',
            'name' => 'panel_404_options',
            'title' => esc_html__('404 Page Option', 'highrise')
        ));

        highrise_mikado_add_admin_field(array(
            'name' => '404_image',
            'type' => 'image',
            'default_value' => '',
            'label' => esc_html__('Image', 'highrise'),
            'description' => esc_html__('Set image for 404 page', 'highrise'),
            'parent' => $panel_404_options
        ));

        highrise_mikado_add_admin_field(array(
            'parent' => $panel_404_options,
            'type' => 'text',
            'name' => '404_title',
            'default_value' => '',
            'label' => esc_html__('Title', 'highrise'),
            'description' => esc_html__('Enter title for 404 page', 'highrise')
        ));

        highrise_mikado_add_admin_field(array(
            'parent' => $panel_404_options,
            'type' => 'text',
            'name' => '404_text',
            'default_value' => '',
            'label' => esc_html__('Text', 'highrise'),
            'description' => esc_html__('Enter text for 404 page', 'highrise')
        ));

        highrise_mikado_add_admin_field(array(
            'parent' => $panel_404_options,
            'type' => 'text',
            'name' => '404_back_to_home',
            'default_value' => '',
            'label' => esc_html__('Back to Home Button Label', 'highrise'),
            'description' => esc_html__('Enter label for "Back to Home" button', 'highrise')
        ));

    }

    add_action('highrise_mikado_options_map', 'highrise_mikado_error_404_options_map', 15);

}