<?php

$title_meta_box = highrise_mikado_add_meta_box(
    array(
        'scope' => array('page', 'portfolio-item', 'post'),
        'title' =>esc_html__( 'Title','highrise'),
        'name' => 'title_meta'
    )
);

    highrise_mikado_add_meta_box_field(
        array(
            'name' => 'mkd_show_title_area_meta',
            'type' => 'select',
            'default_value' => '',
            'label' => esc_html__('Show Title Area','highrise'),
            'description' => esc_html__('Disabling this option will turn off page title area','highrise'),
            'parent' => $title_meta_box,
            'options' => array(
                '' => '',
                'no' =>esc_html__( 'No','highrise'),
                'yes' =>esc_html__( 'Yes','highrise')
            ),
            'args' => array(
                "dependence" => true,
                "hide" => array(
                    "" => "",
                    "no" => "#mkd_mkd_show_title_area_meta_container",
                    "yes" => ""
                ),
                "show" => array(
                    "" => "#mkd_mkd_show_title_area_meta_container",
                    "no" => "",
                    "yes" => "#mkd_mkd_show_title_area_meta_container"
                )
            )
        )
    );

    $show_title_area_meta_container = highrise_mikado_add_admin_container(
        array(
            'parent' => $title_meta_box,
            'name' => 'mkd_show_title_area_meta_container',
            'hidden_property' => 'mkd_show_title_area_meta',
            'hidden_value' => 'no'
        )
    );

        highrise_mikado_add_meta_box_field(
            array(
                'name' => 'mkd_title_area_type_meta',
                'type' => 'select',
                'default_value' => '',
                'label' => esc_html__('Title Area Type','highrise'),
                'description' => esc_html__('Choose title type','highrise'),
                'parent' => $show_title_area_meta_container,
                'options' => array(
                    '' => '',
                    'standard' => esc_html__('Standard','highrise'),
                    'breadcrumb' => esc_html__('Breadcrumb','highrise')
                ),
                'args' => array(
                    "dependence" => true,
                    "hide" => array(
                        "standard" => "",
                        "breadcrumb" => "#mkd_mkd_title_area_type_meta_container"
                    ),
                    "show" => array(
                        "" => "#mkd_mkd_title_area_type_meta_container",
                        "standard" => "#mkd_mkd_title_area_type_meta_container",
                        "breadcrumb" => ""
                    )
                )
            )
        );

        $title_area_type_meta_container = highrise_mikado_add_admin_container(
            array(
                'parent' => $show_title_area_meta_container,
                'name' => 'mkd_title_area_type_meta_container',
                'hidden_property' => 'mkd_title_area_type_meta',
                'hidden_value' => '',
                'hidden_values' => array('breadcrumb'),
            )
        );

            highrise_mikado_add_meta_box_field(
                array(
                    'name' => 'mkd_title_area_enable_breadcrumbs_meta',
                    'type' => 'select',
                    'default_value' => '',
                    'label' =>esc_html__( 'Enable Breadcrumbs','highrise'),
                    'description' => esc_html__('This option will display Breadcrumbs in Title Area','highrise'),
                    'parent' => $title_area_type_meta_container,
                    'options' => array(
                        '' => '',
                        'no'  => esc_html__('No','highrise'),
                        'yes' => esc_html__( 'Yes','highrise')
                    ),
                )
            );

            highrise_mikado_add_meta_box_field(
                array(
                    'name' => 'mkd_title_area_separator_meta',
                    'type' => 'select',
                    'default_value' => '',
                    'label' =>esc_html__( 'Enable Separator','highrise'),
                    'description' => esc_html__('This option will display Separator in Title Area','highrise'),
                    'parent' => $title_area_type_meta_container,
                    'options' => array(
                        '' => '',
                        'no'  => esc_html__('No','highrise'),
                        'yes' => esc_html__('Yes','highrise')
                    ),
                )
            );

            highrise_mikado_add_meta_box_field(array(
                'type'			=> 'text',
                'name'			=> 'mkd_title_area_width_meta',
                'default_value'	=> '',
                'label'			=> esc_html__('Width','highrise'),
                'description'   => esc_html__('This option will set maximum content width in Title Area ("px" or "%")','highrise'),
                'parent'		=> $title_area_type_meta_container,
                'args' => array(
                    'col_width' => 3,
                )
            ));

            $group_page_title_styles = highrise_mikado_add_admin_group(array(
                'name'			=> 'group_page_title_styles',
                'title'			=> esc_html__('Title','highrise'),
                'description'	=> esc_html__('Define styles for page title','highrise'),
                'parent'		=> $title_area_type_meta_container
            ));

                $row_page_title_styles_1 = highrise_mikado_add_admin_row(array(
                    'name'		=> 'row_page_title_styles_1',
                    'parent'	=> $group_page_title_styles
                ));

                    highrise_mikado_add_meta_box_field(array(
                        'type'			=> 'colorsimple',
                        'name'			=> 'mkd_page_title_color_meta',
                        'default_value'	=> '',
                        'label'			=> esc_html__( 'Text Color','highrise'),
                        'parent'		=> $row_page_title_styles_1
                    ));

                    highrise_mikado_add_meta_box_field(array(
                        'type'			=> 'textsimple',
                        'name'			=> 'mkd_page_title_fontsize_meta',
                        'default_value'	=> '',
                        'label'			=> esc_html__( 'Font Size','highrise'),
                        'args'			=> array(
                            'suffix'	=> 'px'
                        ),
                        'parent'		=> $row_page_title_styles_1
                    ));

                    highrise_mikado_add_meta_box_field(array(
                        'type'			=> 'textsimple',
                        'name'			=> 'mkd_page_title_lineheight_meta',
                        'default_value'	=> '',
                        'label'			=> esc_html__( 'Line Height','highrise'),
                        'args'			=> array(
                            'suffix'	=> 'px'
                        ),
                        'parent'		=> $row_page_title_styles_1
                    ));

                    highrise_mikado_add_meta_box_field(array(
                        'type'			=> 'selectblanksimple',
                        'name'			=> 'mkd_page_title_texttransform_meta',
                        'default_value'	=> '',
                        'label'			=> esc_html__('Text Transform','highrise'),
                        'options'		=> highrise_mikado_get_text_transform_array(),
                        'parent'		=> $row_page_title_styles_1
                    ));

                $row_page_title_styles_2 = highrise_mikado_add_admin_row(array(
                    'name'		=> 'row_page_title_styles_2',
                    'parent'	=> $group_page_title_styles,
                    'next'		=> true
                ));

                    highrise_mikado_add_meta_box_field(array(
                        'type'			=> 'selectblanksimple',
                        'name'			=> 'mkd_page_title_fontstyle_meta',
                        'default_value'	=> '',
                        'label'			=> esc_html__('Font Style','highrise'),
                        'options'		=> highrise_mikado_get_font_style_array(),
                        'parent'		=> $row_page_title_styles_2
                    ));

                    highrise_mikado_add_meta_box_field(array(
                        'type'			=> 'selectblanksimple',
                        'name'			=> 'mkd_page_title_fontweight_meta',
                        'default_value'	=> '',
                        'label'			=> esc_html__( 'Font Weight','highrise'),
                        'options'		=> highrise_mikado_get_font_weight_array(),
                        'parent'		=> $row_page_title_styles_2
                    ));

                    highrise_mikado_add_meta_box_field(array(
                        'type'			=> 'textsimple',
                        'name'			=> 'mkd_page_title_letter_spacing_meta',
                        'default_value'	=> '',
                        'label'			=> esc_html__('Letter Spacing','highrise'),
                        'args'			=> array(
                            'suffix'	=> 'px'
                        ),
                        'parent'		=> $row_page_title_styles_2
                    ));

                    highrise_mikado_add_meta_box_field(array(
                        'type'			=> 'textsimple',
                        'name'			=> 'mkd_page_title_margin_bottom_meta',
                        'default_value'	=> '',
                        'label'			=> esc_html__('Margin Bottom','highrise'),
                        'args'			=> array(
                            'suffix'	=> 'px'
                        ),
                        'parent'		=> $row_page_title_styles_2
                    ));

        highrise_mikado_add_meta_box_field(
            array(
                'name' => 'mkd_title_area_animation_meta',
                'type' => 'select',
                'default_value' => '',
                'label' =>esc_html__( 'Animations','highrise'),
                'description' =>esc_html__( 'Choose an animation for Title Area','highrise'),
                'parent' => $show_title_area_meta_container,
                'options' => array(
                    '' => '',
                    'no' => esc_html__('No Animation','highrise'),
                    'right-left' =>esc_html__( 'Text right to left','highrise'),
                    'left-right' =>esc_html__( 'Text left to right','highrise')
                )
            )
        );

        highrise_mikado_add_meta_box_field(
            array(
                'name' => 'mkd_title_area_vertial_alignment_meta',
                'type' => 'select',
                'default_value' => '',
                'label' => esc_html__('Vertical Alignment','highrise'),
                'description' =>esc_html__( 'Specify title vertical alignment','highrise'),
                'parent' => $show_title_area_meta_container,
                'options' => array(
                    '' => '',
                    'header_bottom' =>esc_html__( 'From Bottom of Header','highrise'),
                    'window_top' =>esc_html__( 'From Window Top','highrise')
                )
            )
        );

        highrise_mikado_add_meta_box_field(
            array(
                'name' => 'mkd_title_area_content_alignment_meta',
                'type' => 'select',
                'default_value' => '',
                'label' =>esc_html__( 'Horizontal Alignment','highrise'),
                'description' =>esc_html__( 'Specify title horizontal alignment','highrise'),
                'parent' => $show_title_area_meta_container,
                'options' => array(
                    '' => '',
                    'left' =>esc_html__( 'Left','highrise'),
                    'center' =>esc_html__( 'Center','highrise'),
                    'right' => esc_html__('Right','highrise')
                )
            )
        );

        highrise_mikado_add_meta_box_field(
            array(
                'name' => 'mkd_title_breadcrumb_color_meta',
                'type' => 'color',
                'label' =>esc_html__( 'Breadcrumb Color','highrise'),
                'description' =>esc_html__( 'Choose a color for breadcrumb text','highrise'),
                'parent' => $show_title_area_meta_container
            )
        );

        highrise_mikado_add_meta_box_field(
            array(
                'name' => 'mkd_title_area_background_color_meta',
                'type' => 'color',
                'label' => esc_html__('Background Color','highrise'),
                'description' =>esc_html__( 'Choose a background color for Title Area','highrise'),
                'parent' => $show_title_area_meta_container
            )
        );

        highrise_mikado_add_meta_box_field(
            array(
                'name' => 'mkd_hide_background_image_meta',
                'type' => 'yesno',
                'default_value' => 'no',
                'label' =>esc_html__( 'Hide Background Image','highrise'),
                'description' =>esc_html__( 'Enable this option to hide background image in Title Area','highrise'),
                'parent' => $show_title_area_meta_container,
                'args' => array(
                    "dependence" => true,
                    "dependence_hide_on_yes" => "#mkd_mkd_hide_background_image_meta_container",
                    "dependence_show_on_yes" => ""
                )
            )
        );

        $hide_background_image_meta_container = highrise_mikado_add_admin_container(
            array(
                'parent' => $show_title_area_meta_container,
                'name' => 'mkd_hide_background_image_meta_container',
                'hidden_property' => 'mkd_hide_background_image_meta',
                'hidden_value' => 'yes'
            )
        );

        highrise_mikado_add_meta_box_field(
            array(
                'name' => 'mkd_title_area_background_image_meta',
                'type' => 'image',
                'label' =>esc_html__( 'Background Image','highrise'),
                'description' =>esc_html__( 'Choose an Image for Title Area','highrise'),
                'parent' => $hide_background_image_meta_container
            )
        );

        highrise_mikado_add_meta_box_field(
            array(
                'name' => 'mkd_title_area_background_image_responsive_meta',
                'type' => 'select',
                'default_value' => '',
                'label' =>esc_html__( 'Background Responsive Image','highrise'),
                'description' => esc_html__('Enabling this option will make Title background image responsive','highrise'),
                'parent' => $hide_background_image_meta_container,
                'options' => array(
                    '' => '',
                    'no' => esc_html__('No','highrise'),
                    'yes' =>esc_html__( 'Yes','highrise')
                ),
                'args' => array(
                    "dependence" => true,
                    "hide" => array(
                        "" => "",
                        "no" => "",
                        "yes" => "#mkd_mkd_title_area_background_image_responsive_meta_container, #mkd_mkd_title_area_height_meta"
                    ),
                    "show" => array(
                        "" => "#mkd_mkd_title_area_background_image_responsive_meta_container, #mkd_mkd_title_area_height_meta",
                        "no" => "#mkd_mkd_title_area_background_image_responsive_meta_container, #mkd_mkd_title_area_height_meta",
                        "yes" => ""
                    )
                )
            )
        );

        $title_area_background_image_responsive_meta_container = highrise_mikado_add_admin_container(
            array(
                'parent' => $hide_background_image_meta_container,
                'name' => 'mkd_title_area_background_image_responsive_meta_container',
                'hidden_property' => 'mkd_title_area_background_image_responsive_meta',
                'hidden_value' => 'yes'
            )
        );

            highrise_mikado_add_meta_box_field(
                array(
                    'name' => 'mkd_title_area_background_image_parallax_meta',
                    'type' => 'select',
                    'default_value' => '',
                    'label' => esc_html__('Background Image in Parallax','highrise'),
                    'description' =>esc_html__( 'Enabling this option will make Title background image parallax','highrise'),
                    'parent' => $title_area_background_image_responsive_meta_container,
                    'options' => array(
                        '' => '',
                        'no' => esc_html__('No','highrise'),
                        'yes' => esc_html__('Yes','highrise'),
                        'yes_zoom' =>esc_html__( 'Yes, with zoom out','highrise')
                    )
                )
            );

        highrise_mikado_add_meta_box_field(array(
            'name' => 'mkd_title_area_height_meta',
            'type' => 'text',
            'label' =>esc_html__( 'Height','highrise'),
            'description' => esc_html__('Set a height for Title Area','highrise'),
            'parent' => $show_title_area_meta_container,
            'args' => array(
                'col_width' => 2,
                'suffix' => 'px'
            )
        ));

        highrise_mikado_add_meta_box_field(array(
            'name' => 'mkd_title_area_subtitle_meta',
            'type' => 'text',
            'default_value' => '',
            'label' => esc_html__('Subtitle Text','highrise'),
            'description' =>esc_html__( 'Enter your subtitle text','highrise'),
            'parent' => $show_title_area_meta_container,
            'args' => array(
                'col_width' => 6
            )
        ));

        highrise_mikado_add_meta_box_field(
            array(
                'name' => 'mkd_subtitle_color_meta',
                'type' => 'color',
                'label' => esc_html__('Subtitle Color','highrise'),
                'description' =>esc_html__( 'Choose a color for subtitle text','highrise'),
                'parent' => $show_title_area_meta_container
            )
        );