<?php

if (!function_exists('highrise_mikado_map_portfolio_settings')) {
    function highrise_mikado_map_portfolio_settings() {
        $meta_box = highrise_mikado_add_meta_box(array(
            'scope' => 'portfolio-item',
            'title' => esc_html__('Portfolio Settings', 'highrise'),
            'name' => 'portfolio_settings_meta_box'
        ));

        highrise_mikado_add_meta_box_field(array(
            'name' => 'mkd_portfolio_single_template_meta',
            'type' => 'select',
            'label' => esc_html__('Portfolio Type', 'highrise'),
            'description' => esc_html__('Choose a default type for Single Project pages', 'highrise'),
            'parent' => $meta_box,
            'options' => array(
                '' => esc_html__('Default', 'highrise'),
                'huge-images' => esc_html__('Portfolio Full Width Images', 'highrise'),
                'images' => esc_html__('Portfolio Images', 'highrise'),
                'small-images' => esc_html__('Portfolio Small Images', 'highrise'),
                'slider' => esc_html__('Portfolio Slider', 'highrise'),
                'small-slider' => esc_html__('Portfolio Small Slider', 'highrise'),
                'gallery' => esc_html__('Portfolio Gallery', 'highrise'),
                'small-gallery' => esc_html__('Portfolio Small Gallery', 'highrise'),
                'masonry' => esc_html__('Portfolio Masonry', 'highrise'),
                'small-masonry' => esc_html__('Portfolio Small Masonry', 'highrise'),
                'custom' => esc_html__('Portfolio Custom', 'highrise'),
                'full-width-custom' => esc_html__('Portfolio Full Width Custom', 'highrise')
            ),
            'args' => array(
                'dependence' => true,
                'show' => array(
                    '' => '',
                    'huge-images' => '',
                    'images' => '',
                    'small-images' => '',
                    'slider' => '',
                    'small-slider' => '',
                    'gallery' => '#mkd_mkd_gallery_type_meta_container',
                    'small-gallery' => '#mkd_mkd_gallery_type_meta_container',
                    'masonry' => '#mkd_mkd_masonry_type_meta_container',
                    'small-masonry' => '#mkd_mkd_masonry_type_meta_container',
                    'custom' => '',
                    'full-width-custom' => ''
                ),
                'hide' => array(
                    '' => '#mkd_mkd_gallery_type_meta_container, #mkd_mkd_masonry_type_meta_container',
                    'huge-images' => '#mkd_mkd_gallery_type_meta_container, #mkd_mkd_masonry_type_meta_container',
                    'images' => '#mkd_mkd_gallery_type_meta_container, #mkd_mkd_masonry_type_meta_container',
                    'small-images' => '#mkd_mkd_gallery_type_meta_container, #mkd_mkd_masonry_type_meta_container',
                    'slider' => '#mkd_mkd_gallery_type_meta_container, #mkd_mkd_masonry_type_meta_container',
                    'small-slider' => '#mkd_mkd_gallery_type_meta_container, #mkd_mkd_masonry_type_meta_container',
                    'gallery' => '#mkd_mkd_masonry_type_meta_container',
                    'small-gallery' => '#mkd_mkd_masonry_type_meta_container',
                    'masonry' => '#mkd_mkd_gallery_type_meta_container',
                    'small-masonry' => '#mkd_mkd_gallery_type_meta_container',
                    'custom' => '#mkd_mkd_gallery_type_meta_container, #mkd_mkd_masonry_type_meta_container',
                    'full-width-custom' => '#mkd_mkd_gallery_type_meta_container, #mkd_mkd_masonry_type_meta_container'
                )
            )
        ));

        /***************** Gallery Layout *****************/

        $gallery_type_meta_container = highrise_mikado_add_admin_container(
            array(
                'parent' => $meta_box,
                'name' => 'mkd_gallery_type_meta_container',
                'hidden_property' => 'mkd_portfolio_single_template_meta',
                'hidden_values' => array(
                    'huge-images',
                    'images',
                    'small-images',
                    'slider',
                    'small-slider',
                    'masonry',
                    'small-masonry',
                    'custom',
                    'full-width-custom'
                )
            )
        );

        highrise_mikado_add_meta_box_field(array(
            'name' => 'mkd_portfolio_single_gallery_columns_number_meta',
            'type' => 'select',
            'label' => esc_html__('Number of Columns', 'highrise'),
            'default_value' => '',
            'description' => esc_html__('Set number of columns for portfolio gallery type', 'highrise'),
            'parent' => $gallery_type_meta_container,
            'options' => array(
                '' => esc_html__('Default', 'highrise'),
                'two' => esc_html__('2 Columns', 'highrise'),
                'three' => esc_html__('3 Columns', 'highrise'),
                'four' => esc_html__('4 Columns', 'highrise')
            )
        ));

        highrise_mikado_add_meta_box_field(array(
            'name' => 'mkd_portfolio_single_gallery_space_between_items_meta',
            'type' => 'select',
            'label' => esc_html__('Space Between Items', 'highrise'),
            'default_value' => '',
            'description' => esc_html__('Set space size between columns for portfolio gallery type', 'highrise'),
            'parent' => $gallery_type_meta_container,
            'options' => array(
                '' => esc_html__('Default', 'highrise'),
                'normal' => esc_html__('Normal', 'highrise'),
                'small' => esc_html__('Small', 'highrise'),
                'tiny' => esc_html__('Tiny', 'highrise'),
                'no' => esc_html__('No Space', 'highrise')
            )
        ));

        /***************** Gallery Layout *****************/

        /***************** Masonry Layout *****************/

        $masonry_type_meta_container = highrise_mikado_add_admin_container(
            array(
                'parent' => $meta_box,
                'name' => 'mkd_masonry_type_meta_container',
                'hidden_property' => 'mkd_portfolio_single_template_meta',
                'hidden_values' => array(
                    'huge-images',
                    'images',
                    'small-images',
                    'slider',
                    'small-slider',
                    'gallery',
                    'small-gallery',
                    'custom',
                    'full-width-custom'
                )
            )
        );

        highrise_mikado_add_meta_box_field(array(
            'name' => 'mkd_portfolio_single_masonry_columns_number_meta',
            'type' => 'select',
            'label' => esc_html__('Number of Columns', 'highrise'),
            'default_value' => '',
            'description' => esc_html__('Set number of columns for portfolio masonry type', 'highrise'),
            'parent' => $masonry_type_meta_container,
            'options' => array(
                '' => esc_html__('Default', 'highrise'),
                'two' => esc_html__('2 Columns', 'highrise'),
                'three' => esc_html__('3 Columns', 'highrise'),
                'four' => esc_html__('4 Columns', 'highrise')
            )
        ));

        highrise_mikado_add_meta_box_field(array(
            'name' => 'mkd_portfolio_single_masonry_space_between_items_meta',
            'type' => 'select',
            'label' => esc_html__('Space Between Items', 'highrise'),
            'default_value' => '',
            'description' => esc_html__('Set space size between columns for portfolio masonry type', 'highrise'),
            'parent' => $masonry_type_meta_container,
            'options' => array(
                '' => esc_html__('Default', 'highrise'),
                'normal' => esc_html__('Normal', 'highrise'),
                'small' => esc_html__('Small', 'highrise'),
                'tiny' => esc_html__('Tiny', 'highrise'),
                'no' => esc_html__('No Space', 'highrise')
            )
        ));

        /***************** Masonry Layout *****************/

        highrise_mikado_add_meta_box_field(array(
            'name' => 'portfolio_info_top_padding',
            'type' => 'text',
            'label' => esc_html__('Portfolio Info Top Padding', 'highrise'),
            'description' => esc_html__('Set top padding for portfolio info elements holder. This option works only for Portfolio Images, Slider, Gallery and Masonry portfolio types', 'highrise'),
            'parent' => $meta_box,
            'args' => array(
                'col_width' => 3,
                'suffix' => 'px'
            )
        ));

        $all_pages = array();
        $pages = get_pages();
        foreach ($pages as $page) {
            $all_pages[$page->ID] = $page->post_title;
        }

        highrise_mikado_add_meta_box_field(array(
            'name' => 'portfolio_single_back_to_link',
            'type' => 'select',
            'label' => esc_html__('"Back To" Link', 'highrise'),
            'description' => esc_html__('Choose "Back To" page to link from portfolio Single Project page', 'highrise'),
            'parent' => $meta_box,
            'options' => $all_pages
        ));

        highrise_mikado_add_meta_box_field(array(
            'name' => 'portfolio_external_link',
            'type' => 'text',
            'label' => esc_html__('Portfolio External Link', 'highrise'),
            'description' => esc_html__('Enter URL to link from Portfolio List page', 'highrise'),
            'parent' => $meta_box,
            'args' => array(
                'col_width' => 3
            )
        ));

        highrise_mikado_add_meta_box_field(
            array(
                'name' => 'mkd_portfolio_featured_image_meta',
                'type' => 'image',
                'label' => esc_html__('Featured Image', 'highrise'),
                'description' => esc_html__('Choose an image for Portfolio Lists shortcode where Hover Type option is Switch Featured Images', 'highrise'),
                'parent' => $meta_box
            )
        );

        highrise_mikado_add_meta_box_field(array(
            'name' => 'portfolio_masonry_dimensions',
            'type' => 'select',
            'label' => esc_html__('Dimensions for Masonry', 'highrise'),
            'description' => esc_html__('Choose image layout when it appears in Masonry type portfolio lists', 'highrise'),
            'parent' => $meta_box,
            'options' => array(
                '' => esc_html__('Default', 'highrise'),
                'large-width' => esc_html__('Large Width', 'highrise'),
            )
        ));
    }

    add_action('highrise_mikado_meta_boxes_map', 'highrise_mikado_map_portfolio_settings');
}