<?php

$general_meta_box = highrise_mikado_add_meta_box(
    array(
        'scope' => array('page', 'portfolio-item', 'post'),
        'title' => esc_html__('General', 'highrise'),
        'name' => 'general_meta'
    )
);


highrise_mikado_add_meta_box_field(
    array(
        'name' => 'mkd_page_background_color_meta',
        'type' => 'color',
        'default_value' => '',
        'label' => esc_html__('Page Background Color', 'highrise'),
        'description' => esc_html__('Choose background color for page content', 'highrise'),
        'parent' => $general_meta_box
    )
);

highrise_mikado_add_meta_box_field(
    array(
        'name'          => 'mkd_page_content_behind_header_meta',
        'type'          => 'yesno',
        'default_value' => 'no',
        'label'         => 'Always put content behind header',
        'description'   => 'Enabling this option will put page content behind page header',
        'parent'        => $general_meta_box,
    )
);

highrise_mikado_add_meta_box_field(
    array(
        'name' => 'mkd_page_slider_meta',
        'type' => 'text',
        'default_value' => '',
        'label' => esc_html__('Slider Shortcode', 'highrise'),
        'description' => esc_html__('Paste your slider shortcode here', 'highrise'),
        'parent' => $general_meta_box
    )
);

highrise_mikado_add_meta_box_field(
    array(
        'name' => 'mkd_page_transition_type',
        'type' => 'selectblank',
        'label' => esc_html__('Page Transition', 'highrise'),
        'description' => esc_html__('Choose the type of transition to this page', 'highrise'),
        'parent' => $general_meta_box,
        'default_value' => '',
        'options' => array(
            'no-animation' => esc_html__('No animation', 'highrise'),
            'fade' => esc_html__('Fade', 'highrise')
        )
    )
);

highrise_mikado_add_meta_box_field(
    array(
        'name'          => 'mkd_boxed_meta',
        'type'          => 'selectblank',
        'default_value' => '',
        'label'         => esc_html__('Boxed Layout','highrise'),
        'description'   => '',
        'parent'        => $general_meta_box,
        'options'       => array(
            'no'  => esc_html__('No', 'highrise'),
            'yes' => esc_html__('Yes', 'highrise')
        ),
        'args'          => array(
            'dependence' => true,
            'hide'       => array(
                ''    => '',
                'no'  => '#mkd_boxed_container',
                'yes' => ''
            ),
            'show'       => array(
                ''    => '',
                'no'  => '',
                'yes' => '#mkd_boxed_container'
            )
        )
    ));

$boxed_container = highrise_mikado_add_admin_container(
    array(
        'parent'            => $general_meta_box,
        'name'              => 'boxed_container',
        'hidden_property'   => 'mkd_boxed_meta',
        'hidden_value'    => 'no',
        'hidden_values'   => array('', 'no')
    )
);

highrise_mikado_add_meta_box_field(
    array(
        'name'          => 'mkd_page_background_color_in_box',
        'type'          => 'color',
        'label'         => esc_html__('Page Background Color','highrise'),
        'description'   => esc_html__('Choose the page background color outside box.','highrise'),
        'parent'        => $boxed_container
    )
);

highrise_mikado_add_meta_box_field(
    array(
        'name'          => 'mkd_boxed_background_image',
        'type'          => 'image',
        'label'         =>esc_html__( 'Background Image','highrise'),
        'description'   =>esc_html__( 'Choose an image to be displayed in background','highrise'),
        'parent'        => $boxed_container
    )
);

highrise_mikado_add_meta_box_field(
    array(
        'name'          => 'mkd_boxed_pattern_background_image',
        'type'          => 'image',
        'label'         => esc_html__('Background Pattern','highrise'),
        'description'   => esc_html__( 'Choose an image to be used as background pattern','highrise'),
        'parent'        => $boxed_container
    )
);

highrise_mikado_add_meta_box_field(
    array(
        'name'          => 'mkd_boxed_background_image_attachment',
        'type'          => 'selectblank',
        'default_value' => '',
        'label'         => esc_html__('Background Image Attachment','highrise'),
        'description'   => esc_html__('Choose background image attachment','highrise'),
        'parent'        => $boxed_container,
        'options'       => array(
            'fixed'     => esc_html__('Fixed','highrise'),
            'scroll'    => esc_html__('Scroll','highrise')
        )
    )
);

$mkd_content_padding_group = highrise_mikado_add_admin_group(array(
    'name' => 'content_padding_group',
    'title' => esc_html__('Content Style','highrise'),
    'description' => esc_html__('Define styles for Content area','highrise'),
    'parent' => $general_meta_box
));

$mkd_content_padding_row = highrise_mikado_add_admin_row(array(
    'name' => 'mkd_content_padding_row',
    'next' => true,
    'parent' => $mkd_content_padding_group
));

highrise_mikado_add_meta_box_field(
    array(
        'name'          => 'mkd_page_content_top_padding',
        'type'          => 'textsimple',
        'default_value' => '',
        'label'         => esc_html__('Content Top Padding','highrise'),
        'parent'        => $mkd_content_padding_row,
        'args'          => array(
            'suffix' => 'px'
        )
    )
);

highrise_mikado_add_meta_box_field(
    array(
        'name'        => 'mkd_page_content_top_padding_mobile',
        'type'        => 'selectblanksimple',
        'label'       => esc_html__('Set this top padding for mobile header','highrise'),
        'parent'      => $mkd_content_padding_row,
        'options'     => array(
            'yes' => 'Yes',
            'no' => 'No',
        )
    )
);

highrise_mikado_add_meta_box_field(
    array(
        'name'          => 'mkd_page_content_bottom_padding',
        'type'          => 'textsimple',
        'default_value' => '',
        'label'         => esc_html__('Content Bottom Padding','highrise'),
        'parent'        => $mkd_content_padding_row,
        'args'          => array(
            'suffix' => 'px'
        )
    )
);

highrise_mikado_add_meta_box_field(
    array(
        'name' => 'mkd_page_comments_meta',
        'type' => 'selectblank',
        'label' => esc_html__('Show Comments', 'highrise'),
        'description' => esc_html__('Enabling this option will show comments on your page', 'highrise'),
        'parent' => $general_meta_box,
        'options' => array(
            'yes' => esc_html__('Yes', 'highrise'),
            'no' => esc_html__('No', 'highrise')
        )
    )
);