(function ($) {
    'use strict';

    var shortcodes = {};

    mkd.modules.shortcodes = shortcodes;

    shortcodes.mkdInitCounter = mkdInitCounter;
    shortcodes.mkdInitProgressBars = mkdInitProgressBars;
    shortcodes.mkdInitCountdown = mkdInitCountdown;
    shortcodes.mkdInitMessages = mkdInitMessages;
    shortcodes.mkdInitMessageHeight = mkdInitMessageHeight;
    shortcodes.mkdInitTestimonials = mkdInitTestimonials;
    shortcodes.mkdInitClientsCarousel = mkdInitClientsCarousel;
    shortcodes.mkdInitProgressCircle = mkdInitProgressCircle;
    shortcodes.mkdInitTabs = mkdInitTabs;
    shortcodes.mkdInitTabIcons = mkdInitTabIcons;
    shortcodes.mkdInitBlogListMasonry = mkdInitBlogListMasonry;
    shortcodes.mkdCustomFontResize = mkdCustomFontResize;
    shortcodes.mkdInitImageGallery = mkdInitImageGallery;
    shortcodes.mkdInitAccordions = mkdInitAccordions;
    shortcodes.mkdServiceTable = mkdServiceTable;
    shortcodes.mkdShowGoogleMap = mkdShowGoogleMap;
    shortcodes.mkdProcess = mkdProcess;
    shortcodes.mkdInitInfoBox = mkdInitInfoBox;
    shortcodes.mkdInitTwitterSlider = mkdInitTwitterSlider;
    shortcodes.mkdInitPricingSlider = mkdInitPricingSlider;
    shortcodes.mkdInitContentSlider = mkdInitContentSlider;
    shortcodes.mkdInitWorkflow = mkdInitWorkflow;

    shortcodes.mkdOnDocumentReady = mkdOnDocumentReady;
    shortcodes.mkdOnWindowLoad = mkdOnWindowLoad;
    shortcodes.mkdOnWindowResize = mkdOnWindowResize;
    shortcodes.mkdOnWindowScroll = mkdOnWindowScroll;

    $(document).ready(mkdOnDocumentReady);
    $(window).load(mkdOnWindowLoad);
    $(window).resize(mkdOnWindowResize);
    $(window).scroll(mkdOnWindowScroll);

    /* 
     All functions to be called on $(document).ready() should be in this function
     */
    function mkdOnDocumentReady() {
        mkdInitCounter();
        mkdInitProgressBars();
        mkdInitCountdown();
        mkdIcon().init();
        mkdInitMessages();
        mkdInitMessageHeight();
        mkdInitTestimonials();
        mkdInitClientsCarousel();
        mkdInitProgressCircle();
        mkdInitTabs();
        mkdInitTabIcons();
        mkdInitBlogListMasonry();
        mkdCustomFontResize();
        mkdInitImageGallery();
        mkdInitAccordions();
        mkdServiceTable();
        mkdShowGoogleMap();
        mkdProcess();
        mkdSocialIconWidget().init();
        mkdInitList().init();
        mkdInitWorkflow();
        mkdInstagramCarousel();
        mkdInitTwitterSlider();
        mkdInitPricingSlider();
        mkdInitContentSlider();
    }

    /* 
     All functions to be called on $(window).load() should be in this function
     */
    function mkdOnWindowLoad() {
        mkdInitInfoBox();
        mkdInitCharts();
        mkdInitElementsHolderResponsiveStyle();
    }

    /* 
     All functions to be called on $(window).resize() should be in this function
     */
    function mkdOnWindowResize() {
        mkdInitBlogListMasonry();
        mkdCustomFontResize();
    }

    /* 
     All functions to be called on $(window).scroll() should be in this function
     */
    function mkdOnWindowScroll() {

    }

    /*
     **	Elements Holder responsive style
     */
    function mkdInitElementsHolderResponsiveStyle() {

        var elementsHolder = $('.mkd-elements-holder');

        if (elementsHolder.length) {
            elementsHolder.each(function () {
                var thisElementsHolder = $(this),
                    elementsHolderItem = thisElementsHolder.children('.mkd-elements-holder-item'),
                    style = '',
                    responsiveStyle = '';

                elementsHolderItem.each(function () {
                    var thisItem = $(this),
                        itemClass = '',
                        largeLaptop = '',
                        smallLaptop = '',
                        ipadLandscape = '',
                        ipadPortrait = '',
                        mobileLandscape = '',
                        mobilePortrait = '';


                    if (typeof thisItem.data('item-class') !== 'undefined' && thisItem.data('item-class') !== false) {
                        itemClass = thisItem.data('item-class');
                    }
                    if (typeof thisItem.data('1280-1440') !== 'undefined' && thisItem.data('1280-1440') !== false) {
                        largeLaptop = thisItem.data('1280-1440');
                    }
                    if (typeof thisItem.data('1024-1280') !== 'undefined' && thisItem.data('1024-1280') !== false) {
                        smallLaptop = thisItem.data('1024-1280');
                    }
                    if (typeof thisItem.data('768-1024') !== 'undefined' && thisItem.data('768-1024') !== false) {
                        ipadLandscape = thisItem.data('768-1024');
                    }
                    if (typeof thisItem.data('600-768') !== 'undefined' && thisItem.data('600-768') !== false) {
                        ipadPortrait = thisItem.data('600-768');
                    }
                    if (typeof thisItem.data('480-600') !== 'undefined' && thisItem.data('480-600') !== false) {
                        mobileLandscape = thisItem.data('480-600');
                    }
                    if (typeof thisItem.data('480') !== 'undefined' && thisItem.data('480') !== false) {
                        mobilePortrait = thisItem.data('480');
                    }

                    if (largeLaptop.length || smallLaptop.length || ipadLandscape.length || ipadPortrait.length || mobileLandscape.length || mobilePortrait.length) {

                        if (largeLaptop.length) {
                            responsiveStyle += "@media only screen and (min-width: 1280px) and (max-width: 1440px) {.mkd-elements-holder-item-content." + itemClass + " { padding: " + largeLaptop + " !important; } }";
                        }
                        if (smallLaptop.length) {
                            responsiveStyle += "@media only screen and (min-width: 1024px) and (max-width: 1280px) {.mkd-elements-holder-item-content." + itemClass + " { padding: " + smallLaptop + " !important; } }";
                        }
                        if (ipadLandscape.length) {
                            responsiveStyle += "@media only screen and (min-width: 768px) and (max-width: 1024px) {.mkd-elements-holder-item-content." + itemClass + " { padding: " + ipadLandscape + " !important; } }";
                        }
                        if (ipadPortrait.length) {
                            responsiveStyle += "@media only screen and (min-width: 600px) and (max-width: 768px) {.mkd-elements-holder-item-content." + itemClass + " { padding: " + ipadPortrait + " !important; } }";
                        }
                        if (mobileLandscape.length) {
                            responsiveStyle += "@media only screen and (min-width: 480px) and (max-width: 600px) {.mkd-elements-holder-item-content." + itemClass + " { padding: " + mobileLandscape + " !important; } }";
                        }
                        if (mobilePortrait.length) {
                            responsiveStyle += "@media only screen and (max-width: 480px) {.mkd-elements-holder-item-content." + itemClass + " { padding: " + mobilePortrait + " !important; } }";
                        }
                    }
                });

                if (responsiveStyle.length) {
                    style = '<style type="text/css" data-type="highrise_mikado_modules_shortcodes_eh_custom_css">' + responsiveStyle + '</style>';
                }

                if (style.length) {
                    $('head').append(style);
                }
            });
        }
    }

    // content slider
    function mkdInitContentSlider() {
        var contentSlider = $('.mkd-content-slider');

        if (contentSlider.length) {
            contentSlider.each(function () {
                var loop = (contentSlider.data('loop') == 'yes'),
                    pause = (contentSlider.data('pause') == 'yes'),
                    navigation = (contentSlider.data('navigation') == 'yes'),
                    pagination = (contentSlider.data('pagination') == 'yes'),
                    autoplay = (contentSlider.data('autoplay') != 'disable'),
                    autoplayTimeout = 0;

                if (autoplay === true) {
                    autoplayTimeout = contentSlider.data('autoplay') * 1000;
                }

                $(this).owlCarousel({
                    items: 1,
                    loop: loop,
                    autoplayHoverPause: pause,
                    autoplay: autoplay,
                    autoplayTimeout: autoplayTimeout,
                    dots: pagination,
                    nav: navigation,
                    navText: [
                        '<span class="mkd-prev-icon"><i class="arrow_carrot-left"></i></span>',
                        '<span class="mkd-next-icon"><i class="arrow_carrot-right"></i></span>'
                    ],
                    onInitialized: function () {
                        contentSlider.css({'opacity': '1'});
                    },
                    onInitialize: function () {
                        if (contentSlider.find('.mkd-content-slider-item').length <= 1) {
                            this.settings.loop = false;
                        }
                    }
                });
            });
        }
    }

    // instagram slider
    function mkdInstagramCarousel() {

        var instagramCarousels = $('.mkd-instagram-feed.mkd-instagram-carousel');

        if (instagramCarousels.length) {
            instagramCarousels.each(function () {

                var carousel = $(this),
                    items = 6,
                    loop = true,
                    margin;

                if (typeof carousel.data('items') !== 'undefined' && carousel.data('items') !== false) {
                    items = carousel.data('items');
                }

                // Fix for the issue with the carousels holding only one item - the carousel's core issue
                if (carousel.children().length == 1) {
                    loop = false;
                }

                if (items === 1) {
                    margin = 0;
                } else if ((carousel.data('space-between-items') === 'normal')) {
                    margin = 20;
                } else if ((carousel.data('space-between-items') === 'small')) {
                    margin = 10;
                } else if ((carousel.data('space-between-items') === 'tiny')) {
                    margin = 5;
                } else if ((carousel.data('space-between-items') === 'no')) {
                    margin = 0;
                }

                var responsiveItems1 = items;
                var responsiveItems2 = 4;
                var responsiveItems3 = 3;
                var responsiveItems4 = 2;

                if (items > 5) {
                    responsiveItems1 = 5;
                }

                if (items < 4) {
                    responsiveItems2 = items;
                }

                if (items < 3) {
                    responsiveItems3 = items;
                }

                if (items === 1) {
                    responsiveItems4 = items;
                }

                carousel.owlCarousel({
                    autoplay: true,
                    autoplayHoverPause: true,
                    autoplayTimeout: 5000,
                    smartSpeed: 600,
                    items: items,
                    margin: margin,
                    loop: loop,
                    dots: false,
                    nav: false,
                    responsive: {
                        1200: {
                            items: items
                        },
                        1024: {
                            items: responsiveItems1
                        },
                        769: {
                            items: responsiveItems2
                        },
                        601: {
                            items: responsiveItems3
                        },
                        0: {
                            items: responsiveItems4
                        }
                    },
                    onInitialized: function () {
                        carousel.css({'opacity': 1});
                    },
                });

            });
        }
    }

    // twitter slider
    function mkdInitTwitterSlider() {
        var twitterSlider = $('.mkd-twitter-slider-inner');

        if (twitterSlider.length) {
            twitterSlider.each(function () {
                var currentSlider = $(this),
                    loop = (currentSlider.data('loop') == 'yes'),
                    pause = (currentSlider.data('pause') == 'yes'),
                    navigation = (currentSlider.data('navigation') == 'yes'),
                    pagination = (currentSlider.data('pagination') == 'yes'),
                    autoplay = (currentSlider.data('autoplay') != 'disable'),
                    autoplayTimeout = 0;

                if (autoplay === true) {
                    autoplayTimeout = currentSlider.data('autoplay') * 1000;
                }

                $(this).owlCarousel({
                    items: 1,
                    loop: loop,
                    autoplayHoverPause: pause,
                    autoplay: autoplay,
                    autoplayTimeout: autoplayTimeout,
                    dots: pagination,
                    nav: navigation,
                    smartSpeed: 600,
                    navText: [
                        '<span class="mkd-prev-icon"><i class="arrow_carrot-left"></i></span>',
                        '<span class="mkd-next-icon"><i class="arrow_carrot-right"></i></span>'
                    ],
                    onInitialized: function () {
                        currentSlider.css({'opacity': 1});
                    },
                    onInitialize: function () {
                        if (currentSlider.find('.mkd-twitter-slider-item').length <= 1) {
                            this.settings.loop = false;
                        }
                    }
                });

            });
        }
    }

    // counter shortcode
    function mkdInitCounter() {

        var counters = $('.mkd-counter');

        if (counters.length) {
            counters.each(function () {
                var counter = $(this);
                counter.appear(function () {
                    counter.parent().addClass('mkd-counter-holder-show');

                    //Counter zero type
                    if (counter.hasClass('zero')) {
                        var max = parseFloat(counter.text());
                        counter.countTo({
                            from: 0,
                            to: max,
                            speed: 1500,
                            refreshInterval: 100
                        });
                    } else {
                        counter.absoluteCounter({
                            speed: 2000,
                            fadeInDelay: 1000
                        });
                    }

                }, {accX: 0, accY: mkdGlobalVars.vars.mkdElementAppearAmount});
            });
        }

    }

    // horizontal progress bars shortcode
    function mkdInitProgressBars() {

        var progressBar = $('.mkd-progress-bar');

        if (progressBar.length) {

            progressBar.each(function () {

                var thisBar = $(this);

                thisBar.appear(function () {
                    mkdInitToCounterProgressBar(thisBar);
                    if (thisBar.find('.mkd-floating.mkd-floating-inside') !== 0) {
                        var floatingInsideMargin = thisBar.find('.mkd-progress-content').height();
                        floatingInsideMargin += parseFloat(thisBar.find('.mkd-progress-title-holder').css('padding-bottom'));
                        floatingInsideMargin += parseFloat(thisBar.find('.mkd-progress-title-holder').css('margin-bottom'));
                        thisBar.find('.mkd-floating-inside').css('margin-bottom', -(floatingInsideMargin) + 'px');
                    }
                    var percentage = thisBar.find('.mkd-progress-content').data('percentage'),
                        progressContent = thisBar.find('.mkd-progress-content'),
                        progressNumber = thisBar.find('.mkd-progress-number');

                    progressContent.css('width', '0%');
                    progressContent.animate({'width': percentage + '%'}, 1500);
                    progressNumber.css('left', '0%');
                    progressNumber.animate({'left': percentage + '%'}, 1500);

                });
            });
        }
    }


    // counter for horizontal progress bars percent from zero to defined percent
    function mkdInitToCounterProgressBar(progressBar) {
        var percentage = parseFloat(progressBar.find('.mkd-progress-content').data('percentage'));
        var percent = progressBar.find('.mkd-progress-number .mkd-percent');
        if (percent.length) {
            percent.each(function () {
                var thisPercent = $(this);
                thisPercent.parents('.mkd-progress-number-wrapper').css('opacity', '1');
                thisPercent.countTo({
                    from: 0,
                    to: percentage,
                    speed: 1500,
                    refreshInterval: 50
                });
            });
        }
    }

    // function to close message shortcode
    function mkdInitMessages() {
        var message = $('.mkd-message');
        if (message.length) {
            message.each(function () {
                var thisMessage = $(this);
                thisMessage.find('.mkd-close').click(function (e) {
                    e.preventDefault();
                    $(this).parent().parent().fadeOut(500);
                });
            });
        }
    }

    // init message height
    function mkdInitMessageHeight() {
        var message = $('.mkd-message.mkd-with-icon');
        if (message.length) {
            message.each(function () {
                var thisMessage = $(this);
                var textHolderHeight = thisMessage.find('.mkd-message-text-holder').height();
                var iconHolderHeight = thisMessage.find('.mkd-message-icon-holder').height();

                if (textHolderHeight > iconHolderHeight) {
                    thisMessage.find('.mkd-message-icon-holder').height(textHolderHeight);
                } else {
                    thisMessage.find('.mkd-message-text-holder').height(iconHolderHeight);
                }
            });
        }
    }

    // countdown shortcode
    function mkdInitCountdown() {
        var countdowns = $('.mkd-countdown'),
            year,
            month,
            day,
            hour,
            minute,
            timezone,
            monthLabel,
            dayLabel,
            hourLabel,
            minuteLabel,
            secondLabel;

        if (countdowns.length) {
            countdowns.each(function () {

                // find countdown elements by id-s
                var countdownId = $(this).attr('id'),
                    countdown = $('#' + countdownId),
                    digitFontSize,
                    labelFontSize;

                // get data for countdown
                year = countdown.data('year');
                month = countdown.data('month');
                day = countdown.data('day');
                hour = countdown.data('hour');
                minute = countdown.data('minute');
                timezone = countdown.data('timezone');
                monthLabel = countdown.data('month-label');
                dayLabel = countdown.data('day-label');
                hourLabel = countdown.data('hour-label');
                minuteLabel = countdown.data('minute-label');
                secondLabel = countdown.data('second-label');
                digitFontSize = countdown.data('digit-size');
                labelFontSize = countdown.data('label-size');

                // initialize countdown
                countdown.countdown({
                    until: new Date(year, month - 1, day, hour, minute, 44),
                    labels: ['Years', monthLabel, 'Weeks', dayLabel, hourLabel, minuteLabel, secondLabel],
                    format: 'ODHMS',
                    timezone: timezone,
                    padZeroes: true,
                    onTick: setCountdownStyle
                });

                function setCountdownStyle() {
                    countdown.find('.countdown-amount').css({
                        'font-size': digitFontSize + 'px',
                        'line-height': digitFontSize + 'px'
                    });
                    countdown.find('.countdown-period').css({
                        'font-size': labelFontSize + 'px'
                    });
                }

            });

        }

    }

    // info box shortcode
    function mkdInitInfoBox() {
        var infoBoxes = $('.mkd-info-box-holder');

        var getBottomHeight = function (bottomHolder) {
            if (bottomHolder.length) {
                return bottomHolder.height();
            }

            return false;
        };

        var infoBoxesHeight = function () {
            if (infoBoxes.length) {
                var maxHeight = 0;
                var heightestBox;

                infoBoxes.each(function () {
                    var bottomHolder = $(this).find('.mkd-ib-bottom-holder');
                    var topHolder = $(this).find('.mkd-ib-top-holder');

                    var currentHeight = getBottomHeight(bottomHolder) + topHolder.height();

                    maxHeight = Math.max(maxHeight, currentHeight);

                    if (maxHeight <= currentHeight) {
                        heightestBox = $(this);
                        maxHeight = currentHeight;
                    }
                });

                infoBoxes.height(maxHeight);
            }
        };

        var initHover = function (infoBox) {
            var timeline = new TimelineLite({paused: true}),
                topHolder = infoBox.find('.mkd-ib-top-holder'),
                bottomHolder = infoBox.find('.mkd-ib-bottom-holder'),
                bottomHeight = getBottomHeight(bottomHolder);

            if (infoBox.hasClass('mkd-hide-icon')) {
                timeline.to(topHolder, 0.6, {y: -(bottomHeight * 1), ease: Back.easeInOut.config(2)});
                timeline.to(bottomHolder, 0.4, {y: -(bottomHeight * 1), ease: Back.easeOut}, '-=0.3');
            }
            else if (infoBox.hasClass('mkd-no-icon')) {
                timeline.to(topHolder, 0.6, {y: -(bottomHeight * 0.65), ease: Back.easeInOut.config(2)});
                timeline.to(bottomHolder, 0.4, {y: -(bottomHeight * 0.65), ease: Back.easeOut}, '-=0.3');
            }
            else {
                timeline.to(topHolder, 0.6, {y: -(bottomHeight / 2), ease: Back.easeInOut.config(2)});
                timeline.to(bottomHolder, 0.4, {y: -(bottomHeight / 2), ease: Back.easeOut}, '-=0.3');
            }

            infoBox.hover(function () {
                timeline.restart();
            }, function () {
                timeline.reverse();
            });
        };

        if (infoBoxes.length) {
            infoBoxesHeight();

            $(mkd.window).resize(function () {
                infoBoxesHeight();
            });

            infoBoxes.each(function () {
                var thisInfoBox = $(this);
                initHover(thisInfoBox);

                $(mkd.window).resize(function () {
                    initHover(thisInfoBox);
                });
            });
        }
    }

    /**
     * Object that represents icon shortcode
     * @returns {{init: Function}} function that initializes icon's functionality
     */
    var mkdIcon = mkd.modules.shortcodes.mkdIcon = function () {
        //get all icons on page
        var icons = $('.mkd-icon-shortcode');

        /**
         * Function that triggers icon animation and icon animation delay
         */
        var iconAnimation = function (icon) {
            if (icon.hasClass('mkd-icon-animation')) {
                icon.appear(function () {
                    icon.parent('.mkd-icon-animation-holder').addClass('mkd-icon-animation-show');
                }, {accX: 0, accY: mkdGlobalVars.vars.mkdElementAppearAmount});
            }
        };

        /**
         * Function that triggers icon hover color functionality
         */
        var iconHoverColor = function (icon) {
            if (typeof icon.data('hover-color') !== 'undefined') {
                var changeIconColor = function (event) {
                    event.data.icon.css('color', event.data.color);
                };

                var iconElement = icon.find('.mkd-icon-element');
                var hoverColor = icon.data('hover-color');
                var originalColor = iconElement.css('color');

                if (hoverColor !== '') {
                    icon.on('mouseenter', {icon: iconElement, color: hoverColor}, changeIconColor);
                    icon.on('mouseleave', {icon: iconElement, color: originalColor}, changeIconColor);
                }
            }
        };

        /**
         * Function that triggers icon holder background color hover functionality
         */
        var iconHolderBackgroundHover = function (icon) {
            if (typeof icon.data('hover-background-color') !== 'undefined') {
                var changeIconBgColor = function (event) {
                    event.data.icon.css('background-color', event.data.color);
                };

                var hoverBackgroundColor = icon.data('hover-background-color');
                var originalBackgroundColor = icon.css('background-color');

                if (hoverBackgroundColor !== '') {
                    icon.on('mouseenter', {icon: icon, color: hoverBackgroundColor}, changeIconBgColor);
                    icon.on('mouseleave', {icon: icon, color: originalBackgroundColor}, changeIconBgColor);
                }
            }
        };

        /**
         * Function that initializes icon holder border hover functionality
         */
        var iconHolderBorderHover = function (icon) {
            if (typeof icon.data('hover-border-color') !== 'undefined') {
                var changeIconBorder = function (event) {
                    event.data.icon.css('border-color', event.data.color);
                };

                var hoverBorderColor = icon.data('hover-border-color');
                var originalBorderColor = icon.css('border-color');

                if (hoverBorderColor !== '') {
                    icon.on('mouseenter', {icon: icon, color: hoverBorderColor}, changeIconBorder);
                    icon.on('mouseleave', {icon: icon, color: originalBorderColor}, changeIconBorder);
                }
            }
        };

        return {
            init: function () {
                if (icons.length) {
                    icons.each(function () {
                        iconAnimation($(this));
                        iconHoverColor($(this));
                        iconHolderBackgroundHover($(this));
                        iconHolderBorderHover($(this));
                    });

                }
            }
        };
    };

    /**
     * Object that represents social icon widget
     * @returns {{init: Function}} function that initializes icon's functionality
     */
    var mkdSocialIconWidget = mkd.modules.shortcodes.mkdSocialIconWidget = function () {
        //get all social icons on page
        var icons = $('.mkd-social-icon-widget-holder');

        /**
         * Function that triggers icon hover color functionality
         */
        var socialIconHoverColor = function (icon) {
            if (typeof icon.data('hover-color') !== 'undefined') {
                var changeIconColor = function (event) {
                    event.data.icon.css('color', event.data.color);
                };

                var iconElement = icon;
                var hoverColor = icon.data('hover-color');
                var originalColor = iconElement.css('color');

                if (hoverColor !== '') {
                    icon.on('mouseenter', {icon: iconElement, color: hoverColor}, changeIconColor);
                    icon.on('mouseleave', {icon: iconElement, color: originalColor}, changeIconColor);
                }
            }
        };

        return {
            init: function () {
                if (icons.length) {
                    icons.each(function () {
                        socialIconHoverColor($(this));
                    });

                }
            }
        };
    };


    // pricing slider
    function mkdInitPricingSlider() {
        var pricingSliders = $('.mkd-pricing-slider');

        pricingSliders.each(function () {
            var slider = $(this);
            var dragHolder = slider.find('.mkd-pricing-slider-bar-holder');
            var drag = slider.find('.mkd-pricing-slider-drag');
            var progressBar = slider.find('.mkd-pricing-slider-bar');
            var pricingButtonHolder = slider.find('.mkd-pricing-slider-button-holder');
            var activeFilter = pricingButtonHolder.find('.active');
            var priceElement = slider.find('.mkd-price');
            var sliderTextLabel = slider.find('.mkd-pricing-slider-value');

            var unitName = slider.data('unit-name') ? slider.data('unit-name') : "unit";
            var unitsRange = parseFloat(slider.data('units-range')) ? parseFloat(slider.data('units-range')) : 0;
            var unitsBreakpoints = parseFloat(slider.data('units-breakpoints')) ? parseFloat(slider.data('units-breakpoints')) : 0;
            var price = parseFloat(activeFilter.data('price-per-unit')) ? parseFloat(activeFilter.data('price-per-unit')) : 0;
            var reduceRate = parseFloat(activeFilter.data('price-reduce-per-breakpoint')) ? parseFloat(activeFilter.data('price-reduce-per-breakpoint')) : 0;
            var breakpointValue = unitsBreakpoints;
            var breakPointsIterator = 0;

            var parentXPos = dragHolder.offset().left;
            var parentWidth = dragHolder.outerWidth() - drag.outerWidth();
            var iterator = parentWidth / unitsRange;

            var offset = 0;
            var xPos = 0;
            var units = 0;

            var i;
            if (unitsBreakpoints > 0) {
                var delimiters = unitsRange / unitsBreakpoints;
                for (i = 1; i < delimiters; i++) {
                    progressBar.append('<span class="delimiter" style="left:' + Math.round((100 / delimiters) * i) + '%;"></span>');
                }
            }

            recalculateValues(priceElement, units, price, sliderTextLabel, progressBar, xPos, parentWidth, unitName);

            pricingButtonHolder.find('.mkd-btn').click(function (e) {
                e.preventDefault();

                if (!$(this).parent().hasClass('active')) {
                    activeFilter.removeClass('active');
                    $(this).parent().addClass('active');
                    activeFilter = $(this).parent();
                    price = parseFloat(activeFilter.data('price-per-unit')) ? parseFloat(activeFilter.data('price-per-unit')) : 0;
                    reduceRate = parseFloat(activeFilter.data('price-reduce-per-breakpoint')) ? parseFloat(activeFilter.data('price-reduce-per-breakpoint')) : 0;
                    price = price - breakPointsIterator * reduceRate;
                    recalculateValues(priceElement, units, price, sliderTextLabel, progressBar, xPos, parentWidth, unitName);
                }
            });

            var draggerPosition;
            drag.draggable({
                axis: "x",
                containment: dragHolder.parent(),
                scrollSensitivity: 10,
                start: function (event, ui) {
                    draggerPosition = ui.position.left;
                },
                drag: function (event, ui) {
                    var direction = (ui.position.left > draggerPosition) ? 'right' : 'left';
                    draggerPosition = ui.position.left;
                    offset = $(this).offset();
                    xPos = offset.left - parentXPos;
                    units = Math.floor(xPos / iterator);
                    if (xPos >= 0 && xPos <= parentWidth) {
                        if (direction == 'right') {
                            if (units > breakpointValue) {
                                breakpointValue = breakpointValue + unitsBreakpoints;
                                breakPointsIterator++;
                                price = price - reduceRate;
                            }
                        }
                        else if (direction == 'left') {
                            if (units <= breakpointValue - unitsBreakpoints) {
                                breakpointValue = breakpointValue - unitsBreakpoints;
                                breakPointsIterator--;
                                price = price + reduceRate;
                            }
                        }
                        recalculateValues(priceElement, units, price, sliderTextLabel, progressBar, xPos, parentWidth, unitName);
                    }
                }
            });
        });

        function recalculateValues(priceElement, units, price, sliderTextLabel, progressBar, xPos, parentWidth, unitName) {
            priceElement.text(((Math.round(units * price * 100)) / 100));
            if (units == 1) {
                sliderTextLabel.text(units + " " + unitName);
            } else {
                sliderTextLabel.text(units + " " + unitName + "s");
            }
            progressBar.width(Math.round((xPos / parentWidth) * 100) + "%");
        }
    }


    function mkdInitTestimonials() {

        var testimonialsSlider = $('.mkd-testimonials');

        if (testimonialsSlider.length) {
            testimonialsSlider.each(function () {
                var currentSlider = $(this),
                    loop = (currentSlider.data('loop') == 'yes'),
                    pause = (currentSlider.data('pause') == 'yes'),
                    navigation = (currentSlider.data('navigation') == 'yes'),
                    pagination = (currentSlider.data('pagination') == 'yes'),
                    autoplay = (currentSlider.data('autoplay') != 'disable'),
                    autoplayTimeout = 0,
                    numberOfItems = 1,
                    numberOfItemsTablet = 1,
                    numberOfItemsPhone = 1,
                    margin = 0;

                if (autoplay === true) {
                    autoplayTimeout = currentSlider.data('autoplay') * 1000;
                }

                // set number of items for carousel
                if (currentSlider.hasClass('mkd-testimonials-carousel')) {
                    numberOfItems = currentSlider.data('visible-items');
                    numberOfItemsTablet = 3;
                    numberOfItemsPhone = 2;
                    margin = 30;
                }

                $(this).owlCarousel({
                    items: numberOfItems,
                    responsive: {
                        // breakpoint from 0 up
                        0: {
                            items: 1
                        },
                        // breakpoint from 480 up
                        480: {
                            items: numberOfItemsPhone
                        },
                        // breakpoint from 768 up
                        768: {
                            items: numberOfItemsTablet
                        },
                        // breakpoint from 1024 up
                        1024: {
                            items: numberOfItems
                        }
                    },
                    loop: loop,
                    autoplayHoverPause: pause,
                    autoplay: autoplay,
                    autoplayTimeout: autoplayTimeout,
                    dots: pagination,
                    nav: navigation,
                    smartSpeed: 400,
                    margin: margin,
                    navText: [
                        '<span class="mkd-prev-icon"><i class="arrow_carrot-left"></i></span>',
                        '<span class="mkd-next-icon"><i class="arrow_carrot-right"></i></span>'
                    ],
                    onInitialized: function () {
                        currentSlider.css({'opacity': 1});
                    },
                    onInitialize: function () {
                        if (currentSlider.find('.mkd-testimonial-content').length <= 1) {
                            this.settings.loop = false;
                        }
                    }
                });
            });
        }
    }

    // init carousel shortcode
    function mkdInitClientsCarousel() {

        var carouselHolders = $('.mkd-clients-carousel-holder');

        if (carouselHolders.length) {
            carouselHolders.each(function () {
                var carousel = $(this).children('.mkd-clients-carousel'),
                    numberOfItems = carousel.data('items'),
                    loop = (carousel.data('loop') == 'yes'),
                    pause = (carousel.data('pause') == 'yes'),
                    navigation = (carousel.data('navigation') == 'yes'),
                    pagination = (carousel.data('pagination') == 'yes'),
                    autoplay = (carousel.data('autoplay') != 'disable'),
                    autoplayTimeout = 0;

                if (autoplay === true) {
                    autoplayTimeout = carousel.data('autoplay') * 1000;
                }

                // Responsive breakpoints
                carousel.owlCarousel({
                    items: numberOfItems,
                    responsive: {
                        // breakpoint from 0 up
                        0: {
                            items: 1
                        },
                        // breakpoint from 480 up
                        480: {
                            items: 2
                        },
                        // breakpoint from 768 up
                        768: {
                            items: 3
                        },
                        // breakpoint from 1024 up
                        1024: {
                            items: numberOfItems
                        }
                    },
                    loop: loop,
                    autoplayHoverPause: pause,
                    autoplay: autoplay,
                    autoplayTimeout: autoplayTimeout,
                    dots: pagination,
                    nav: navigation,
                    mouseDrag: false,
                    navText: [
                        '<span class="mkd-prev-icon"><i class="arrow_carrot-left"></i></span>',
                        '<span class="mkd-next-icon"><i class="arrow_carrot-right"></i></span>'
                    ],
                    onInitialized: function () {
                        carousel.css({'opacity': 1});
                    },
                    onInitialize: function () {
                        if (carousel.find('.mkd-clients-carousel-item-holder').length <= 1) {
                            this.settings.loop = false;
                        }
                    }
                });

            });
        }

    }

    /**
     * Init Progress Circle shortcode
     */
    function mkdInitProgressCircle() {

        var progresCircles = $('.mkd-progress-circle-holder');

        if (progresCircles.length) {

            progresCircles.each(function () {

                var progressCircle = $(this),
                    percentageHolder = progressCircle.children('.mkd-progress-circle'),
                    barColor = '#8f78fc',
                    trackColor = '#f2f2f0',
                    lineWidth = 10,
                    size = 195;

                if (typeof percentageHolder.data('size') !== 'undefined' && percentageHolder.data('size') !== '') {
                    size = percentageHolder.data('size');
                }

                if (typeof percentageHolder.data('bar-color') !== 'undefined' && percentageHolder.data('bar-color') !== '') {
                    barColor = percentageHolder.data('bar-color');
                }

                if (typeof percentageHolder.data('track-color') !== 'undefined' && percentageHolder.data('track-color') !== '') {
                    trackColor = percentageHolder.data('track-color');
                }

                percentageHolder.appear(function () {
                    initToCounterProgressCircle(progressCircle);
                    percentageHolder.css('opacity', '1');

                    percentageHolder.easyPieChart({
                        barColor: barColor,
                        trackColor: trackColor,
                        scaleColor: false,
                        lineCap: 'butt',
                        lineWidth: lineWidth,
                        animate: 1000,
                        size: size
                    });
                }, {accX: 0, accY: mkdGlobalVars.vars.mkdElementAppearAmount});

            });

        }

    }

    /*
     **	Counter for pie chart number from zero to defined number
     */
    function initToCounterProgressCircle(progressCircle) {

        progressCircle.css('opacity', '1');
        var counter = progressCircle.find('.mkd-to-counter'),
            max = parseFloat(counter.text());
        counter.countTo({
            from: 0,
            to: max,
            speed: 1500,
            refreshInterval: 50
        });

    }

    /*
     **	Init tabs shortcode
     */
    function mkdInitTabs() {

        var tabs = $('.mkd-tabs');
        if (tabs.length) {
            tabs.each(function () {
                var thisTabs = $(this);
                thisTabs.children('.mkd-tab-container').each(function (index) {
                    index = index + 1;
                    var that = $(this),
                        link = that.attr('id'),
                        navItem = that.parent().find('.mkd-tabs-nav li:nth-child(' + index + ') a'),
                        navLink = navItem.attr('href');

                    link = '#' + link;

                    if (link.indexOf(navLink) > -1) {
                        navItem.attr('href', link);
                    }
                });

                if (thisTabs.hasClass('mkd-horizontal-tab')) {
                    thisTabs.tabs();
                } else if (thisTabs.hasClass('mkd-vertical-tab')) {
                    thisTabs.tabs().addClass('ui-tabs-vertical ui-helper-clearfix');
                    thisTabs.find('.mkd-tabs-nav > ul >li').removeClass('ui-corner-top').addClass('ui-corner-left');
                }

                // initially add appear class 
                $(".mkd-tab-container .mkd-elements-holder-item").addClass("mkd-appeared");

                tabs.find(".mkd-tabs-nav > li").click(function () {

                    var tabIndex = $(this).index();

                    thisTabs.children('.mkd-tab-container').removeClass("mkd-tab-container-active");
                    var activeTab = thisTabs.children('.mkd-tab-container').eq(tabIndex).addClass("mkd-tab-container-active");

                    activeTab.find(".mkd-elements-holder-item").removeClass("mkd-appeared");

                    activeTab.find(".mkd-elements-holder-item").each(function (i) {
                        var element = $(this);

                        setTimeout(function () {
                            element.addClass("mkd-appeared");
                        }, 100 * i);
                    });

                    mkdInitInfoBox();
                });

            });
        }
    }

    /*
     **	Generate icons in tabs navigation
     */
    function mkdInitTabIcons() {

        var tabContent = $('.mkd-tab-container');
        if (tabContent.length) {

            tabContent.each(function () {
                var thisTabContent = $(this);

                var id = thisTabContent.attr('id');
                var icon = '';
                var tabNav = thisTabContent.parents('.mkd-tabs').find('.mkd-tabs-nav > li a[href="#' + id + '"]');

                if (typeof thisTabContent.data('icon-html') !== 'undefined') {
                    icon = thisTabContent.data('icon-html');
                }
                else {
                    tabNav.children('.mkd-icon-frame').remove();
                }

                if (typeof(tabNav) !== 'undefined') {
                    tabNav.children('.mkd-icon-frame').append(icon);
                }
            });
        }
    }

    /*
     **	Init blog list masonry type
     */
    function mkdInitBlogListMasonry() {
        var blogList = $('.mkd-blog-list-holder.mkd-masonry .mkd-blog-list');
        if (blogList.length) {
            blogList.each(function () {
                var thisBlogList = $(this);
                blogList.waitForImages(function () {
                    thisBlogList.isotope({
                        layoutMode: 'packery',
                        itemSelector: '.mkd-blog-list-masonry-item',
                        packery: {
                            columnWidth: '.mkd-blog-list-masonry-grid-sizer',
                            gutter: '.mkd-blog-list-masonry-grid-gutter'
                        }
                    });
                    thisBlogList.addClass('mkd-appeared');
                });
            });

        }
    }

    /*
     **	Custom Font resizing
     */
    function mkdCustomFontResize() {
        var customFont = $('.mkd-custom-font-holder');
        if (customFont.length) {
            customFont.each(function () {
                var thisCustomFont = $(this);
                var fontSize;
                var lineHeight;
                var coef1 = 1;
                var coef2 = 1;

                if (mkd.windowWidth < 1200) {
                    coef1 = 0.8;
                }

                if (mkd.windowWidth < 1024) {
                    coef1 = 0.7;
                }

                if (mkd.windowWidth < 768) {
                    coef1 = 0.6;
                    coef2 = 0.7;
                }

                if (mkd.windowWidth < 600) {
                    coef1 = 0.5;
                    coef2 = 0.6;
                }

                if (mkd.windowWidth < 480) {
                    coef1 = 0.4;
                    coef2 = 0.5;
                }

                if (typeof thisCustomFont.data('font-size') !== 'undefined' && thisCustomFont.data('font-size') !== false) {
                    fontSize = parseInt(thisCustomFont.data('font-size'));

                    if (fontSize > 70) {
                        fontSize = Math.round(fontSize * coef1);
                    }
                    else if (fontSize > 35) {
                        fontSize = Math.round(fontSize * coef2);
                    }

                    thisCustomFont.css('font-size', fontSize + 'px');
                }

                if (typeof thisCustomFont.data('line-height') !== 'undefined' && thisCustomFont.data('line-height') !== false) {
                    lineHeight = parseInt(thisCustomFont.data('line-height'));

                    if (lineHeight > 70 && mkd.windowWidth < 1200) {
                        lineHeight = '1.2em';
                    }
                    else if (lineHeight > 35 && mkd.windowWidth < 768) {
                        lineHeight = '1.2em';
                    }
                    else {
                        lineHeight += 'px';
                    }

                    thisCustomFont.css('line-height', lineHeight);
                }
            });
        }
    }

    /* Icon appearing */
    function mkdServiceTable() {
        if ($(".mkd-service-table").length) {

            $(".mkd-service-table .mkd-mark").each(function () {

                var serviceTableIcon = $(this);

                serviceTableIcon.appear(function () {
                    setTimeout(function () {
                        serviceTableIcon.addClass("mkd-service-table-icon-appeared");
                    }, 100 * serviceTableIcon.closest("tr").index());
                }, {accX: 0, accY: mkdGlobalVars.vars.mkdElementAppearAmount});
            });
        }
    }

    /*
     **	Show Google Map
     */
    function mkdShowGoogleMap() {

        if ($('.mkd-google-map').length) {
            $('.mkd-google-map').each(function () {

                var element = $(this);

                var customMapStyle;
                if (typeof element.data('custom-map-style') !== 'undefined') {
                    customMapStyle = element.data('custom-map-style');
                }

                var colorOverlay;
                if (typeof element.data('color-overlay') !== 'undefined' && element.data('color-overlay') !== false) {
                    colorOverlay = element.data('color-overlay');
                }

                var saturation;
                if (typeof element.data('saturation') !== 'undefined' && element.data('saturation') !== false) {
                    saturation = element.data('saturation');
                }

                var lightness;
                if (typeof element.data('lightness') !== 'undefined' && element.data('lightness') !== false) {
                    lightness = element.data('lightness');
                }

                var zoom;
                if (typeof element.data('zoom') !== 'undefined' && element.data('zoom') !== false) {
                    zoom = element.data('zoom');
                }

                var pin;
                if (typeof element.data('pin') !== 'undefined' && element.data('pin') !== false) {
                    pin = element.data('pin');
                }

                var mapHeight;
                if (typeof element.data('height') !== 'undefined' && element.data('height') !== false) {
                    mapHeight = element.data('height');
                }

                var uniqueId;
                if (typeof element.data('unique-id') !== 'undefined' && element.data('unique-id') !== false) {
                    uniqueId = element.data('unique-id');
                }

                var scrollWheel;
                if (typeof element.data('scroll-wheel') !== 'undefined') {
                    scrollWheel = element.data('scroll-wheel');
                }
                var addresses;
                if (typeof element.data('addresses') !== 'undefined' && element.data('addresses') !== false) {
                    addresses = element.data('addresses');
                }

                var map = "map_" + uniqueId;
                var geocoder = "geocoder_" + uniqueId;
                var holderId = "mkd-map-" + uniqueId;

                mkdInitializeGoogleMap(customMapStyle, colorOverlay, saturation, lightness, scrollWheel, zoom, holderId, mapHeight, pin, map, geocoder, addresses);
            });
        }

    }

    /*
     ** Process appear animation
     */
    function mkdProcess() {
        if ($(".mkd-process-holder").length) {
            $(".mkd-process-holder").each(function () {

                var process = $(this),
                    processItem = process.find(".mkd-process-item");

                processItem.each(function (i) {
                    var thisItem = $(this);

                    thisItem.appear(function () {
                        setTimeout(function () {
                            thisItem.addClass("mkd-process-holder-appeared");
                        }, 300 * i);
                    }, {accX: 0, accY: mkdGlobalVars.vars.mkdElementAppearAmount});
                });

            });
        }

    }

    /*
     **	Init Google Map
     */
    function mkdInitializeGoogleMap(customMapStyle, color, saturation, lightness, wheel, zoom, holderId, height, pin, map, geocoder, data) {

        var mapStyles = [
            {
                stylers: [
                    {hue: color},
                    {saturation: saturation},
                    {lightness: lightness},
                    {gamma: 1}
                ]
            }
        ];

        var googleMapStyleId;

        if (customMapStyle) {
            googleMapStyleId = 'mkd-style';
        } else {
            googleMapStyleId = google.maps.MapTypeId.ROADMAP;
        }

        var qoogleMapType = new google.maps.StyledMapType(mapStyles,
            {name: "Mikado Google Map"});

        geocoder = new google.maps.Geocoder();
        var latlng = new google.maps.LatLng(-34.397, 150.644);

        if (!isNaN(height)) {
            height = height + 'px';
        }

        var myOptions = {

            zoom: zoom,
            scrollwheel: wheel,
            center: latlng,
            zoomControl: true,
            zoomControlOptions: {
                style: google.maps.ZoomControlStyle.SMALL,
                position: google.maps.ControlPosition.RIGHT_CENTER
            },
            scaleControl: false,
            scaleControlOptions: {
                position: google.maps.ControlPosition.LEFT_CENTER
            },
            streetViewControl: false,
            streetViewControlOptions: {
                position: google.maps.ControlPosition.LEFT_CENTER
            },
            panControl: false,
            panControlOptions: {
                position: google.maps.ControlPosition.LEFT_CENTER
            },
            mapTypeControl: false,
            mapTypeControlOptions: {
                mapTypeIds: [google.maps.MapTypeId.ROADMAP, 'mkd-style'],
                style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR,
                position: google.maps.ControlPosition.LEFT_CENTER
            },
            mapTypeId: googleMapStyleId
        };

        map = new google.maps.Map(document.getElementById(holderId), myOptions);
        map.mapTypes.set('mkd-style', qoogleMapType);

        var index;

        for (index = 0; index < data.length; ++index) {
            mkdInitializeGoogleAddress(data[index], pin, map, geocoder);
        }

        var holderElement = document.getElementById(holderId);
        holderElement.style.height = height;
    }

    /*
     **	Init Google Map Addresses
     */
    function mkdInitializeGoogleAddress(data, pin, map, geocoder) {
        if (data === '')
            return;
        var contentString = '<div id="content">' +
            '<div id="siteNotice">' +
            '</div>' +
            '<div id="bodyContent">' +
            '<p>' + data + '</p>' +
            '</div>' +
            '</div>';
        var infowindow = new google.maps.InfoWindow({
            content: contentString
        });
        geocoder.geocode({'address': data}, function (results, status) {
            if (status === google.maps.GeocoderStatus.OK) {
                map.setCenter(results[0].geometry.location);
                var marker = new google.maps.Marker({
                    map: map,
                    position: results[0].geometry.location,
                    icon: pin,
                    title: data.store_title
                });
                google.maps.event.addListener(marker, 'click', function () {
                    infowindow.open(map, marker);
                });

                google.maps.event.addDomListener(window, 'resize', function () {
                    map.setCenter(results[0].geometry.location);
                });

            }
        });
    }

    function mkdInitAccordions() {
        var accordion = $('.mkd-accordion-holder');
        if (accordion.length) {
            accordion.each(function () {

                var thisAccordion = $(this);

                if (thisAccordion.hasClass('mkd-accordion')) {

                    thisAccordion.accordion({
                        animate: "swing",
                        collapsible: true,
                        active: 0,
                        icons: "",
                        heightStyle: "content"
                    });
                }

                if (thisAccordion.hasClass('mkd-toggle')) {

                    var toggleAccordion = $(this);
                    var toggleAccordionTitle = toggleAccordion.find('.mkd-accordion-title-holder');
                    var toggleAccordionContent = toggleAccordionTitle.next();

                    toggleAccordion.addClass("accordion ui-accordion ui-accordion-icons ui-widget ui-helper-reset");
                    toggleAccordionTitle.addClass("ui-accordion-header ui-helper-reset ui-state-default ui-corner-top ui-corner-bottom");
                    toggleAccordionContent.addClass("ui-accordion-content ui-helper-reset ui-widget-content ui-corner-bottom").hide();

                    toggleAccordionTitle.each(function () {
                        var thisTitle = $(this);

                        thisTitle.hover(function () {
                            thisTitle.toggleClass("ui-state-hover");
                        });

                        thisTitle.on('click', function () {
                            thisTitle.toggleClass('ui-accordion-header-active ui-state-active ui-state-default ui-corner-bottom');
                            thisTitle.next().toggleClass('ui-accordion-content-active').slideToggle(400);
                        });
                    });
                }
            });
        }
    }

    function mkdInitImageGallery() {

        var galleries = $('.mkd-image-gallery');

        if (galleries.length) {
            galleries.each(function () {
                var gallery = $(this).children('.mkd-image-gallery-slider'),
                    loop = (gallery.data('loop') == 'yes'),
                    pause = (gallery.data('pause') == 'yes'),
                    navigation = (gallery.data('navigation') == 'yes'),
                    pagination = (gallery.data('pagination') == 'yes'),
                    autoplay = (gallery.data('autoplay') != 'disable'),
                    autoplayTimeout = 0;

                if (autoplay === true) {
                    autoplayTimeout = gallery.data('autoplay') * 1000;
                }

                gallery.owlCarousel({
                    items: 1,
                    loop: loop,
                    autoplayHoverPause: pause,
                    autoplay: autoplay,
                    autoplayTimeout: autoplayTimeout,
                    dots: pagination,
                    nav: navigation,
                    navText: [
                        '<span class="mkd-prev-icon"><i class="arrow_carrot-left"></i></span>',
                        '<span class="mkd-next-icon"><i class="arrow_carrot-right"></i></span>'
                    ],
                    onInitialized: function () {
                        gallery.css({'opacity': 1});
                    },
                    onInitialize: function () {
                        if (contentSlider.find('.mkd-content-slider-item').length <= 1) {
                            this.settings.loop = false;
                        }
                    }
                });
            });
        }
    }

    // init charts shortcode
    function mkdInitCharts() {
        var chartHolder = $('.mkd-charts');

        if (chartHolder.length) {
            chartHolder.each(function () {
                var thisChartHolder = $(this);
                var thisChartCanvasId = thisChartHolder.find('canvas').attr('id');

                thisChartHolder.height(thisChartHolder.width() / 2);

                //////////////////////////////////////////////////////////////////////////////
                // prep vars from data atts

                var chartType = thisChartHolder.data('type');
                var noOfDatasets = thisChartHolder.data('no_of_used_datasets');
                var pointGroupLabels = thisChartHolder.data('point_group_labels');
                var legendPosition = thisChartHolder.data('legend_position');
                var startAtZero = '';

                if (chartType == 'line' || chartType == 'horizontalBar' || chartType == 'bar') {
                    startAtZero = {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true
                            }
                        }],
                        xAxes: [{
                            ticks: {
                                beginAtZero: true
                            }
                        }]
                    };
                }

                //////////////////////////////////////////////////////////////////////////////

                var dataset_1,
                    dataset_1_color,
                    dataset_2,
                    dataset_2_color,
                    dataset_3,
                    dataset_3_color,
                    datasets;

                if (thisChartHolder.data('color_scheme') == 'dataset') {
                    dataset_1_color = thisChartHolder.data('dataset_1_color');
                }
                else {
                    dataset_1_color = thisChartHolder.data('point_group_colors').split(',');
                }

                dataset_1 = {
                    label: thisChartHolder.data('dataset_1_label'),
                    backgroundColor: dataset_1_color,
                    data: thisChartHolder.data('dataset_1').split(','),
                    cubicInterpolationMode: 'monotone'
                };

                datasets = [dataset_1];

                if (noOfDatasets >= 2) {
                    if (thisChartHolder.data('color_scheme') == 'dataset') {
                        dataset_2_color = thisChartHolder.data('dataset_2_color');
                    }
                    else {
                        dataset_2_color = thisChartHolder.data('point_group_colors').split(',');
                    }

                    dataset_2 = {
                        label: thisChartHolder.data('dataset_2_label'),
                        backgroundColor: dataset_2_color,
                        data: thisChartHolder.data('dataset_2').split(','),
                        cubicInterpolationMode: 'monotone'
                    };

                    datasets = [dataset_1, dataset_2];
                }

                if (noOfDatasets >= 3) {
                    if (thisChartHolder.data('color_scheme') == 'dataset') {
                        dataset_3_color = thisChartHolder.data('dataset_3_color');
                    }
                    else {
                        dataset_3_color = thisChartHolder.data('point_group_colors').split(',');
                    }

                    dataset_3 = {
                        label: thisChartHolder.data('dataset_3_label'),
                        backgroundColor: dataset_3_color,
                        data: thisChartHolder.data('dataset_3').split(','),
                        cubicInterpolationMode: 'monotone'
                    };

                    datasets = [dataset_1, dataset_2, dataset_3];
                }

                // there is probably better way of doing init than the following one
                var thisChartParams = {
                    labels: pointGroupLabels.split(','),
                    datasets: datasets
                };

                //////////////////////////////////////////////////////////////////////////////

                var ctx = document.getElementById(thisChartCanvasId).getContext('2d');


                thisChartHolder.appear(function () {
                    thisChartHolder.addClass('mkd-appeared');

                    setTimeout(function () {

                        window.myBar = new Chart(ctx, {
                            type: chartType,
                            data: thisChartParams,
                            options: {
                                responsive: true,
                                legend: {
                                    position: legendPosition,
                                },
                                scales: startAtZero,
                            },
                        });


                    }, 500);
                }, {accX: 0, accY: mkdGlobalVars.vars.mkdElementAppearAmount});


            });
        }
    }


    function mkdResizeMasonry(size, container) {

        var defaultMasonryItem = container.find('.mkd-default-masonry-item');
        var largeWidthMasonryItem = container.find('.mkd-large-width-masonry-item');
        var largeHeightMasonryItem = container.find('.mkd-large-height-masonry-item');
        var largeWidthHeightMasonryItem = container.find('.mkd-large-width-height-masonry-item');

        defaultMasonryItem.css('height', size);
        largeHeightMasonryItem.css('height', Math.round(2 * size));

        if (mkd.windowWidth > 600) {
            largeWidthHeightMasonryItem.css('height', Math.round(2 * size));
            largeWidthMasonryItem.css('height', size);
        } else {
            largeWidthHeightMasonryItem.css('height', size);
            largeWidthMasonryItem.css('height', Math.round(size / 2));

        }
    }

    // animate workflow shortcode
    function mkdInitWorkflow() {
        var workflowShortcodes = $('.mkd-workflow');
        if (workflowShortcodes.length) {
            workflowShortcodes.each(function () {
                var workflowShortcode = $(this);
                if (workflowShortcode.hasClass('mkd-workflow-animate')) {
                    var workflowItems = workflowShortcode.find('.mkd-workflow-item');

                    workflowShortcode.appear(function () {
                        workflowShortcode.addClass('mkd-appeared');
                        setTimeout(function () {
                            workflowItems.each(function (i) {
                                var workflowItem = $(this);
                                setTimeout(function () {
                                    workflowItem.addClass('mkd-appeared');
                                }, 350 * i);
                            });
                        }, 350);
                    }, {accX: 0, accY: mkdGlobalVars.vars.mkdElementAppearAmount});

                }
            });
        }
    }


    /**
     * List object that initializes list with animation
     * @type {Function}
     */
    var mkdInitList = mkd.modules.shortcodes.mkdInitList = function () {
        var list = $('.mkd-animate-list');

        /**
         * Initializes icon list animation
         * @param list current list shortcode
         */
        var listInit = function (list) {
            setTimeout(function () {
                list.appear(function () {
                    list.addClass('mkd-appeared');
                }, {accX: 0, accY: mkdGlobalVars.vars.mkdElementAppearAmount});
            }, 30);
        };

        return {
            init: function () {
                if (list.length) {
                    list.each(function () {
                        listInit($(this));
                    });
                }
            }
        };
    };

})(jQuery);