<?php
namespace Highrise\Modules\Shortcodes\Lib;

use Highrise\Modules\Shortcodes\AccordionHolder\AccordionHolder;
use Highrise\Modules\Shortcodes\Accordion\Accordion;
use Highrise\Modules\Shortcodes\AnimationHolder\AnimationHolder;
use Highrise\Modules\Shortcodes\Blockquote\Blockquote;
use Highrise\Modules\Shortcodes\BlogList\BlogList;
use Highrise\Modules\Shortcodes\Button\Button;
use Highrise\Modules\Shortcodes\CallToAction\CallToAction;
use Highrise\Modules\Shortcodes\Charts\Charts;
use Highrise\Modules\Shortcodes\ContentSliderHolder\ContentSliderHolder;
use Highrise\Modules\Shortcodes\ContentSlider\ContentSlider;
use Highrise\Modules\Shortcodes\Counter\Countdown;
use Highrise\Modules\Shortcodes\Counter\Counter;
use Highrise\Modules\Shortcodes\CustomFont\CustomFont;
use Highrise\Modules\Shortcodes\Dropcaps\Dropcaps;
use Highrise\Modules\Shortcodes\ElementsHolder\ElementsHolder;
use Highrise\Modules\Shortcodes\ElementsHolderItem\ElementsHolderItem;
//use Highrise\Modules\Shortcodes\FrameSlider\FrameSlider;
use Highrise\Modules\Shortcodes\GoogleMap\GoogleMap;
use Highrise\Modules\Shortcodes\Highlight\Highlight;
use Highrise\Modules\Shortcodes\Icon\Icon;
use Highrise\Modules\Shortcodes\IconWithText\IconWithText;
use Highrise\Modules\Shortcodes\ImageGallery\ImageGallery;
use Highrise\Modules\Shortcodes\InfoBox\InfoBox;
use Highrise\Modules\Shortcodes\ImageWithHoverInfo\ImageWithHoverInfo;
use Highrise\Modules\Shortcodes\ImageWithHoverInfoItem\ImageWithHoverInfoItem;
use Highrise\Modules\Shortcodes\InteractiveBanner\InteractiveBanner;
use Highrise\Modules\Shortcodes\Lists\Lists;
use Highrise\Modules\Shortcodes\Message\Message;
use Highrise\Modules\Shortcodes\PricingSlider\PricingSlider;
use Highrise\Modules\Shortcodes\PricingTableHolder\PricingTableHolder;
use Highrise\Modules\Shortcodes\PricingTable\PricingTable;
use Highrise\Modules\Shortcodes\ProcessHolder\ProcessHolder;
use Highrise\Modules\Shortcodes\Process\Process;
use Highrise\Modules\Shortcodes\ProgressBar\ProgressBar;
use Highrise\Modules\Shortcodes\ProgressCircle\ProgressCircle;
use Highrise\Modules\Shortcodes\SectionTitle\SectionTitle;
use Highrise\Modules\Shortcodes\Separator\Separator;
use Highrise\Modules\Shortcodes\ServiceTable\ServiceTable;
use Highrise\Modules\Shortcodes\SocialShare\SocialShare;
use Highrise\Modules\Shortcodes\TabHolder\TabHolder;
use Highrise\Modules\Shortcodes\Tab\Tab;
use Highrise\Modules\Shortcodes\Team\Team;
use Highrise\Modules\Shortcodes\TwitterSlider\TwitterSlider;
use Highrise\Modules\Shortcodes\VideoBanner\VideoBanner;
use Highrise\Modules\Shortcodes\VideoButton\VideoButton;
use Highrise\Modules\Shortcodes\Workflow\Workflow;
use Highrise\Modules\Shortcodes\WorkflowItem\WorkflowItem;


/**
 * Class ShortcodeLoader
 */
class ShortcodeLoader
{
    /**
     * @var private instance of current class
     */
    private static $instance;
    /**
     * @var array
     */
    private $loadedShortcodes = array();

    /**
     * Private constuct because of Singletone
     */
    private function __construct() {
    }

    /**
     * Private sleep because of Singletone
     */
    private function __wakeup() {
    }

    /**
     * Private clone because of Singletone
     */
    private function __clone() {
    }

    /**
     * Returns current instance of class
     * @return ShortcodeLoader
     */
    public static function getInstance() {
        if (self::$instance == null) {
            return new self;
        }

        return self::$instance;
    }

    /**
     * Adds new shortcode. Object that it takes must implement ShortcodeInterface
     * @param ShortcodeInterface $shortcode
     */
    private function addShortcode(ShortcodeInterface $shortcode) {
        if (!array_key_exists($shortcode->getBase(), $this->loadedShortcodes)) {
            $this->loadedShortcodes[$shortcode->getBase()] = $shortcode;
        }
    }

    /**
     * Adds all shortcodes.
     *
     * @see ShortcodeLoader::addShortcode()
     */
    private function addShortcodes() {
        $this->addShortcode(new AccordionHolder());
        $this->addShortcode(new Accordion());
        $this->addShortcode(new AnimationHolder());
        $this->addShortcode(new Blockquote());
        $this->addShortcode(new BlogList());
        $this->addShortcode(new Button());
        $this->addShortcode(new CallToAction());
        $this->addShortcode(new Charts());
        $this->addShortcode(new ContentSliderHolder());
        $this->addShortcode(new ContentSlider());
        $this->addShortcode(new Counter());
        $this->addShortcode(new Countdown());
        $this->addShortcode(new CustomFont());
        $this->addShortcode(new Dropcaps());
        $this->addShortcode(new ElementsHolder());
        $this->addShortcode(new ElementsHolderItem());
        //$this->addShortcode(new FrameSlider());
        $this->addShortcode(new GoogleMap());
        $this->addShortcode(new Highlight());
        $this->addShortcode(new Icon());
        $this->addShortcode(new IconWithText());
        $this->addShortcode(new ImageGallery());
        $this->addShortcode(new ImageWithHoverInfo());
        $this->addShortcode(new ImageWithHoverInfoItem());
        $this->addShortcode(new InteractiveBanner());
        $this->addShortcode(new InfoBox());
        $this->addShortcode(new Lists());
        $this->addShortcode(new Message());
        $this->addShortcode(new PricingSlider());
        $this->addShortcode(new PricingTableHolder());
        $this->addShortcode(new PricingTable());
        $this->addShortcode(new ProcessHolder());
        $this->addShortcode(new Process());
        $this->addShortcode(new ProgressBar());
        $this->addShortcode(new ProgressCircle());
        $this->addShortcode(new SectionTitle());
        $this->addShortcode(new Separator());
        $this->addShortcode(new ServiceTable());
        $this->addShortcode(new SocialShare());
        $this->addShortcode(new TabHolder());
        $this->addShortcode(new Tab());
        $this->addShortcode(new Team());
        $this->addShortcode(new TwitterSlider());
        $this->addShortcode(new VideoBanner());
        $this->addShortcode(new VideoButton());
        $this->addShortcode(new Workflow());
        $this->addShortcode(new WorkflowItem());
    }

    /**
     * Calls ShortcodeLoader::addShortcodes and than loops through added shortcodes and calls render method
     * of each shortcode object
     */
    public function load() {
        $this->addShortcodes();

        foreach ($this->loadedShortcodes as $shortcode) {
            add_shortcode($shortcode->getBase(), array($shortcode, 'render'));
        }
    }
}

$shortcodeLoader = ShortcodeLoader::getInstance();
$shortcodeLoader->load();